/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.nav;

import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.RevertNodeCommand;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Node;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.nav.SVNRemoteContainer;
import oracle.jdevimpl.vcs.svn.nav.SVNRemoteNode;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoriesFilterNode;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoriesNode;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryNavigatorAPI;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryNode;
import oracle.jdevimpl.vcs.svn.nav.cmd.DeleteConnectionCommand;
import oracle.jdevimpl.vcs.svn.nav.cmd.DeleteRemoteResourceCommand;
import oracle.jdevimpl.vcs.svn.nav.cmd.EditConnectionCommand;
import oracle.jdevimpl.vcs.svn.nav.cmd.NewConnectionCommand;
import oracle.jdevimpl.vcs.svn.op.SVNOperationNewRemoteDir;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;

public final class SVNNavigatorController
implements Controller {
    public boolean handleEvent(IdeAction action, Context ctx) {
        if (ctx == null) {
            return false;
        }
        Node node = ctx.getNode();
        if (SVNUtil.isRepositoryNavigatorView(ctx.getView())) {
            if (action.getCommandId() == 20) {
                if (node instanceof SVNRepositoryNode) {
                    this.invokeCommand(ctx, new DeleteConnectionCommand());
                    return true;
                }
                if (node instanceof SVNRemoteNode) {
                    this.invokeCommand(ctx, new DeleteRemoteResourceCommand());
                    return true;
                }
            }
            if (action.getCommandId() == 51) {
                RevertNodeCommand.reload((Context)ctx, (boolean)false);
                return true;
            }
            if (action.getCommandId() == 56 && node != null && node instanceof SVNRepositoryNode) {
                this.invokeCommand(ctx, new EditConnectionCommand());
                return true;
            }
            if (action.getCommandId() == Ide.findCmdID((String)"oracle.jdeveloper.subversion.new-connection").intValue()) {
                this.invokeCommand(ctx, new NewConnectionCommand());
                return true;
            }
            if (action.getCommandId() == Ide.findCmdID((String)"oracle.jdeveloper.subversion.new-remote-directory").intValue()) {
                this.invokeCommand(ctx, (Command)new SVNOperationNewRemoteDir());
                return true;
            }
        }
        return false;
    }

    public boolean update(IdeAction action, Context ctx) {
        if (ctx == null) {
            return false;
        }
        SVNRepositoryNavigatorAPI navApi = SVNRepositoryNavigatorAPI.getInstance();
        Node node = ctx.getNode();
        if (SVNUtil.isRepositoryNavigatorView(ctx.getView())) {
            if (action.getCommandId() == 20 && ctx.getSelection().length > 1) {
                action.setEnabled(false);
                return true;
            }
            if (action.getCommandId() == 20 && (node instanceof SVNRepositoriesNode || node instanceof SVNRepositoriesFilterNode)) {
                action.setEnabled(false);
                return true;
            }
            if (action.getCommandId() == 51 && (node instanceof SVNRepositoriesNode || node instanceof SVNRepositoriesFilterNode)) {
                action.setEnabled(false);
                return true;
            }
            if (action.getCommandId() == 20 && node instanceof SVNRemoteNode) {
                action.setEnabled(node != null && navApi.canRemove(node));
                return true;
            }
            if (action.getCommandId() == 51 && node instanceof SVNRemoteNode) {
                action.setEnabled(navApi.canRefresh(node));
                return true;
            }
            if (action.getCommandId() == 56 && node instanceof SVNRepositoryNode) {
                action.setEnabled(true);
                return true;
            }
            if (action.getCommandId() == Ide.findCmdID((String)"oracle.jdeveloper.subversion.new-connection").intValue()) {
                action.setEnabled(node instanceof SVNRepositoriesNode);
                return true;
            }
            if (action.getCommandId() == Ide.findCmdID((String)"oracle.jdeveloper.subversion.new-remote-directory").intValue()) {
                action.setEnabled(node instanceof SVNRemoteContainer);
                return true;
            }
        }
        return false;
    }

    private void invokeCommand(Context ctx, Command command) {
        try {
            command.setContext(ctx);
            CommandProcessor.getInstance().invoke(command);
        }
        catch (Exception e) {
            SVNProfile.getQualifiedLogger(this.getClass().getName()).warning(e.getMessage());
        }
    }
}

