/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.nav;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.util.FastStringBuffer;
import oracle.jdevimpl.vcs.svn.SVNClientInteraction;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryNavigatorAPI;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public final class SVNNavURLFileSystemHelper
extends URLFileSystemHelper {
    private static final String SVN_NAV_PROTOCOL = "ide.scm.svn.nav";

    static URL toNavigatorUrl(SVNUrl svnUrl) {
        return SVNNavURLFileSystemHelper.toNavigatorUrl(svnUrl, null);
    }

    static URL toNavigatorUrl(SVNUrl svnUrl, SVNRevision revision) {
        FastStringBuffer buff = new FastStringBuffer(100);
        buff.append(SVN_NAV_PROTOCOL).append("://");
        String hostname = svnUrl.getHost();
        if (hostname != null && !hostname.equals("")) {
            buff.append(hostname);
            int port = svnUrl.getPort();
            if (port > 0) {
                buff.append(':').append(String.valueOf(port));
            }
        }
        buff.append('/');
        String[] segments = svnUrl.getPathSegments();
        if (segments != null && segments.length > 0) {
            for (int i = 0; i < segments.length; ++i) {
                buff.append(segments[i]);
                if (i + 1 >= segments.length) continue;
                buff.append('/');
            }
        }
        buff.append('#');
        buff.append(svnUrl.getProtocol());
        if (revision != null) {
            buff.append(';');
            buff.append(revision.toString());
        }
        try {
            return new URL(buff.toString());
        }
        catch (MalformedURLException mfue) {
            SVNProfile.getQualifiedLogger(SVNNavURLFileSystemHelper.class.getName()).warning(mfue.getMessage());
            return null;
        }
    }

    static SVNUrl toSVNUrl(URL navUrl) throws MalformedURLException {
        String path;
        if (navUrl == null || !SVN_NAV_PROTOCOL.equals(navUrl.getProtocol())) {
            return null;
        }
        FastStringBuffer buff = new FastStringBuffer(100);
        String protocol = navUrl.getRef();
        int i = protocol.indexOf(59);
        if (i >= 0) {
            protocol = protocol.substring(0, i);
        }
        buff.append(protocol).append("://");
        String hostname = navUrl.getHost();
        if (hostname != null && !hostname.equals("")) {
            buff.append(hostname);
            int port = navUrl.getPort();
            if (port > 0) {
                buff.append(':').append(String.valueOf(port));
            }
        }
        if (!(path = navUrl.getPath()).startsWith("/")) {
            buff.append('/');
        }
        buff.append(navUrl.getPath());
        return new SVNUrl(buff.toString());
    }

    static SVNRevision getSVNRevision(URL navUrl) {
        String revision = navUrl.getRef();
        int i = revision.indexOf(59);
        try {
            return i >= 0 ? SVNRevision.getRevision((String)revision.substring(i + 1)) : null;
        }
        catch (ParseException pe) {
            FeedbackManager.reportException((Throwable)pe);
            return null;
        }
    }

    public boolean canWrite(URL url) {
        return false;
    }

    public boolean isReadOnly(URL url) {
        return true;
    }

    public boolean exists(URL url) {
        return false;
    }

    public InputStream openInputStream(URL url) throws IOException {
        SVNUrl svnUrl = SVNNavURLFileSystemHelper.toSVNUrl(url);
        try {
            ISVNClientAdapter client = SVNUtil.getClientAdapter(SVNRepositoryNavigatorAPI.CLIENT_CONTEXT);
            SVNClientInteraction.getInstance().beginInteraction(client, SVNUtil.resolveRepository(svnUrl));
            SVNRevision revision = SVNNavURLFileSystemHelper.getSVNRevision(url);
            InputStream inputStream = client.getContent(svnUrl, revision != null ? revision : SVNRevision.HEAD);
            return inputStream;
        }
        catch (SVNClientException ce) {
            SVNProfile.getQualifiedLogger(((Object)((Object)this)).getClass().getName()).severe(ce.getMessage());
            throw new IOException(ce);
        }
        finally {
            SVNClientInteraction.getInstance().endInteraction();
        }
    }
}

