/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.mergewiz.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.FileField;
import oracle.javatools.util.ResourcePicker;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.op.ui.SVNRevisionLister;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class WorkingCopyRevListerPanel
extends JPanel
implements ActionListener {
    private final ResourcePicker _res = ResourcePicker.getPicker(SVNProfile.class);
    private String _labelText;
    private String _revlisterButtonText;
    private JLabel _label;
    private FileField _field;
    private JButton _button;

    public WorkingCopyRevListerPanel(String labelText) {
        super(new GridBagLayout());
        this._labelText = labelText;
        this._revlisterButtonText = this._res.getString("UI_SHOW_REVLISTER_BTN_TEXT");
        this.createComponents();
        this.layoutComponents();
        this.initListeners();
    }

    public WorkingCopyRevListerPanel(String labelText, String revlisterButtonText) {
        super(new GridBagLayout());
        this._labelText = labelText;
        this._revlisterButtonText = revlisterButtonText;
        this.createComponents();
        this.layoutComponents();
        this.initListeners();
    }

    private void createComponents() {
        this._label = new JLabel();
        this._field = new FileField();
        ResourceUtils.resLabel((JLabel)this._label, (Component)this._field, (String)this._labelText);
        this._field.setEditable(false);
        this._button = new JButton();
        this._button.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this._button, (String)this._revlisterButtonText);
    }

    private void layoutComponents() {
        Insets insets = new Insets(6, 2, 2, 6);
        this.add((Component)this._label, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._field, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add((Component)this._button, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, insets, 0, 0));
    }

    private void initListeners() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SVNRevisionLister revLister = new SVNRevisionLister(this.getWCFile(), SVNRevision.HEAD, (SVNRevision)new SVNRevision.Number(0L));
        revLister.showLister();
    }

    public void setFieldEditable(boolean editable) {
        this._field.setEditable(editable);
    }

    public boolean getFieldEditable() {
        return this._field.isEditable();
    }

    public File getWCFile() {
        return new File(this._field.getText());
    }

    public void setWCFile(String fileStr) {
        this._field.setText(fileStr);
    }
}

