/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.mergewiz.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Box;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.util.ResourcePicker;
import oracle.jdevimpl.vcs.svn.SVNClientInteraction;
import oracle.jdevimpl.vcs.svn.SVNExecutorService;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.mergewiz.SVNMergeWizard;
import oracle.jdevimpl.vcs.svn.mergewiz.SVNMergeWizardModel;
import oracle.jdevimpl.vcs.svn.mergewiz.ui.HeadRevisionSelectionPanel;
import oracle.jdevimpl.vcs.svn.mergewiz.ui.RevisionRangePanel;
import oracle.jdevimpl.vcs.svn.mergewiz.ui.SVNUrlInputPanel;
import oracle.jdevimpl.vcs.svn.mergewiz.ui.WorkingCopyRevListerPanel;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class TreeMergePanel
extends DefaultTraversablePanel {
    private static final String TRANSIENT_TREE_PATH_KEY = TreeMergePanel.class.getName() + ".treePath";
    private final ResourcePicker _res = ResourcePicker.getPicker(SVNProfile.class);
    private boolean _initialized = false;
    private JMultiLineLabel _hint;
    private SVNMergeWizardModel _model;
    private SVNUrl _svnurl;
    private SVNUrlInputPanel _frominputPanel;
    private SVNUrlInputPanel _toinputPanel;
    private WorkingCopyRevListerPanel _wcRevListerPanel;
    private HeadRevisionSelectionPanel _fromRevisionPanel;
    private HeadRevisionSelectionPanel _toRevisionPanel;

    public TreeMergePanel() {
        this.setLayout(new GridBagLayout());
    }

    public void onEntry(TraversableContext dataContext) {
        this._model = (SVNMergeWizardModel)dataContext.get(SVNMergeWizard.DATA_KEY);
        this.initialize();
        this.updateMergeURL();
        File resourceFile = SVNUtil.toFile(this._model.getResourceUrl());
        this._wcRevListerPanel.setWCFile(resourceFile.toString());
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        this._model = (SVNMergeWizardModel)dataContext.get(SVNMergeWizard.DATA_KEY);
        URL resourceUrl = this._model.getResourceUrl();
        File resourceFile = SVNUtil.toFile(resourceUrl);
        this._model.setFromSVNUrl(this._frominputPanel.getSVNUrl());
        this._model.setFromRevision(this._fromRevisionPanel.getRevision());
        this._model.setToSVNUrl(this._toinputPanel.getSVNUrl());
        this._model.setToRevision(this._toRevisionPanel.getRevision());
        this._model.setLocalPath(resourceFile);
    }

    private void updateMergeURL() {
        SVNExecutorService executor = SVNExecutorService.getInstance();
        Thread suggestionThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                URL resourceUrl = TreeMergePanel.this._model.getResourceUrl();
                File resourceFile = SVNUtil.toFile(resourceUrl);
                String[] suggestedStrs = null;
                String svnurlStr = null;
                try {
                    ISVNClientAdapter client = SVNUtil.getIDEClientAdapter();
                    TreeMergePanel.this._svnurl = client.getInfoFromWorkingCopy(resourceFile).getUrl();
                    TreeMergePanel.this._frominputPanel.setComboBox(new String[]{TreeMergePanel.this._svnurl.toString()}, TreeMergePanel.this._svnurl.toString());
                    TreeMergePanel.this._toinputPanel.setComboBox(new String[]{TreeMergePanel.this._svnurl.toString()}, TreeMergePanel.this._svnurl.toString());
                    SVNRepositoryInfo repoInfo = SVNUtil.resolveRepository(TreeMergePanel.this._svnurl);
                    SVNClientInteraction.getInstance().beginInteraction(client, repoInfo);
                    suggestedStrs = client.suggestMergeSources(resourceFile);
                    svnurlStr = TreeMergePanel.this._svnurl.toString();
                    SVNClientInteraction.getInstance().endInteraction();
                }
                catch (SVNClientException e) {
                    try {
                        SVNProfile.getQualifiedLogger(RevisionRangePanel.class.getName()).warning(e.getMessage());
                        SVNClientInteraction.getInstance().endInteraction();
                    }
                    catch (Throwable throwable) {
                        SVNClientInteraction.getInstance().endInteraction();
                        List<String> suggestedList = Arrays.asList(suggestedStrs);
                        if (suggestedList.size() == 0 || !suggestedList.contains(svnurlStr)) {
                            suggestedList = new LinkedList(suggestedList);
                            ((LinkedList)suggestedList).addFirst(svnurlStr);
                            suggestedStrs = suggestedList.toArray(new String[0]);
                        }
                        TreeMergePanel.this._frominputPanel.setComboBox(suggestedStrs, svnurlStr);
                        TreeMergePanel.this._toinputPanel.setComboBox(suggestedStrs, svnurlStr);
                        throw throwable;
                    }
                    List<String> suggestedList = Arrays.asList(suggestedStrs);
                    if (suggestedList.size() == 0 || !suggestedList.contains(svnurlStr)) {
                        suggestedList = new LinkedList(suggestedList);
                        ((LinkedList)suggestedList).addFirst(svnurlStr);
                        suggestedStrs = suggestedList.toArray(new String[0]);
                    }
                    TreeMergePanel.this._frominputPanel.setComboBox(suggestedStrs, svnurlStr);
                    TreeMergePanel.this._toinputPanel.setComboBox(suggestedStrs, svnurlStr);
                }
                List<String> suggestedList = Arrays.asList(suggestedStrs);
                if (suggestedList.size() == 0 || !suggestedList.contains(svnurlStr)) {
                    suggestedList = new LinkedList<String>(suggestedList);
                    ((LinkedList)suggestedList).addFirst(svnurlStr);
                    suggestedStrs = suggestedList.toArray(new String[0]);
                }
                TreeMergePanel.this._frominputPanel.setComboBox(suggestedStrs, svnurlStr);
                TreeMergePanel.this._toinputPanel.setComboBox(suggestedStrs, svnurlStr);
            }
        };
        executor.activate();
        executor.submit(suggestionThread);
    }

    private synchronized void initialize() {
        if (this._initialized) {
            return;
        }
        this.createComponents();
        this.layoutComponents();
        this.initListeners();
        this._initialized = true;
    }

    private void createComponents() {
        this._hint = new JMultiLineLabel();
        this._hint.setText(this._res.getString("MERGE_UI_TREEMERGE_HINT"));
        this._frominputPanel = new SVNUrlInputPanel(this._res.getString("UI_TREEMERGEPANEL_FROM_URL_TEXT"));
        this._frominputPanel.setModel(this._model);
        this._fromRevisionPanel = new HeadRevisionSelectionPanel(this._frominputPanel);
        this._toinputPanel = new SVNUrlInputPanel(this._res.getString("UI_TREEMERGEPANEL_TO_URL_TEXT"));
        this._toinputPanel.setModel(this._model);
        this._toRevisionPanel = new HeadRevisionSelectionPanel(this._toinputPanel);
        this._wcRevListerPanel = new WorkingCopyRevListerPanel(this._res.getString("UI_HEADREVISIONSELECTIONPANEL_WCREVLISTER_TEXT"));
    }

    private void layoutComponents() {
        Insets insets = new Insets(6, 2, 2, 6);
        this.add((Component)this._hint, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 15, 0), 0, 0));
        this.add(this._frominputPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add(this._fromRevisionPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add(this._toinputPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add(this._toRevisionPanel, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add(this._wcRevListerPanel, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add(Box.createVerticalGlue(), new GridBagConstraints(0, 6, 1, 1, 0.0, 1.0, 15, 3, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void initListeners() {
    }
}

