/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.mergewiz;

import java.net.URL;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfiles;
import oracle.jdeveloper.vcs.spi.VCSFileEventSender;
import oracle.jdeveloper.vcs.spi.VCSStatusCache;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.SVNURLInfoCache;
import oracle.jdevimpl.vcs.svn.mergewiz.SVNMergeWizardModel;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class MergeOperation
extends Thread {
    private int _mergeType = 0;
    private SVNMergeWizardModel _model;
    private boolean _dryrun;

    public MergeOperation(SVNMergeWizardModel model, boolean dryrun) {
        this._model = model;
        this._dryrun = dryrun;
    }

    @Override
    public void run() {
        this._mergeType = this._model.getMergeType();
        switch (this._mergeType) {
            case 0: {
                this.doRangeMerge();
                break;
            }
            case 1: {
                this.doIntegrateMerge();
                break;
            }
            case 2: {
                this.doTreeMerge();
            }
        }
        if (!this._dryrun) {
            this.updateCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRangeMerge() {
        ISVNClientAdapter client = null;
        try {
            client = SVNUtil.getIDEClientAdapter();
            SVNRepositoryInfo repoInfo = SVNUtil.resolveRepository(this._model.getFromSVNUrl());
            SVNOperationLogger.getInstance().beginOperation(client, repoInfo);
            client.merge(this._model.getFromSVNUrl(), SVNRevision.HEAD, this._model.getFromRevisionRanges(), this._model.getLocalPath(), this._model.isForce(), this._model.getDepth(), this._model.isIgnoreAncestry(), this._dryrun, this._model.isRecordOnly());
        }
        catch (SVNClientException e) {
            SVNProfile.getQualifiedLogger(MergeOperation.class.getName()).warning(e.getMessage());
        }
        finally {
            SVNOperationLogger.getInstance().endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doIntegrateMerge() {
        ISVNClientAdapter client = null;
        try {
            client = SVNUtil.getIDEClientAdapter();
            SVNRepositoryInfo repoInfo = SVNUtil.resolveRepository(this._model.getFromSVNUrl());
            SVNOperationLogger.getInstance().beginOperation(client, repoInfo);
            client.mergeReintegrate(this._model.getFromSVNUrl(), SVNRevision.HEAD, this._model.getLocalPath(), this._model.isForce(), this._dryrun);
        }
        catch (SVNClientException e) {
            SVNProfile.getQualifiedLogger(MergeOperation.class.getName()).warning(e.getMessage());
        }
        finally {
            SVNOperationLogger.getInstance().endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTreeMerge() {
        ISVNClientAdapter client = null;
        try {
            client = SVNUtil.getIDEClientAdapter();
            SVNRepositoryInfo repoInfo = SVNUtil.resolveRepository(this._model.getFromSVNUrl());
            SVNOperationLogger.getInstance().beginOperation(client, repoInfo);
            client.merge(this._model.getFromSVNUrl(), this._model.getFromRevision(), this._model.getToSVNUrl(), this._model.getToRevision(), this._model.getLocalPath(), this._model.isForce(), this._model.getDepth(), this._dryrun, this._model.isIgnoreAncestry(), this._model.isRecordOnly());
        }
        catch (SVNClientException e) {
            SVNProfile.getQualifiedLogger(MergeOperation.class.getName()).warning(e.getMessage());
        }
        finally {
            SVNOperationLogger.getInstance().endOperation();
        }
    }

    private void updateCache() {
        VCSProfile profile = VCSProfiles.getInstance().getProfile("oracle.jdeveloper.subversion");
        URL localUrl = SVNUtil.toURL(this._model.getLocalPath());
        URL parent = URLFileSystem.isDirectoryPath((URL)localUrl) ? localUrl : URLFileSystem.getParent((URL)localUrl);
        BaseURLFilter filter = new BaseURLFilter(parent);
        VCSStatusCache statusCache = profile.getStatusCache();
        statusCache.clear((URLFilter)filter);
        SVNURLInfoCache svnurlInfoCache = SVNURLInfoCache.getInstance();
        svnurlInfoCache.clear(filter);
        VCSFileEventSender.fireFileStructureChanged((URL[])new URL[]{parent});
    }

    private class BaseURLFilter
    implements URLFilter {
        private URL _wcRoot;

        public BaseURLFilter(URL wcRoot) {
            this._wcRoot = wcRoot;
        }

        public boolean accept(URL url) {
            if (this._wcRoot == null || url == null) {
                return false;
            }
            return URLFileSystem.isBaseURLFor((URL)this._wcRoot, (URL)url);
        }
    }
}

