/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.merge;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.ide.Context;
import oracle.ide.help.HelpInfo;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.util.ResourcePicker;
import oracle.jdeveloper.compare.URLContributor;
import oracle.jdeveloper.merge.MergeContext;
import oracle.jdeveloper.merge.MergeEngine;
import oracle.jdeveloper.merge.TextMergeEditor;
import oracle.jdeveloper.vcs.generic.VCSProfiles;
import oracle.jdeveloper.vcs.spi.VCSPropertyMap;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.prefs.SVNVersionToolsPreferences;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public final class SVNMergeEditor
extends TextMergeEditor {
    private static final ResourcePicker sRes = ResourcePicker.getPicker(SVNProfile.class);

    protected void initializeMergeContextCS(Context context) throws IOException {
        URL url = context.getNode().getURL();
        final String fileName = URLFileSystem.getFileName((URL)url);
        URL parentUrl = URLFileSystem.getParent((URL)url);
        URL edit1Url = URLFactory.newURL((URL)parentUrl, (String)(fileName + ".mine"));
        if (!URLFileSystem.exists((URL)edit1Url)) {
            MergeContext.setClientSideMerge((Context)context, (boolean)false);
            return;
        }
        URL[] revisionUrls = URLFileSystem.list((URL)parentUrl, (URLFilter)new URLFilter(){

            public boolean accept(URL url) {
                return URLFileSystem.getFileName((URL)url).matches(fileName + "\\.r[\\.\\d]+");
            }
        });
        if (revisionUrls.length < 2) {
            MergeContext.setClientSideMerge((Context)context, (boolean)false);
            return;
        }
        Arrays.sort(revisionUrls, new Comparator<URL>(){

            @Override
            public int compare(URL url1, URL url2) {
                return this.parseRevision(url1) - this.parseRevision(url2);
            }

            private int parseRevision(URL url) {
                Matcher matcher = Pattern.compile("\\.r(.*)").matcher(URLFileSystem.getSuffix((URL)url));
                try {
                    return matcher.matches() ? Integer.parseInt(matcher.group(1)) : 0;
                }
                catch (NumberFormatException nfe) {
                    return 0;
                }
            }
        });
        String type = this.getSuffixAsType(url);
        URLContributor contributor = new URLContributor(edit1Url);
        contributor.setType(type);
        MergeContext.setFirstContributor((Context)context, (CompareContributor)contributor);
        contributor = new URLContributor(revisionUrls[1]);
        contributor.setType(type);
        MergeContext.setSecondContributor((Context)context, (CompareContributor)contributor);
        contributor = new URLContributor(revisionUrls[0]);
        contributor.setType(type);
        MergeContext.setAncestorContributor((Context)context, (CompareContributor)contributor);
        MergeContext.setMergeEngine((Context)context, (MergeEngine)MergeEngine.getInstance());
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_svnmergetool_html");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean saveMergeImpl(Context context, CompareModel compareModel) throws IOException {
        if (!super.saveMergeImpl(context, compareModel)) {
            return false;
        }
        ISVNClientAdapter client = null;
        try {
            URL url = context.getNode().getURL();
            if (!SVNUtil.isPropertiesConflicted(url)) {
                client = SVNUtil.getIDEClientAdapter();
                SVNOperationLogger.getInstance().beginOperation(client, null);
                try {
                    client.resolved(SVNUtil.toFile(url));
                }
                finally {
                    SVNOperationLogger.getInstance().endOperation();
                    VCSProfiles.getInstance().getProfile("oracle.jdeveloper.subversion").getStatusCache().clear(url);
                }
            }
            return true;
        }
        catch (SVNClientException ce) {
            throw new IOException(ce.getMessage());
        }
    }

    protected String createFirstContributorLabelSS() {
        HashSet annotations = new HashSet(this.getDiff3Model().getSourceAnnotations().values());
        Iterator it = annotations.iterator();
        if (it.hasNext()) {
            return it.next().toString();
        }
        return sRes.getString("MERGE_LABEL_UNKNOWN_REVISION");
    }

    protected boolean getClientSideMergeSetting() {
        VCSPropertyMap vtoolsPrefs = VCSProfiles.getInstance().getProfile("oracle.jdeveloper.subversion").getData("VTOOLS_SETTINGS");
        Integer mergeEditor = (Integer)vtoolsPrefs.getMap().get("mergeEditor");
        return mergeEditor == null || mergeEditor.equals(SVNVersionToolsPreferences.PROP_VALUE_MERGE_EDITOR_CLIENT);
    }
}

