/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.imp;

import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.TraversableContext;
import oracle.ide.wizard.FinishPanel;
import oracle.javatools.util.ResourcePicker;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.imp.SVNImportModel;
import oracle.jdevimpl.vcs.svn.imp.SVNImportWizard;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.utils.SVNUrlUtils;

public final class SummaryPanel
extends FinishPanel {
    private final ResourcePicker _res = ResourcePicker.getPicker(SVNProfile.class);
    private boolean _initialized = false;
    private JTree _tree;
    private DefaultMutableTreeNode _destinationNode;
    private DefaultMutableTreeNode _sourceNode;
    private DefaultMutableTreeNode _filtersNode;
    private DefaultMutableTreeNode _othersNode;

    public void onEntry(TraversableContext ctx) {
        super.onEntry(ctx);
        this.initialize();
        SVNImportModel model = (SVNImportModel)ctx.get(SVNImportWizard.DATA_KEY);
        DefaultTreeModel treeModel = (DefaultTreeModel)this._tree.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)treeModel.getRoot();
        root.removeAllChildren();
        MutableTreeNode[] summaryNodes = this.populateSummaryNodes(model);
        for (int i = 0; i < summaryNodes.length; ++i) {
            root.add(summaryNodes[i]);
        }
        treeModel.reload(root);
        this.expandSummaryTree();
    }

    private MutableTreeNode[] populateSummaryNodes(SVNImportModel model) {
        ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>(7);
        this._destinationNode.removeAllChildren();
        String alias = model.getRepository().getAlias();
        if (alias != null && alias.length() > 0) {
            this._destinationNode.add(new DefaultMutableTreeNode(this._res.getString("IMPORT_UI_SUMMARY_REPOS_ALIAS", (Object)alias)));
            String relativePath = SVNUrlUtils.getRelativePath((SVNUrl)model.getRepository().getURL(), (SVNUrl)model.getDestinationUrl(), (boolean)false);
            if (relativePath != null && relativePath.trim().length() > 0) {
                this._destinationNode.add(new DefaultMutableTreeNode(this._res.getString("IMPORT_UI_SUMMARY_REPOS_PATH", (Object)relativePath)));
            }
        } else {
            this._destinationNode.add(new DefaultMutableTreeNode(this._res.getString("IMPORT_UI_SUMMARY_REPOS_URL", (Object)model.getDestinationUrl().toString())));
        }
        nodes.add(this._destinationNode);
        this._sourceNode.removeAllChildren();
        this._sourceNode.add(new DefaultMutableTreeNode(this._res.getString("IMPORT_UI_SUMMARY_SOURCE_URL", (Object)URLFileSystem.getPlatformPathName((URL)model.getSourceDirectory()))));
        String comment = model.getComment();
        if (comment != null && comment.trim().length() > 0) {
            this._sourceNode.add(new DefaultMutableTreeNode(this._res.getString("IMPORT_UI_SUMMARY_COMMENT")));
        } else {
            this._sourceNode.add(new DefaultMutableTreeNode(this._res.getString("IMPORT_UI_SUMMARY_NO_COMMENT")));
        }
        nodes.add(this._sourceNode);
        this._filtersNode.removeAllChildren();
        Collection<String> filters = model.getFilters();
        if (filters != null && filters.size() > 0) {
            this._filtersNode.add(new DefaultMutableTreeNode(this._res.getString("IMPORT_UI_SUMMARY_FILTERS", (Object)String.valueOf(filters.size()))));
        } else {
            this._filtersNode.add(new DefaultMutableTreeNode(this._res.getString("IMPORT_UI_SUMMARY_NO_FILTERS")));
        }
        nodes.add(this._filtersNode);
        this._othersNode.removeAllChildren();
        if (!model.getRecursive()) {
            this._othersNode.add(new DefaultMutableTreeNode(this._res.getString("IMPORT_UI_SUMMARY_NORECURSE")));
        }
        if (model.getCheckout()) {
            this._othersNode.add(new DefaultMutableTreeNode(this._res.getString("IMPORT_UI_SUMMARY_CHECKOUT")));
        }
        if (this._othersNode.getChildCount() > 0) {
            nodes.add(this._othersNode);
        }
        return nodes.toArray(new MutableTreeNode[nodes.size()]);
    }

    private synchronized void initialize() {
        if (this._initialized) {
            return;
        }
        this.setFinishText(this._res.getString("IMPORT_UI_SUMMARY_TITLE"));
        this._tree = this.createSummaryTree(this._res.getString("IMPORT_UI_SUMMARY_DESC"));
        this._tree.setShowsRootHandles(true);
        this._tree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                this.setBackgroundNonSelectionColor(tree.getBackground());
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                this.setIcon(null);
                return this;
            }
        });
        this._destinationNode = new DefaultMutableTreeNode(this._res.getString("IMPORT_WIZARD_DESTINATION_TITLE"));
        this._sourceNode = new DefaultMutableTreeNode(this._res.getString("IMPORT_WIZARD_SOURCE_TITLE"));
        this._filtersNode = new DefaultMutableTreeNode(this._res.getString("IMPORT_WIZARD_FILTERS_TITLE"));
        this._othersNode = new DefaultMutableTreeNode(this._res.getString("IMPORT_WIZARD_OTHERS_TITLE"));
        this._initialized = true;
    }
}

