/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.history;

import java.awt.Component;
import java.awt.EventQueue;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.Ide;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.history.HistoryEntry;
import oracle.javatools.util.ResourcePicker;
import oracle.jdeveloper.vcs.generic.HistoryEntryProducer;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.svn.SVNClientInteraction;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.history.SVNHistoryEntry;
import oracle.jdevimpl.vcs.svn.history.SVNWCHistoryEntry;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class SVNHistoryEntryProducer
implements HistoryEntryProducer {
    private static final Logger sLogger = SVNProfile.getQualifiedLogger(SVNHistoryEntryProducer.class.getName());
    public static Object CLIENT_CONTEXT = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HistoryEntry[] produceEntries(URL target) {
        HistoryEntry[] historyEntryArray;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Ide.getWaitCursor().show();
            }
        });
        try {
            ISVNClientAdapter client = SVNUtil.getClientAdapter(CLIENT_CONTEXT);
            SVNRepositoryInfo reposInfo = SVNUtil.getFirstAssociatedRepository(target);
            SVNClientInteraction.getInstance().beginInteraction(client, reposInfo);
            historyEntryArray = this.produceEntries(client, target);
            SVNClientInteraction.getInstance().endInteraction();
        }
        catch (SVNClientException ce) {
            HistoryEntry[] historyEntryArray2;
            try {
                String path = URLFileSystem.getPlatformPathName((URL)target);
                sLogger.log(Level.SEVERE, "unable to mine history for " + path, ce);
                ResourcePicker res = ResourcePicker.getPicker(SVNProfile.class);
                MessageDialog.error((Component)VCSWindowUtils.getCurrentWindow(), (Object)res.getString("HISTROY_PRODUCER_ERROR_MESSAGE", new Object[]{path}), (String)res.getString("HISTROY_PRODUCER_ERROR_TITLE"), null);
                historyEntryArray2 = new HistoryEntry[]{};
                SVNClientInteraction.getInstance().endInteraction();
            }
            catch (Throwable throwable) {
                SVNClientInteraction.getInstance().endInteraction();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Ide.getWaitCursor().hide();
                    }
                });
                throw throwable;
            }
            EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
            return historyEntryArray2;
        }
        EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
        return historyEntryArray;
    }

    private HistoryEntry[] produceEntries(ISVNClientAdapter client, URL target) throws SVNClientException {
        ISVNLogMessage[] logMessages = client.getLogMessages(SVNUtil.toFile(target), SVNRevision.START, SVNRevision.HEAD, false);
        ArrayList<Object> entries = new ArrayList<Object>(logMessages.length * 2);
        entries.add(this.getWorkingCopyEntry(client, target));
        for (int i = 0; i < logMessages.length; ++i) {
            entries.add((Object)new SVNHistoryEntry(target, logMessages[i].getDate(), logMessages[i].getAuthor(), logMessages[i].getRevision().getNumber(), logMessages[i].getMessage()));
        }
        return entries.toArray(new HistoryEntry[entries.size()]);
    }

    private HistoryEntry getWorkingCopyEntry(ISVNClientAdapter client, URL target) throws SVNClientException {
        ISVNInfo info = client.getInfoFromWorkingCopy(SVNUtil.toFile(target));
        return new SVNWCHistoryEntry(target, info.getLastChangedDate(), info.getLastCommitAuthor(), info.getRevision().getNumber());
    }
}

