/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.history;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.util.Date;
import javax.swing.Icon;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.algorithm.directory.DirectoryFile;
import oracle.javatools.compare.algorithm.directory.DirectoryList;
import oracle.javatools.util.ResourcePicker;
import oracle.jdeveloper.history.RevisionIdentifier;
import oracle.jdeveloper.vcs.generic.VCSHistoryEntry;
import oracle.jdeveloper.vcs.generic.VCSProfiles;
import oracle.jdevimpl.vcs.svn.SVNClientInteraction;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.SVNURLInfoCache;
import oracle.jdevimpl.vcs.svn.history.SVNHistoricalContentCache;
import oracle.jdevimpl.vcs.svn.history.SVNHistoryEntryProducer;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNDirEntry;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SVNHistoryEntry
extends VCSHistoryEntry {
    private static final String HISTORY_PROPERTY_AUTHOR_ID = "oracle.jdeveloper.subversion.history.AUTHOR";
    private static final Icon sIcon = ResourcePicker.getPicker(SVNProfile.class).getImage("NAV_ICON_REPOSITORIES_NODE");
    private SVNRevision _revision;

    public SVNHistoryEntry(URL source, Date date, String author, long revision, String message) {
        super(source, VCSProfiles.getInstance().getProfile("oracle.jdeveloper.subversion"));
        this.setValue("oracle.jdeveloper.vcs.history.DATE", date);
        this.setValue(HISTORY_PROPERTY_AUTHOR_ID, author);
        this.setValue("oracle.jdeveloper.vcs.history.DESCRIPTION", message);
        this.setValue("oracle.jdeveloper.vcs.history.REVISION", new RevisionIdentifier(sIcon, String.valueOf(revision)));
    }

    protected InputStream getContent(URL url, RevisionIdentifier rev) throws SVNClientException, ParseException, IOException {
        SVNRevision revision = this.getRevision(rev);
        SVNUrl reposUrl = SVNURLInfoCache.getInstance().getURL(url);
        if (reposUrl == null) {
            throw new IllegalStateException();
        }
        SVNHistoricalContentCache contentCache = SVNHistoricalContentCache.getInstance();
        if (!contentCache.containsRevisionContent(reposUrl, revision)) {
            ISVNClientAdapter client = SVNUtil.getClientAdapter(SVNHistoryEntryProducer.CLIENT_CONTEXT);
            SVNRepositoryInfo reposInfo = SVNUtil.resolveRepository(reposUrl);
            SVNClientInteraction.getInstance().beginInteraction(client, reposInfo);
            contentCache.putRevisionContentStream(reposUrl, revision, client.getContent(reposUrl, revision));
            SVNClientInteraction.getInstance().endInteraction();
        }
        return contentCache.getRevisionContentStream(reposUrl, revision);
    }

    protected DirectoryList listDirectory(URL directoryUrl, RevisionIdentifier revision) throws SVNClientException, ParseException {
        return this.listDirectory(directoryUrl, this.getRevision(revision));
    }

    private DirectoryList listDirectory(final URL directoryUrl, SVNRevision revision) throws SVNClientException, ParseException {
        ISVNClientAdapter client = SVNUtil.getClientAdapter(SVNHistoryEntryProducer.CLIENT_CONTEXT);
        SVNRepositoryInfo reposInfo = SVNUtil.getFirstAssociatedRepository(directoryUrl);
        SVNClientInteraction.getInstance().beginInteraction(client, reposInfo);
        ISVNDirEntry[] dirEntries = client.getList(new File(URLFileSystem.getPlatformPathName((URL)directoryUrl)), revision, false);
        SVNClientInteraction.getInstance().endInteraction();
        DirectoryList directoryList = new DirectoryList();
        for (ISVNDirEntry dirEntry : dirEntries) {
            boolean directory = dirEntry.getNodeKind() == SVNNodeKind.DIR;
            String name = dirEntry.getPath().replace('\\', '/');
            name = name.substring(name.lastIndexOf(47) + 1);
            String id = Long.toString(dirEntry.getLastChangedRevision().getNumber());
            directoryList.appendFile(new DirectoryFile(directory, name, id){

                public CompareContributor createCompareContributor() throws Exception {
                    RevisionIdentifier revision = new RevisionIdentifier(ResourcePicker.getPicker(SVNProfile.class).getImage("NAV_ICON_REPOSITORY_NODE"), this.getID());
                    URL url = this.isDirectory() ? URLFactory.newDirURL((URL)directoryUrl, (String)this.getName()) : URLFactory.newURL((URL)directoryUrl, (String)this.getName());
                    return SVNHistoryEntry.this.createCompareContributor(url, revision, null);
                }
            });
        }
        directoryList.clearModified();
        return directoryList;
    }

    protected String getResourceName(URL url, RevisionIdentifier rev) {
        try {
            return SVNUtil.getCompareIdentifier(url, this.getRevision(rev));
        }
        catch (ParseException pe) {
            return super.getResourceName(url, rev);
        }
    }

    private SVNRevision getRevision(RevisionIdentifier rev) throws ParseException {
        if (this._revision == null) {
            this._revision = SVNRevision.getRevision((String)rev.getLabel());
        }
        return this._revision;
    }
}

