/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.changelist;

import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import oracle.ide.config.GlobalIgnoreList;
import oracle.ide.net.URLFactory;
import oracle.jdeveloper.vcs.changelist.ChangeList;
import oracle.jdeveloper.vcs.changelist.ChangeListEventQueue;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfiles;
import oracle.jdeveloper.vcs.spi.VCSCancellable;
import oracle.jdeveloper.vcs.spi.VCSHashURL;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.SVNURLInfoCache;
import oracle.jdevimpl.vcs.svn.model.SVNURLInfo;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;

public final class SVNOutgoingEventQueue
extends ChangeListEventQueue {
    private final VCSProfile _profile = VCSProfiles.getInstance().getProfile("oracle.jdeveloper.subversion");

    public SVNOutgoingEventQueue(ChangeList changeList) {
        super(changeList);
    }

    protected final boolean supportsRemovedEntries() {
        return true;
    }

    protected final void addRemovedEntryURLs(Collection<VCSHashURL> urls, URL directoryUrl, VCSCancellable cancellable) throws Exception {
        if (!SVNUtil.isWorkingCopy(directoryUrl)) {
            return;
        }
        try {
            Map<VCSHashURL, SVNURLInfo> results = SVNURLInfoCache.getInstance().getDirectoryURLInfo(directoryUrl, false);
            for (Map.Entry<VCSHashURL, SVNURLInfo> entry : results.entrySet()) {
                URL url = entry.getKey().getURL();
                if (!this.isRemovedURL(url, SVNStatusKind.fromInt((int)entry.getValue().getTextStatus()))) continue;
                urls.add(new VCSHashURL(url));
            }
        }
        catch (UnsupportedOperationException uoe) {
            ISVNStatus[] statuses;
            for (ISVNStatus status : statuses = SVNUtil.getClientAdapter(SVNProfile.IDE_CLIENT_CONTEXT_ID, SVNProfile.OC_ADAPTER_CONTEXT_ID).getStatus(SVNUtil.toFile(directoryUrl), false, true, false)) {
                URL url = URLFactory.newFileURL((File)status.getFile());
                if (!this.isRemovedURL(url, status.getTextStatus())) continue;
                urls.add(new VCSHashURL(url));
            }
        }
    }

    private final boolean isRemovedURL(URL url, SVNStatusKind status) {
        return status == SVNStatusKind.DELETED && !GlobalIgnoreList.isGloballyIgnored((URL)url);
    }
}

