/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.changelist;

import java.awt.EventQueue;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.explorer.IconOverlay;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.vcs.changelist.ChangeList;
import oracle.jdeveloper.vcs.changelist.ChangeListEvent;
import oracle.jdeveloper.vcs.changelist.ChangeListEventQueue;
import oracle.jdeveloper.vcs.changelist.ChangeListItem;
import oracle.jdeveloper.vcs.icons.VCSIconArb;
import oracle.jdeveloper.vcs.spi.VCSOverlayItemProducer;
import oracle.jdeveloper.vcs.vop.DisplayableComparator;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.changelist.SVNIncomingChangeList;
import oracle.jdevimpl.vcs.svn.changelist.SVNRemoteStatus;
import oracle.jdevimpl.vcs.svn.changelist.SVNRemoteStatusCache;

public final class SVNIncomingEventQueue
extends ChangeListEventQueue {
    private boolean _taskInProgress;
    private SVNIncomingChangeList _changeList;
    private static final Map sIconReferences = new HashMap(7);

    public SVNIncomingEventQueue(SVNIncomingChangeList changeList) {
        super((ChangeList)changeList);
        this._changeList = changeList;
    }

    protected void setChangeListBusy(boolean isBusy) {
    }

    void setChangeListBusyImpl(boolean isBusy) {
        super.setChangeListBusy(isBusy);
    }

    void setTaskInProgress(boolean taskInProgress) {
        this._taskInProgress = taskInProgress;
    }

    boolean isTaskInProgress() {
        return this._taskInProgress;
    }

    protected void processRequeryEvent(final ChangeListEvent cle) throws Exception {
        SVNRemoteStatusCache statusCache = (SVNRemoteStatusCache)this._changeList.getStatusCache();
        URL[] urls = statusCache.search(this._changeList.getScopeFilter());
        final ArrayList<ChangeListItem> validItems = new ArrayList<ChangeListItem>(Arrays.asList(this.createChangeListItems(urls)));
        Collections.sort(validItems, new DisplayableComparator());
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (cle.isReplace()) {
                    SVNIncomingEventQueue.this._changeList.getModel().replace((Collection)validItems);
                    return;
                }
                SVNIncomingEventQueue.this._changeList.getModel().add((Collection)validItems);
                if (cle.isUpdate()) {
                    SVNIncomingEventQueue.this._changeList.getModel().update((Collection)validItems);
                }
            }
        });
    }

    protected ChangeListItem createChangeListItem(URL url) {
        URL url0 = URLFileSystem.canonicalize((URL)url);
        ChangeListItem cli = super.createChangeListItem(url0);
        VCSOverlayItemProducer overlayItemProducer = this.getChangeList().getOverlayItemProducer();
        Object overlayItem = null;
        IconOverlay iconOverlay = null;
        if (overlayItemProducer != null) {
            try {
                SVNRemoteStatusCache cache = (SVNRemoteStatusCache)this._changeList.getStatusCache();
                SVNRemoteStatus status = (SVNRemoteStatus)cache.getValue(url0);
                int iconkey = ((int[])sIconReferences.get("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_UNVERSIONED"))[0];
                if (status.equals(SVNRemoteStatus.TEXT_MODIFIED) || status.equals(SVNRemoteStatus.PROP_MODIFIED) || status.equals(SVNRemoteStatus.TEXT_PROP_MODIFIED)) {
                    iconkey = ((int[])sIconReferences.get("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_MODIFIED"))[0];
                }
                if (status.equals(SVNRemoteStatus.ADDED)) {
                    iconkey = ((int[])sIconReferences.get("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_ADDED"))[0];
                }
                if (status.equals(SVNRemoteStatus.DELETED)) {
                    iconkey = ((int[])sIconReferences.get("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_REMOVED"))[0];
                }
                iconOverlay = new IconOverlay(VCSIconArb.getInstance().getIconImpl(iconkey), status.getID(), status.getChangeListLabel());
                cli.setOverlay(iconOverlay);
            }
            catch (Exception e) {
                SVNProfile.getQualifiedLogger(((Object)((Object)this)).getClass().getName()).warning(e.getMessage());
            }
        }
        return cli;
    }

    static {
        sIconReferences.put("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_ADDED", new int[]{5});
        sIconReferences.put("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_CHECKED_IN", new int[]{3});
        sIconReferences.put("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_CHECKED_OUT", new int[]{1});
        sIconReferences.put("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_CONFLICTS", new int[]{7});
        sIconReferences.put("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_MODIFIED", new int[]{6});
        sIconReferences.put("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_REMOVED", new int[]{0});
        sIconReferences.put("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_UNADDED", new int[]{4});
        sIconReferences.put("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_UNVERSIONED", new int[]{4});
        sIconReferences.put("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_IGNORED", new int[]{9});
    }
}

