/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.changelist;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.TimerTask;
import oracle.ide.docking.DockStation;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.jdeveloper.vcs.changelist.ChangeList;
import oracle.jdeveloper.vcs.changelist.ChangeListEvent;
import oracle.jdeveloper.vcs.changelist.ChangeListWindow;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfiles;
import oracle.jdeveloper.vcs.spi.VCSHashURL;
import oracle.jdeveloper.vcs.spi.VCSThreadPool;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSURLFilters;
import oracle.jdevimpl.vcs.generic.changelist.ChangeListViewId;
import oracle.jdevimpl.vcs.svn.SVNClientInteraction;
import oracle.jdevimpl.vcs.svn.SVNExceptionHandler;
import oracle.jdevimpl.vcs.svn.SVNExceptionWrapper;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.SVNURLInfoCache;
import oracle.jdevimpl.vcs.svn.changelist.SVNIncomingChangeList;
import oracle.jdevimpl.vcs.svn.changelist.SVNIncomingEventQueue;
import oracle.jdevimpl.vcs.svn.changelist.SVNRemoteStatus;
import oracle.jdevimpl.vcs.svn.changelist.SVNRemoteStatusCache;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.utils.SVNUrlUtils;

public final class SVNIncomingChangesTask
extends TimerTask {
    private final SVNIncomingChangeList _changeList;
    private final SVNIncomingEventQueue _eventQueue;
    private final SVNRemoteStatusCache _statusCache;
    private final VCSThreadPool _threadPool;
    private final URLFilter _scopeFilter;

    public SVNIncomingChangesTask(SVNIncomingChangeList changeList, VCSThreadPool threadPool, URLFilter scopeFilter) {
        this._changeList = changeList;
        this._eventQueue = (SVNIncomingEventQueue)this._changeList.getEventQueue();
        this._statusCache = (SVNRemoteStatusCache)this._changeList.getStatusCache();
        this._threadPool = threadPool;
        this._scopeFilter = scopeFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this._eventQueue == null || this._changeList == null || this._eventQueue.isTaskInProgress() || this._changeList.isBusy() || !this.isChangeListVisible() || SVNClientInteraction.getInstance().isClientInUse()) {
            return;
        }
        this.setChangeListBusy(true);
        try {
            Workspace[] wss;
            HashSet<VCSHashURL> workingCopies = new HashSet<VCSHashURL>(10);
            for (Workspace ws : wss = VCSModelUtils.findCachedWorkspaces()) {
                URL root = SVNUtil.resolveWorkingCopy(ws.getURL());
                if (root == null) continue;
                workingCopies.add(new VCSHashURL(root));
            }
            HashMap<VCSHashURL, Object> cache = new HashMap<VCSHashURL, Object>(100);
            Iterator it = workingCopies.iterator();
            while (it.hasNext()) {
                try {
                    URL workingCopyRoot = URLFileSystem.canonicalize((URL)((VCSHashURL)it.next()).getURL());
                    ISVNClientAdapter client = this.getClient();
                    ISVNInfo wcInfo = null;
                    try {
                        wcInfo = client.getInfoFromWorkingCopy(SVNUtil.toFile(workingCopyRoot));
                    }
                    catch (SVNClientException ce) {
                        SVNProfile.getQualifiedLogger(this.getClass().getName()).info(ce.getMessage());
                    }
                    if (wcInfo == null || wcInfo.getUrl() == null) continue;
                    SVNRepositoryInfo repoInfo = SVNUtil.resolveRepository(wcInfo.getUrl());
                    SVNClientInteraction.getInstance().beginInteraction(client, repoInfo);
                    ISVNStatus[] statuses = client.getStatus(SVNUtil.toFile(workingCopyRoot), true, false, true);
                    this.cacheRelevantStatuses(workingCopyRoot, statuses, cache);
                }
                catch (SVNClientException ce) {
                    SVNProfile.getQualifiedLogger(this.getClass().getName()).warning(ce.getMessage());
                    new SVNExceptionHandler().handleExceptionWithOption(SVNExceptionWrapper.wrapException((Exception)((Object)ce)));
                }
                finally {
                    SVNClientInteraction.getInstance().endInteraction();
                }
            }
            LinkedHashSet urls = new LinkedHashSet();
            urls.addAll(VCSHashURL.convertFromURLs(Arrays.asList(this._statusCache.searchValues(VCSURLFilters.createNullFilter()))));
            urls.addAll(cache.keySet());
            this._statusCache.setInternalCache(cache);
            ChangeListEvent event = new ChangeListEvent(0);
            event.setURLs(VCSHashURL.convertToURLs(urls).toArray(new URL[urls.size()]));
            event.setReplace(true);
            this._eventQueue.enqueue(event);
        }
        finally {
            this.setChangeListBusy(false);
        }
    }

    private ISVNClientAdapter getClient() throws SVNClientException {
        return SVNUtil.getClientAdapter(SVNProfile.IDE_CLIENT_CONTEXT_ID, SVNProfile.IC_ADAPTER_CONTEXT_ID);
    }

    private void cacheRelevantStatuses(URL localRoot, ISVNStatus[] statuses, Map<VCSHashURL, Object> cache) throws SVNClientException {
        SVNUrl wcReposUrl = SVNURLInfoCache.getInstance().getURL(localRoot);
        if (wcReposUrl == null) {
            return;
        }
        for (int i = 0; i < statuses.length; ++i) {
            if (statuses[i] == null || statuses[i].getUrl() == null) continue;
            SVNStatusKind textStatus = statuses[i].getRepositoryTextStatus();
            SVNStatusKind propStatus = statuses[i].getRepositoryPropStatus();
            if (SVNStatusKind.MODIFIED.equals((Object)textStatus) && SVNStatusKind.MODIFIED.equals((Object)propStatus)) {
                cache.put(new VCSHashURL(this.getVirtualUrl(localRoot, wcReposUrl, statuses[i].getUrl())), SVNRemoteStatus.TEXT_PROP_MODIFIED);
                continue;
            }
            if (SVNStatusKind.MODIFIED.equals((Object)textStatus)) {
                cache.put(new VCSHashURL(this.getVirtualUrl(localRoot, wcReposUrl, statuses[i].getUrl())), SVNRemoteStatus.TEXT_MODIFIED);
                continue;
            }
            if (SVNStatusKind.MODIFIED.equals((Object)propStatus)) {
                cache.put(new VCSHashURL(this.getVirtualUrl(localRoot, wcReposUrl, statuses[i].getUrl())), SVNRemoteStatus.PROP_MODIFIED);
                continue;
            }
            if (SVNStatusKind.ADDED.equals((Object)textStatus)) {
                cache.put(new VCSHashURL(this.getVirtualUrl(localRoot, wcReposUrl, statuses[i].getUrl())), SVNRemoteStatus.ADDED);
                continue;
            }
            if (!SVNStatusKind.DELETED.equals((Object)textStatus)) continue;
            cache.put(new VCSHashURL(this.getVirtualUrl(localRoot, wcReposUrl, statuses[i].getUrl())), SVNRemoteStatus.DELETED);
        }
    }

    private URL getVirtualUrl(URL localBase, SVNUrl reposBase, SVNUrl item) {
        String rel = SVNUrlUtils.getRelativePath((SVNUrl)reposBase, (SVNUrl)item);
        return URLFileSystem.canonicalize((URL)URLFactory.newURL((URL)localBase, (String)rel.replace('/', File.separatorChar)));
    }

    private void setChangeListBusy(final boolean busy) {
        ChangeListEvent cle = new ChangeListEvent(2);
        cle.setRunnable(new Runnable(){

            @Override
            public void run() {
                SVNIncomingChangesTask.this._eventQueue.setChangeListBusyImpl(busy);
            }
        });
        this._eventQueue.enqueue(cle);
        this._eventQueue.setTaskInProgress(busy);
    }

    protected void populateStatusCacheMap(Map<VCSHashURL, Object> statusCacheMap, Collection<VCSHashURL> directoriesToQuery) {
    }

    protected boolean isControlled(URL directoryUrl) {
        return false;
    }

    protected String getViewId() {
        VCSProfile _profile = VCSProfiles.getInstance().getProfile("oracle.jdeveloper.subversion");
        return ViewId.validate((String)ChangeListViewId.getViewId((VCSProfile)_profile));
    }

    protected boolean isChangeListVisible() {
        ChangeListWindow clw = this.getChangeListWindow();
        return clw.isChangeListVisible((ChangeList)this._changeList);
    }

    public final ChangeListWindow getChangeListWindow() {
        return (ChangeListWindow)DockStation.getDockStation().getDockable(new ViewId(this.getViewId()));
    }
}

