/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;
import oracle.javatools.util.Maps;
import oracle.jdeveloper.vcs.spi.VCSHashURL;
import oracle.jdevimpl.vcs.svn.SVNURLInfoCacheStrategy;
import oracle.jdevimpl.vcs.svn.model.SVNURLInfo;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;

class SVNURLInfoCacheSimpleStrategy
extends SVNURLInfoCacheStrategy {
    private static final int CACHE_SIZE = 5000;
    private Map<VCSHashURL, SVNURLInfo> _cache = Collections.synchronizedMap(new Maps.CacheMap(5000, Maps.CacheMap.NONCANONICAL));

    SVNURLInfoCacheSimpleStrategy() {
    }

    @Override
    protected Map<VCSHashURL, SVNURLInfo> getDirectoryURLInfo(URL url, boolean descend) throws SVNClientException {
        ISVNStatus[] statuses;
        LinkedHashMap<VCSHashURL, SVNURLInfo> results = new LinkedHashMap<VCSHashURL, SVNURLInfo>();
        for (ISVNStatus status : statuses = this.getClientAdapter().getStatus(SVNUtil.toFile(url), descend, true, false)) {
            SVNURLInfo urlInfo = this.toURLInfo(status);
            results.put(new VCSHashURL(URLFactory.newFileURL((File)status.getFile())), urlInfo);
        }
        this._cache.putAll(results);
        return results;
    }

    @Override
    protected final SVNURLInfo getURLInfo(URL url) throws SVNClientException {
        VCSHashURL hashUrl = new VCSHashURL(url);
        SVNURLInfo urlInfo = this._cache.get(hashUrl);
        if (urlInfo == null) {
            ISVNStatus[] statuses = this.getClientAdapter().getStatus(SVNUtil.toFile(url), false, true, false);
            urlInfo = this.toURLInfo(statuses[0]);
            this._cache.put(hashUrl, urlInfo);
        }
        return urlInfo;
    }

    @Override
    protected void clear() {
        this._cache.clear();
    }

    @Override
    protected void clear(URL[] urls) {
        this._cache.keySet().removeAll(VCSHashURL.convertFromURLs(Arrays.asList(urls)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void clear(URLFilter filter) {
        Map<VCSHashURL, SVNURLInfo> map = this._cache;
        synchronized (map) {
            Iterator<VCSHashURL> itr = this._cache.keySet().iterator();
            while (itr.hasNext()) {
                if (!filter.accept(itr.next().getURL())) continue;
                itr.remove();
            }
        }
    }
}

