/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.SVNURLInfoCache;
import oracle.jdevimpl.vcs.svn.SVNURLInfoCacheStrategy;
import oracle.jdevimpl.vcs.svn.model.SVNURLInfo;
import oracle.jdevimpl.vcs.svn.mx.InfoCacheMBean;
import oracle.jdevimpl.vcs.svn.util.SVNURLInfoIO;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;

public final class SVNURLInfoCacheLegacyStrategy
extends SVNURLInfoCacheStrategy
implements InfoCacheMBean {
    private static final Logger sLogger = SVNProfile.getQualifiedLogger(SVNURLInfoCache.class.getName());
    private final SVNURLInfoIO _io = new SVNURLInfoIO();
    private final Map _byteCache = new HashMap(100);
    private final Map _objectCache = new LRUCache();
    private final Object _lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void clear() {
        Object object = this._lock;
        synchronized (object) {
            this._objectCache.clear();
            this._byteCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void clear(URL[] urls) {
        if (urls == null) {
            return;
        }
        Object object = this._lock;
        synchronized (object) {
            for (int i = 0; i < urls.length; ++i) {
                String externalForm = urls[i].toExternalForm();
                this._objectCache.remove(externalForm);
                this._byteCache.remove(externalForm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void clear(URLFilter filter) {
        try {
            Object object = this._lock;
            synchronized (object) {
                Iterator itr = this._objectCache.keySet().iterator();
                while (itr.hasNext()) {
                    if (!filter.accept(new URL((String)itr.next()))) continue;
                    itr.remove();
                }
                itr = this._byteCache.keySet().iterator();
                while (itr.hasNext()) {
                    if (!filter.accept(new URL((String)itr.next()))) continue;
                    itr.remove();
                }
            }
        }
        catch (MalformedURLException murle) {
            FeedbackManager.reportException((Throwable)murle);
        }
    }

    @Override
    public int getObjectCacheCapacity() {
        return ((LRUCache)this._objectCache).getMaxEntries();
    }

    @Override
    public void setObjectCacheCapacity(int capacity) {
        ((LRUCache)this._objectCache).setMaxEntries(capacity);
    }

    @Override
    public int getObjectCacheSize() {
        return this._objectCache.size();
    }

    @Override
    public int getByteCacheSize() {
        return this._byteCache.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SVNURLInfo getURLInfo(URL url) throws SVNClientException {
        String externalForm = url.toExternalForm();
        Object object = this._lock;
        synchronized (object) {
            SVNURLInfo info = (SVNURLInfo)this._objectCache.get(externalForm);
            if (info == null) {
                byte[] bytes = (byte[])this._byteCache.remove(externalForm);
                if (bytes != null) {
                    try {
                        info = this._io.unmarshall(bytes);
                        this._objectCache.put(externalForm, info);
                    }
                    catch (IOException ioe) {
                        sLogger.log(Level.SEVERE, "error byte[]->SVNURLInfo for " + externalForm, ioe);
                        throw new SVNClientException((Throwable)ioe);
                    }
                } else {
                    ISVNClientAdapter client = this.getClientAdapter();
                    URL directory = URLFileSystem.isDirectoryPath((URL)url) ? url : URLFileSystem.getParent((URL)url);
                    this.populateFromDirectory(client, directory);
                    info = (SVNURLInfo)this._objectCache.get(externalForm);
                    if (info == null) {
                        info = this.getStatusDirectly(client, url);
                        this._objectCache.put(externalForm, info);
                    }
                }
            }
            return info;
        }
    }

    private SVNURLInfo getStatusDirectly(ISVNClientAdapter client, URL url) throws SVNClientException {
        return this.toURLInfo(client.getSingleStatus(SVNUtil.toFile(url)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateFromDirectory(ISVNClientAdapter client, URL dir) throws SVNClientException {
        if (URLFileSystem.exists((URL)dir) && !URLFileSystem.isDirectory((URL)dir)) {
            throw new IllegalStateException();
        }
        long start = System.currentTimeMillis();
        ISVNStatus[] statuses = client.getStatus(SVNUtil.toFile(dir), false, true);
        if (sLogger.isLoggable(Level.FINE)) {
            long duration = System.currentTimeMillis() - start;
            sLogger.fine("resolved url info for directory " + URLFileSystem.getPlatformPathName((URL)dir) + " in " + duration + "ms");
        }
        if (statuses != null && statuses.length > 0) {
            Object object = this._lock;
            synchronized (object) {
                for (int i = 0; i < statuses.length; ++i) {
                    String path = statuses[i].getPath();
                    SVNNodeKind nodeKind = statuses[i].getNodeKind();
                    URL url = this.createURL(path, nodeKind);
                    String externalForm = url.toExternalForm();
                    StringBuffer buff = null;
                    if (sLogger.isLoggable(Level.FINEST)) {
                        if (buff == null) {
                            buff = new StringBuffer(500);
                        }
                        buff.setLength(0);
                        buff.append("cache request: ");
                        String dirExtForm = dir.toExternalForm();
                        buff.append(dirExtForm);
                        buff.append(" (").append(dirExtForm.hashCode()).append(") ");
                        buff.append("cached ").append(externalForm).append(" (");
                        buff.append(externalForm.hashCode()).append(", ");
                        buff.append(nodeKind.toString()).append(")");
                        sLogger.finest(buff.toString());
                    }
                    this._objectCache.put(externalForm, this.toURLInfo(statuses[i]));
                }
            }
        }
    }

    private URL createURL(String path, SVNNodeKind nodeKind) {
        if (SVNNodeKind.DIR.equals((Object)nodeKind)) {
            return URLFactory.newDirURL((String)path);
        }
        if (SVNNodeKind.FILE.equals((Object)nodeKind)) {
            return URLFactory.newFileURL((String)path);
        }
        File file = new File(path);
        return file.isDirectory() ? URLFactory.newDirURL((String)path) : URLFactory.newFileURL((String)path);
    }

    SVNURLInfoCacheLegacyStrategy() {
    }

    private final class LRUCache
    extends LinkedHashMap {
        private static final int DEFAULT_MAX_ENTRIES = 50;
        private int _maxEntries;

        private LRUCache() {
            super(51, 0.75f, true);
            this._maxEntries = 50;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean removeEldestEntry(Map.Entry entry) {
            if (this.size() > this._maxEntries) {
                try {
                    byte[] bytes = SVNURLInfoCacheLegacyStrategy.this._io.marshall((SVNURLInfo)entry.getValue());
                    Object object = SVNURLInfoCacheLegacyStrategy.this._lock;
                    synchronized (object) {
                        SVNURLInfoCacheLegacyStrategy.this._byteCache.put(entry.getKey(), bytes);
                    }
                    return true;
                }
                catch (IOException ioe) {
                    sLogger.log(Level.SEVERE, "error SVNURLInfo->byte[] for " + (String)entry.getKey(), ioe);
                    throw new RuntimeException(ioe);
                }
            }
            return false;
        }

        private int getMaxEntries() {
            return this._maxEntries;
        }

        private void setMaxEntries(int maxEntries) {
            this._maxEntries = maxEntries;
        }
    }
}

