/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn;

import java.net.URL;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.jdeveloper.vcs.generic.BaseStatusResolver;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.SVNURLInfoCache;
import oracle.jdevimpl.vcs.svn.StatusMapping;
import oracle.jdevimpl.vcs.svn.repos.SVNRepositoryManager;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import oracle.jdevimpl.vcs.svn.util.TimingUtil;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public final class SVNStatusResolver
extends BaseStatusResolver {
    private static final Logger sLogger = SVNProfile.getQualifiedLogger(SVNStatusResolver.class.getName());
    private static final String TIMING_CTX_STATUS_RESOLUTION = "resolveStatus";
    private VCSStatus _unrecognizedStatus;
    private URLFilter _defaultFilter;
    private URLFilter _wcFilter;
    private URLFilter _adFilter;

    public void clearStatuses(URLFilter filter) {
        SVNURLInfoCache.getInstance().clear(filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateStatuses(VCSProfile profile, URL[] urls, VCSStatus[] statuses) throws Exception {
        if (this._unrecognizedStatus == null) {
            this._unrecognizedStatus = profile.getStatusInstance("oracle.jdeveloper.vcs.status.UNRECOGNIZED");
        }
        if (SVNRepositoryManager.getInstance().isEmpty()) {
            for (int i = 0; i < urls.length; ++i) {
                statuses[i] = this._unrecognizedStatus;
            }
            return;
        }
        if (this._defaultFilter == null) {
            this._defaultFilter = profile.getURLFilter("oracle.jdeveloper.vcs.filters.url.DEFAULT");
            this._wcFilter = profile.getURLFilter("oracle.jdeveloper.subversion.filters.url.WORKING_COPY");
            this._adFilter = profile.getURLFilter("oracle.jdeveloper.subversion.filters.url.ADMINISTRATIVE");
        }
        Collection repositories = SVNRepositoryManager.getInstance().list();
        for (int i = 0; i < urls.length; ++i) {
            String timingContext = this.beginTimeResolve(TIMING_CTX_STATUS_RESOLUTION, urls[i]);
            try {
                statuses[i] = this.getStatus(profile, urls[i]);
                if (statuses[i] == this._unrecognizedStatus) continue;
                URL sandbox = SVNUtil.resolveControlledParent(urls[i]);
                if (sandbox == null) {
                    statuses[i] = this._unrecognizedStatus;
                    continue;
                }
                SVNUrl sandboxUrl = SVNURLInfoCache.getInstance().getURL(sandbox);
                if (sandboxUrl == null || SVNUtil.resolveRepository(sandboxUrl, repositories) != null) continue;
                statuses[i] = this._unrecognizedStatus;
                continue;
            }
            catch (SVNClientException ce) {
                sLogger.log(Level.WARNING, "unable to resolve status for " + URLFileSystem.getPlatformPathName((URL)urls[i]), ce);
                statuses[i] = this._unrecognizedStatus;
                continue;
            }
            finally {
                this.endTimeResolve(timingContext);
            }
        }
    }

    private VCSStatus getStatus(VCSProfile profile, URL url) throws SVNClientException {
        VCSStatus status;
        block6: {
            if (!this._defaultFilter.accept(url)) {
                return this._unrecognizedStatus;
            }
            if (this._adFilter.accept(url)) {
                return profile.getStatusInstance("ADMINISTRATIVE");
            }
            status = null;
            try {
                SVNStatusKind propStatus = SVNStatusKind.fromInt((int)SVNURLInfoCache.getInstance().getPropStatus(url));
                if (SVNStatusKind.CONFLICTED.equals((Object)propStatus) || SVNStatusKind.MODIFIED.equals((Object)propStatus)) {
                    status = StatusMapping.getVCSStatus(propStatus);
                } else {
                    SVNStatusKind textStatus = SVNStatusKind.fromInt((int)SVNURLInfoCache.getInstance().getTextStatus(url));
                    status = !URLFileSystem.exists((URL)url) && !SVNStatusKind.DELETED.equals((Object)textStatus) ? this._unrecognizedStatus : StatusMapping.getVCSStatus(textStatus);
                }
            }
            catch (SVNClientException e) {
                sLogger.info(e.getMessage());
                VCSStatus parentStatus = this.getStatus(profile, URLFileSystem.getParent((URL)url));
                if (parentStatus.isVersioned()) break block6;
                return parentStatus;
            }
        }
        return status != null ? status : this._unrecognizedStatus;
    }

    private String beginTimeResolve(String contextOperation, URL url) {
        if (TimingUtil.canTime()) {
            String context = contextOperation + ".{" + URLFileSystem.getPlatformPathName((URL)url) + "}";
            TimingUtil.beginTiming(((Object)((Object)this)).getClass(), context);
            return context;
        }
        return null;
    }

    private void endTimeResolve(String context) {
        if (context != null) {
            TimingUtil.endTiming(((Object)((Object)this)).getClass(), context);
        }
    }
}

