/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn;

import java.awt.Component;
import java.awt.EventQueue;
import java.net.URL;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.ide.controls.WaitCursor;
import oracle.jdeveloper.vcs.properties.PropertiesPanel;
import oracle.jdeveloper.vcs.spi.VCSExceptionHandler;
import oracle.jdevimpl.vcs.svn.SVNExceptionWrapper;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.SVNURLInfoCache;
import oracle.jdevimpl.vcs.svn.ui.SVNPropertiesPanelUI;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public final class SVNPropertiesPanel
extends PropertiesPanel {
    private final URL _url;

    public SVNPropertiesPanel(URL url) {
        this._url = url;
    }

    public Component getComponent() {
        try {
            SVNPropertiesPanelUI ui = new SVNPropertiesPanelUI();
            ISVNClientAdapter client = SVNUtil.getIDEClientAdapter();
            this.populateSynchronously(ui, client);
            this.populateAsynchronously(ui, client);
            return ui;
        }
        catch (SVNClientException ce) {
            SVNProfile.getQualifiedLogger(((Object)((Object)this)).getClass().getName()).warning(ce.getMessage());
            new VCSExceptionHandler().handleException(SVNExceptionWrapper.wrapException((Exception)((Object)ce)));
            return new JPanel();
        }
    }

    private void populateSynchronously(SVNPropertiesPanelUI ui, ISVNClientAdapter client) throws SVNClientException {
        SVNURLInfoCache ic = SVNURLInfoCache.getInstance();
        ISVNInfo info = client.getInfoFromWorkingCopy(SVNUtil.toFile(this._url));
        ui.setTextStatus(SVNStatusKind.fromInt((int)ic.getTextStatus(this._url)));
        ui.setPropertyStatus(SVNStatusKind.fromInt((int)ic.getPropStatus(this._url)));
        ui.setRevision(ic.getRevision(this._url));
        ui.setLastChangedRevision(ic.getLastChangedRevision(this._url));
        ui.setLastChangedDate(info.getLastChangedDate());
        ui.setLastCommitAuthor(ic.getLastCommitAuthor(this._url));
        ui.setTextLastChanged(info.getLastDateTextUpdate());
        ui.setPropertiesLastChanged(info.getLastDatePropsUpdate());
        ui.setSchedule(info.getSchedule());
        boolean isCopied = info.isCopied();
        ui.setIsCopied(isCopied);
        if (isCopied) {
            ui.setCopySourceUrl(info.getCopyUrl());
            SVNRevision.Number copyRev = info.getCopyRev();
            ui.setCopySourceRevision(copyRev != null ? copyRev.getNumber() : -1L);
        }
    }

    private void populateAsynchronously(SVNPropertiesPanelUI ui, ISVNClientAdapter client) {
        new ReposPropsThread(ui, client).start();
    }

    private final class ReposPropsThread
    extends Thread {
        private final SVNPropertiesPanelUI _ui;
        private final ISVNClientAdapter _client;

        private ReposPropsThread(SVNPropertiesPanelUI ui, ISVNClientAdapter client) {
            this._ui = ui;
            this._client = client;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            final WaitCursor wc = new WaitCursor((Component)this._ui);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    wc.show();
                }
            });
            try {
                SVNUrl svnUrl = SVNURLInfoCache.getInstance().getURL(SVNPropertiesPanel.this._url);
                SVNOperationLogger.getInstance().beginOperation(this._client, SVNUtil.resolveRepository(svnUrl));
                final ISVNInfo info = this._client.getInfo(svnUrl);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ReposPropsThread.this._ui.setRepositoryRoot(info.getRepository());
                        ReposPropsThread.this._ui.setRepositoryUrl(info.getUrl());
                        ReposPropsThread.this._ui.setRepositoryUUID(info.getUuid());
                        try {
                            ReposPropsThread.this._ui.setLockOwner(info.getLockOwner());
                            ReposPropsThread.this._ui.setLockCreationDate(info.getLockCreationDate());
                            ReposPropsThread.this._ui.setLockComment(info.getLockComment());
                        }
                        catch (NullPointerException npe) {
                            SVNProfile.getQualifiedLogger(this.getClass().getName()).warning(npe.getMessage());
                            ReposPropsThread.this._ui.setLockOwner(null);
                            ReposPropsThread.this._ui.setLockCreationDate(null);
                            ReposPropsThread.this._ui.setLockComment(null);
                        }
                    }
                });
                SVNOperationLogger.getInstance().endOperation();
            }
            catch (SVNClientException ce) {
                try {
                    new VCSExceptionHandler().handleException(SVNExceptionWrapper.wrapException((Exception)((Object)ce)), (Component)this._ui);
                    SVNOperationLogger.getInstance().endOperation();
                }
                catch (Throwable throwable) {
                    SVNOperationLogger.getInstance().endOperation();
                    EventQueue.invokeLater(new Runnable(wc){
                        final /* synthetic */ WaitCursor val$wc;
                        {
                            this.val$wc = waitCursor;
                        }

                        @Override
                        public void run() {
                            this.val$wc.hide();
                            this.val$wc.dispose();
                        }
                    });
                    throw throwable;
                }
                EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
            EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
    }
}

