/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn;

import java.awt.Color;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import oracle.ide.editor.EditorManager;
import oracle.ide.log.Href;
import oracle.ide.log.StyledMessage;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.progress.DeterminateProgressMonitor;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.jdevimpl.vcs.svn.SVNClientInteraction;
import oracle.jdevimpl.vcs.svn.SVNMessagePage;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;

public final class SVNOperationLogger {
    private static final Logger sLogger = SVNProfile.getQualifiedLogger(SVNOperationLogger.class.getName());
    private static final SVNOperationLogger sInstance = new SVNOperationLogger();
    private final NotifyListener _notifier = new NotifyListener();
    private long _opStartTime;
    private ISVNClientAdapter _client;
    private IndeterminateProgressMonitor _indeterminateProgress;
    private DeterminateProgressMonitor _determinateProgress;
    private static Color COMMAND_COLOR = Color.BLACK;
    private static Color MESSAGE_COLOR = new Color(0, 0, 128);
    private static Color ERROR_COLOR = Color.RED;
    private static String MESSAGE_INDENT = "    ";
    private boolean _newSession = true;
    static String _pre_error_msg = null;
    static String _pre_complete_msg = null;

    public static final SVNOperationLogger getInstance() {
        return sInstance;
    }

    public synchronized void beginOperation(ISVNClientAdapter client, SVNRepositoryInfo reposInfo) {
        if (this._client != null) {
            sLogger.warning("Subversion client is already in use by another thread");
            return;
        }
        SVNClientInteraction.getInstance().beginInteraction(client, reposInfo);
        this._client = client;
        this._indeterminateProgress = null;
        this._determinateProgress = null;
        this._client.addNotifyListener((ISVNNotifyListener)this._notifier);
        this._opStartTime = System.currentTimeMillis();
        this._notifier.logBeginOperation();
    }

    public synchronized void beginOperation(ISVNClientAdapter client, SVNRepositoryInfo reposInfo, IndeterminateProgressMonitor progressMonitor) {
        this.beginOperation(client, reposInfo);
        this._indeterminateProgress = progressMonitor;
    }

    public synchronized void beginOperation(ISVNClientAdapter client, SVNRepositoryInfo reposInfo, DeterminateProgressMonitor progressMonitor) {
        this.beginOperation(client, reposInfo);
        this._determinateProgress = progressMonitor;
    }

    public synchronized void endOperation() {
        this._newSession = true;
        if (this._client == null) {
            sLogger.warning("Subversion client is already in use by another thread");
            return;
        }
        long duration = System.currentTimeMillis() - this._opStartTime;
        this._notifier.logEndOperation(duration);
        this._client.removeNotifyListener((ISVNNotifyListener)this._notifier);
        SVNClientInteraction.getInstance().endInteraction();
        this._client = null;
        this._indeterminateProgress = null;
        this._determinateProgress = null;
    }

    private SVNOperationLogger() {
    }

    private class ConsoleHref
    extends Href {
        public ConsoleHref(String text, URL url) {
            super(text, url);
        }

        public void go() {
            EditorManager.getEditorManager().openDefaultEditorInFrame(this.getURL());
        }
    }

    private final class NotifyListener
    implements ISVNNotifyListener {
        private NotifyListener() {
        }

        public void logBeginOperation() {
            sLogger.info("begin svn operation");
        }

        public void logEndOperation(long duration) {
            sLogger.info("end svn operation, duration: " + duration + "ms");
        }

        public void setCommand(int commandId) {
        }

        public void logCommandLine(String commandLine) {
            this.processHrefAware(commandLine, COMMAND_COLOR);
            this.toMessagePage("\n");
            sLogger.info(commandLine);
        }

        public void logMessage(String message) {
            this.toMessagePage(MESSAGE_INDENT);
            this.processHrefAware(message, MESSAGE_COLOR);
            this.toMessagePage("\n");
            this.toProgressMonitor(message);
            sLogger.fine(message);
        }

        public void logError(String error) {
            if (error.equals(_pre_error_msg)) {
                _pre_error_msg = null;
                return;
            }
            SVNOperationLogger.this._newSession = false;
            _pre_error_msg = error;
            this.toMessagePage(MESSAGE_INDENT);
            this.processHrefAware(error, ERROR_COLOR);
            this.toMessagePage("\n");
            sLogger.warning(error);
        }

        public void logRevision(long revision, String path) {
        }

        public void logCompleted(String message) {
            if (!SVNOperationLogger.this._newSession && message.equals(_pre_complete_msg)) {
                _pre_complete_msg = null;
                return;
            }
            SVNOperationLogger.this._newSession = false;
            _pre_complete_msg = message;
            this.toMessagePage(MESSAGE_INDENT);
            this.processHrefAware(message, MESSAGE_COLOR);
            this.toMessagePage("\n");
            sLogger.fine(message);
        }

        public void onNotify(File path, SVNNodeKind nodeKind) {
        }

        protected void processHrefAware(String message, Color color) {
            String[] msgSegs = message.split("\\s+");
            for (int i = 0; i < msgSegs.length; ++i) {
                if (this.hasHref(msgSegs[i])) {
                    try {
                        Href href = this.createHref(this.getHrefText(msgSegs[i]));
                        this.toMessagePage(href);
                        this.toMessagePage(" ");
                    }
                    catch (MalformedURLException e) {
                        sLogger.info(e.getMessage());
                    }
                    continue;
                }
                this.toMessagePage(this.formatMessage(msgSegs[i], color));
                this.toMessagePage(" ");
            }
        }

        private boolean hasHref(String msgSeg) {
            if (msgSeg.indexOf("\\") == -1 && msgSeg.indexOf("/") == -1) {
                return false;
            }
            String hrefText = this.getHrefText(msgSeg);
            try {
                URL url = new URL("file:" + hrefText);
                if (URLFileSystem.isDirectory((URL)url) || !URLFileSystem.exists((URL)url)) {
                    return false;
                }
            }
            catch (MalformedURLException e) {
                return false;
            }
            return true;
        }

        private String getHrefText(String msgSeg) {
            String hrefText = msgSeg;
            if (msgSeg.startsWith("'") || msgSeg.startsWith("\"") || msgSeg.startsWith("(")) {
                hrefText = msgSeg.substring(1, msgSeg.length() - 1);
            }
            return hrefText;
        }

        private Href createHref(String hrefText) throws MalformedURLException {
            URL url = new URL("file:" + hrefText);
            return new ConsoleHref(hrefText, url);
        }

        private StyledMessage formatMessage(String message, Color color) {
            SimpleAttributeSet attributeSet = new SimpleAttributeSet();
            StyleConstants.setForeground(attributeSet, color);
            return new StyledMessage((AttributeSet)attributeSet, message);
        }

        private void toMessagePage(Object message) {
            if (IdeUtil.isHeadless()) {
                return;
            }
            SVNMessagePage page = null;
            try {
                page = SVNMessagePage.getInstance();
            }
            catch (Exception ex) {
                sLogger.warning(ex.getMessage());
            }
            if (page != null) {
                page.log(message);
            }
        }

        private void toProgressMonitor(String message) {
            if (SVNOperationLogger.this._indeterminateProgress != null) {
                SVNOperationLogger.this._indeterminateProgress.getPanel().setNote(message);
            }
            if (SVNOperationLogger.this._determinateProgress != null) {
                SVNOperationLogger.this._determinateProgress.getPanel().setNote(message);
            }
        }
    }
}

