/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn;

import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.ide.layout.ViewId;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.log.MessagePage;
import oracle.javatools.util.ResourcePicker;
import oracle.jdevimpl.vcs.svn.SVNProfile;

public class SVNMessagePage
extends MessagePage {
    private static SVNMessagePage _page;
    private static ResourcePicker _res;

    private SVNMessagePage(ViewId viewId, Icon icon, boolean addPage, boolean showStyledText) {
        super(viewId, icon, addPage, showStyledText);
    }

    public static final SVNMessagePage getInstance() {
        if (_page == null) {
            _page = new SVNMessagePage(new ViewId(_res.getString("SVN_CONSOLE_VIEWID"), _res.getString("SVN_CONSOLE_NAME")), null, false, true);
            SVNMessagePage.load(_page);
        }
        return _page;
    }

    public static final void load(final MessagePage page) {
        if (page != null) {
            LogManager.getLogManager().addPage((LogPage)page);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    page.activate();
                    page.show();
                }
            });
        }
    }

    public static final void unload() {
        if (_page != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    _page.close();
                    _page.deactivate();
                }
            });
            LogManager.getLogManager().removePage((LogPage)_page);
            _page = null;
        }
    }

    static {
        _res = ResourcePicker.getPicker(SVNProfile.class);
    }
}

