/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn;

import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.jdeveloper.vcs.generic.DynamicCommandChooser;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.merge.SVNMergeEditor;

public class SVNCommandChooser
extends DynamicCommandChooser {
    public String getDynamicCommandId(VCSProfile profile, Context context) {
        if (context.getView() instanceof SVNMergeEditor) {
            return null;
        }
        if (context.getNode() == null) {
            return null;
        }
        VCSStatus status = null;
        try {
            status = profile.getStatusCache().get(context.getNode().getURL());
        }
        catch (Exception e) {
            SVNProfile.getQualifiedLogger(((Object)((Object)this)).getClass().getName()).warning(e.getMessage());
            return null;
        }
        if (status == null) {
            return null;
        }
        if (profile.getStatusInstance("ADMINISTRATIVE").equals(status)) {
            return null;
        }
        if (status.isCandidate()) {
            return "oracle.jdeveloper.subversion.add";
        }
        if (profile.getStatusInstance("CONFLICTS").equals(status)) {
            return "oracle.jdeveloper.subversion.resolve-conflicts";
        }
        if (context.getNode() instanceof Workspace || context.getNode() instanceof Project) {
            if (profile.getStatusInstance("ADDED").equals(status)) {
                return "oracle.jdeveloper.subversion.commit-workingcopy";
            }
            if (profile.getStatusInstance("DELETED").equals(status)) {
                return "oracle.jdeveloper.subversion.commit-workingcopy";
            }
            if (profile.getStatusInstance("MODIFIED").equals(status)) {
                return "oracle.jdeveloper.subversion.commit-workingcopy";
            }
            if (status.isVersioned()) {
                return "oracle.jdeveloper.subversion.update-workingcopy";
            }
            return "oracle.jdeveloper.subversion.checkout";
        }
        if (profile.getStatusInstance("ADDED").equals(status)) {
            return "oracle.jdeveloper.subversion.commit";
        }
        if (profile.getStatusInstance("DELETED").equals(status)) {
            return "oracle.jdeveloper.subversion.commit";
        }
        if (profile.getStatusInstance("MODIFIED").equals(status)) {
            return "oracle.jdeveloper.subversion.commit";
        }
        if (status.isVersioned()) {
            return "oracle.jdeveloper.subversion.update";
        }
        return null;
    }
}

