/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Ide;
import oracle.ide.IdeAdapter;
import oracle.ide.IdeEvent;
import oracle.ide.log.LogManager;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.PlatformUtils;
import oracle.javatools.util.ResourcePicker;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSPropertyMap;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.SVNURLInfoCache;
import oracle.jdevimpl.vcs.svn.client.SVNClient;
import oracle.jdevimpl.vcs.svn.client.SVNClientRegistry;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public final class SVNClientSelector
extends IdeAdapter
implements ChangeListener {
    private final VCSProfile _profile;
    private final ResourcePicker _res;
    private boolean _mainWindowOpened;

    public SVNClientSelector(VCSProfile svnProfile) {
        this._profile = svnProfile;
        this._res = ResourcePicker.getPicker(SVNProfile.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void stateChanged(ChangeEvent e) {
        if (!this.clientBindingsAvailable()) {
            this.feedbackNoBindings();
            return;
        }
        VCSPropertyMap settings = this._profile.getData("CLIENT_TECHNOLOGY");
        int preferredClient = (Integer)settings.getMap().get("clientType");
        SVNClientRegistry reg = SVNClientRegistry.getInstance();
        try {
            switch (preferredClient) {
                case 1: {
                    reg.setContextClient(SVNProfile.IDE_CLIENT_CONTEXT_ID, reg.getNativeClient());
                    return;
                }
                case 2: {
                    reg.setContextClient(SVNProfile.IDE_CLIENT_CONTEXT_ID, reg.getSVNKitClient());
                    return;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        catch (SVNClientException ce) {
            Object[] defaults = this.getDefaultClient();
            if (defaults == null) {
                reg.setContextClient(SVNProfile.IDE_CLIENT_CONTEXT_ID, null);
                SVNProfile.getQualifiedLogger(this.getClass().getName()).warning("No default client");
                throw new IllegalStateException("No default client");
            }
            reg.setContextClient(SVNProfile.IDE_CLIENT_CONTEXT_ID, (SVNClient)defaults[0]);
            Map oldProps = settings.getMap();
            HashMap<String, Object> newProps = new HashMap<String, Object>(oldProps);
            newProps.put("clientType", defaults[1]);
            settings.setMap(newProps);
            this.feedbackDefaultBinding();
            return;
        }
        finally {
            this._profile.getStatusCache().clear();
            SVNURLInfoCache.getInstance().clear();
        }
    }

    public void mainWindowOpened(IdeEvent ideEvent) {
        this._mainWindowOpened = true;
    }

    private Object[] getDefaultClient() {
        try {
            SVNClientRegistry reg = SVNClientRegistry.getInstance();
            if (reg.isNativeClientAvailable()) {
                return new Object[]{reg.getNativeClient(), new Integer(1)};
            }
            if (reg.isSVNKitClientAvailable()) {
                return new Object[]{reg.getSVNKitClient(), new Integer(2)};
            }
            return null;
        }
        catch (SVNClientException ce) {
            SVNProfile.getQualifiedLogger(this.getClass().getName()).warning("No client available");
            return null;
        }
    }

    private boolean clientBindingsAvailable() {
        SVNClientRegistry reg = SVNClientRegistry.getInstance();
        return reg.isNativeClientAvailable() || reg.isSVNKitClientAvailable();
    }

    private void feedbackDefaultBinding() {
        if (this._mainWindowOpened) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)this._res.getString("INFO_MSG_DEFAULT_CLIENT"), (String)this._res.getString("INFO_TITLE_DEFAULT_CLIENT"), (String)"f1_svnuseddefaultclient_html");
        } else {
            LogManager.getLogManager().getMsgPage().log((Object)this._res.getString("INFO_MSG_DEFAULT_CLIENT"));
        }
    }

    private void feedbackNoBindings() {
        String message = null;
        message = PlatformUtils.isWindows() ? this._res.getString("ERROR_MSG_NO_CLIENTS_WIN32") : (PlatformUtils.isLinux() ? this._res.getString("ERROR_MSG_NO_CLIENTS_LINUX") : this._res.getString("ERROR_MSG_NO_CLIENTS_GENERIC"));
        if (this._mainWindowOpened) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)message, (String)this._res.getString("ERROR_TITLE_NO_CLIENTS"), (String)"f1_subversionclientunavailable_html");
        } else {
            LogManager.getLogManager().getMsgPage().log((Object)message);
        }
    }
}

