/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.vcs.changeset.ChangeSetAdapter;
import oracle.jdeveloper.vcs.changeset.ChangeSetException;
import oracle.jdeveloper.vcs.changeset.ChangeSetHandler;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfiles;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdevimpl.vcs.svn.StatusMapping;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNChangelistHandler;
import org.tmatesoft.svn.core.wc.SVNChangelistClient;
import org.tmatesoft.svn.core.wc.SVNClientManager;

public final class SVNChangeSetAdapter
extends ChangeSetAdapter {
    private final VCSProfile _profile = VCSProfiles.getInstance().getProfile(this.getSystemId());
    private SVNChangelistClient _client;

    public SVNChangeSetAdapter(String vcsId) {
        super(vcsId);
        this.setExpiryEnabled(true);
    }

    public boolean isChanged(VCSStatus status) {
        return status == StatusMapping.getVCSStatus(SVNStatusKind.MODIFIED) || status == StatusMapping.getVCSStatus(SVNStatusKind.ADDED) || status == StatusMapping.getVCSStatus(SVNStatusKind.DELETED) || status == StatusMapping.getVCSStatus(SVNStatusKind.MERGED) || status == StatusMapping.getVCSStatus(SVNStatusKind.CONFLICTED);
    }

    public IdeAction getCommitAction() {
        return IdeAction.find((int)Ide.findCmdID((String)"oracle.jdeveloper.subversion.commit"));
    }

    public synchronized URL[] getChangeSetURLs(final String name, URL[] contextUrls) throws ChangeSetException {
        URL parent;
        if (contextUrls.length <= 0) {
            throw new IllegalStateException();
        }
        URL url = contextUrls[0];
        while ((parent = URLFileSystem.getParent((URL)url)) != null && !parent.equals(url) && URLFileSystem.isDirectory((URL)URLFactory.newDirURL((URL)parent, (String)".svn"))) {
            url = parent;
        }
        try {
            final ArrayList urls = new ArrayList();
            this.getClient().doGetChangeLists(this.convertURLToFile(url), null, SVNDepth.INFINITY, new ISVNChangelistHandler(){

                public final void handle(File path, String changelistName) {
                    if (changelistName == null) {
                        return;
                    }
                    if (name != null && !name.equals(changelistName)) {
                        return;
                    }
                    urls.add(URLFactory.newFileURL((File)path));
                }
            });
            return urls.toArray(new URL[urls.size()]);
        }
        catch (SVNException svne) {
            throw new ChangeSetException((Exception)((Object)svne));
        }
    }

    public synchronized void addToChangeSet(URL[] urls, String name) throws ChangeSetException {
        try {
            urls = this.retainVersioned(urls);
            this.getClient().doAddToChangelist(this.convertURLsToFiles(urls), SVNDepth.EXCLUDE, name, null);
        }
        catch (SVNException svne) {
            throw new ChangeSetException((Exception)((Object)svne));
        }
    }

    public synchronized void removeFromChangeSet(URL[] urls, String name) throws ChangeSetException {
        try {
            String[] stringArray;
            urls = this.retainVersioned(urls);
            SVNChangelistClient sVNChangelistClient = this.getClient();
            File[] fileArray = this.convertURLsToFiles(urls);
            if (name != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = name;
            } else {
                stringArray = null;
            }
            sVNChangelistClient.doRemoveFromChangelist(fileArray, SVNDepth.EXCLUDE, stringArray);
        }
        catch (SVNException svne) {
            throw new ChangeSetException((Exception)((Object)svne));
        }
    }

    public void handleCommitted(URL[] urls) throws ChangeSetException {
        ArrayList<URL> urls0 = new ArrayList<URL>(Arrays.asList(urls));
        Iterator itr = urls0.iterator();
        while (itr.hasNext()) {
            if (!URLFileSystem.isDirectoryPath((URL)((URL)itr.next()))) continue;
            itr.remove();
        }
        this.removeFromChangeSet(urls0.toArray(new URL[urls0.size()]), null);
    }

    protected synchronized void getChangeSetsImpl(URL[] urls, final ChangeSetHandler handler, boolean recursive) throws ChangeSetException {
        try {
            for (URL url : urls = this.retainVersioned(urls)) {
                this.getClient().doGetChangeLists(this.convertURLToFile(url), null, recursive ? SVNDepth.INFINITY : SVNDepth.EXCLUDE, new ISVNChangelistHandler(){

                    public final void handle(File path, String changelistName) {
                        if (changelistName == null) {
                            return;
                        }
                        handler.handle(URLFactory.newFileURL((File)path), changelistName);
                    }
                });
            }
        }
        catch (SVNException svne) {
            throw new ChangeSetException((Exception)((Object)svne));
        }
    }

    private final SVNChangelistClient getClient() {
        if (this._client == null) {
            SVNClientManager manager = SVNClientManager.newInstance();
            this._client = manager.getChangelistClient();
        }
        return this._client;
    }

    private final File[] convertURLsToFiles(URL[] urls) {
        File[] files = new File[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            files[i] = this.convertURLToFile(urls[i]);
        }
        return files;
    }

    private final File convertURLToFile(URL url) {
        return new File(URLFileSystem.getPlatformPathName((URL)url));
    }

    private final URL[] retainVersioned(URL[] urls) throws ChangeSetException {
        try {
            ArrayList<URL> urls0 = new ArrayList<URL>();
            VCSStatus[] statuses = this._profile.getStatusCache().get(urls);
            for (int i = 0; i < urls.length; ++i) {
                if (statuses[i] == null || !statuses[i].isVersioned()) continue;
                urls0.add(urls[i]);
            }
            return urls0.toArray(new URL[urls0.size()]);
        }
        catch (Exception e) {
            throw new ChangeSetException(e);
        }
    }
}

