/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.net.URLFactory;
import oracle.jdevimpl.help.AbstractRSSQueryHandler;
import oracle.jdevimpl.help.HelpSearchResult;
import oracle.jdevimpl.help.TahitiSearchResult;

class TahitiQueryHandler
extends AbstractRSSQueryHandler {
    public static final String URL_BEGINNING = "http://www.oracle.com/pls/";
    public static final String URL_ENDING = "/search?";
    protected static final String[] omits = new String[]{"b31974", "b31973", "e10139", "e10148", "e10224", "e10138"};
    protected List<String> _searchList;
    protected boolean _localInSearch;

    void setSearchList(List<String> searchList) {
        this._searchList = searchList;
    }

    void setLocalInSearch(boolean localInSearch) {
        this._localInSearch = localInSearch;
    }

    protected String createQueryString(String searchText) {
        String queryString = "word=" + searchText + "&format=rss&high=200";
        if (this._localInSearch) {
            queryString = queryString + this.buildOmitSection();
        }
        return this.htmlEncodeString(queryString);
    }

    protected String buildOmitSection() {
        StringBuffer sb = new StringBuffer(100);
        for (String omit : omits) {
            sb.append("&omit=");
            sb.append(omit);
        }
        return sb.toString();
    }

    @Override
    protected List<URL> createSearchURLs(String searchText) {
        ArrayList<URL> urlList = new ArrayList<URL>(2);
        for (String section : this._searchList) {
            String urlString = URL_BEGINNING + section + URL_ENDING;
            try {
                URL url = new URL(urlString);
                url = URLFactory.replaceQueryPart((URL)url, (String)this.createQueryString(searchText));
                urlList.add(url);
            }
            catch (MalformedURLException muex) {
                muex.printStackTrace();
            }
        }
        return urlList;
    }

    @Override
    protected HelpSearchResult createSearchResult(String title, String link, String description) {
        return new TahitiSearchResult(title, link, description);
    }
}

