/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FocusTraversalPolicy;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ide.extension.Extension;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.help.Help;
import oracle.help.common.IndirectTarget;
import oracle.help.common.SimpleTopic;
import oracle.help.common.SimpleURLTarget;
import oracle.help.common.Target;
import oracle.help.common.Topic;
import oracle.help.common.util.java.StaticLocaleContext;
import oracle.help.java.util.ImageLoader;
import oracle.help.library.Book;
import oracle.help.library.Library;
import oracle.help.library.LibraryException;
import oracle.help.navigator.favoritesNavigator.DefaultFavoritesModel;
import oracle.help.navigator.favoritesNavigator.FavoritesModel;
import oracle.help.topicDisplay.TopicDisplayException;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.config.DTCache;
import oracle.ide.docking.DockStation;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.BrowseSymbolResolver;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.HelpSystem;
import oracle.ide.help.Helpable;
import oracle.ide.layout.ViewId;
import oracle.ide.log.LogManager;
import oracle.ide.model.Node;
import oracle.ide.net.JarIndex;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.Traversable;
import oracle.ide.util.DefaultStructuredPropertyAccess;
import oracle.ide.util.MultiMap;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.SwingWorker;
import oracle.ide.view.View;
import oracle.ide.webbrowser.BrowserRunner;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ghost.GhostPalette;
import oracle.javatools.ui.ghost.UIConstants;
import oracle.jdevimpl.help.DynamicLinkTarget;
import oracle.jdevimpl.help.HelpArb;
import oracle.jdevimpl.help.HelpCenterWindow;
import oracle.jdevimpl.help.HelpContentPanel;
import oracle.jdevimpl.help.HelpContentWindow;
import oracle.jdevimpl.help.HelpHook;
import oracle.jdevimpl.help.HelpSystemAddin;
import oracle.jdevimpl.help.HelpTopicDocument;
import oracle.jdevimpl.help.HelpTopicEditor;
import oracle.jdevimpl.help.HelpUtils;
import oracle.jdevimpl.help.HelpWindow;
import oracle.jdevimpl.help.JDevHelpSet;
import oracle.jdevimpl.help.JDevImageLoader;
import oracle.jdevimpl.help.JDevLibrary;
import oracle.jdevimpl.help.JavadocBook;
import oracle.jdevimpl.help.ModalHelpContentDialog;
import oracle.jdevimpl.help.MultipleTypeTopic;

public final class JDevHelpSystemImpl
extends HelpSystem {
    public static final String LANGUAGE_HELP_BOOK_NAME = "...language-help...";
    private List<HelpJarInfo> _addinHelpSetList = new ArrayList<HelpJarInfo>();
    private ArrayList _loadErrors = new ArrayList();
    private JDevLibrary _library;
    private Dialog _modalOwner;
    private boolean _initialized;
    private static String _lastPrintString;
    private ModalHelpContentDialog _modalDialog;
    private HashMap _topicSubstitutes;
    private FavoritesModel _favoritesModel;
    private List _tipOfDayList = new ArrayList();
    private boolean _hooksProcessedForTipJars;
    private boolean _hooksProcessedForHelpSetJars;
    private int[] _supportedNavigators;
    private static List _browseSymbolResolverList;
    private static String _editionDirectory;
    private static List<String> _callbackWizardHandlerList;
    private MultiMap<String, BookContributor> _bookMap;
    private final boolean DEBUG = false;
    private static final int INITIALIZATION_ERROR = 0;
    private static final int DISPLAY_ERROR = 1;
    private static final String LAYOUT_FILE = "Help.windows";
    private static final String FAVORITES_FILE = "HelpBookmarks.xml";
    private static final String HELPSYSTEM_LAST_TIP_JAR = "JDevHelpSystemImpl.last-tip-jar";
    private static final String HELPSYSTEM_LAST_TIP = "JDevHelpSystemImpl.last-tip";
    private static final String HELPSYSTEM_SHOW_TIP_OF_DAY = "JDevHelpSystemImpl.show-tip";

    public Library getLibrary() {
        if (this._initialize()) {
            return this._library;
        }
        return null;
    }

    public void loadHelpWindows() {
        DefaultStructuredPropertyAccess dspa = null;
        dspa = this.getLayout();
        if (dspa == null) {
            return;
        }
        Iterator iterator = dspa.getChildNodes();
        while (iterator.hasNext()) {
            DefaultStructuredPropertyAccess childNode = (DefaultStructuredPropertyAccess)iterator.next();
            String nodeName = childNode.getName();
            if (!nodeName.equals("HelpWindow")) continue;
            HelpContentWindow.loadLayout(childNode);
        }
    }

    DefaultStructuredPropertyAccess getLayout() {
        ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
        URL url = er.getSystemDirectory(HelpSystemAddin.getExtensionID());
        File file = new File(url.getPath(), LAYOUT_FILE);
        DefaultStructuredPropertyAccess dspa = null;
        try {
            dspa = DefaultStructuredPropertyAccess.loadFromXML((File)file);
        }
        catch (Exception e) {
            // empty catch block
        }
        return dspa;
    }

    public List getErrors() {
        return this._loadErrors;
    }

    public final void showLanguageHelp(Context context, String symbolName) {
        JDevHelpSystemImpl.showLanguageHelpNonOHJ(context, symbolName);
    }

    final FavoritesModel getFavoritesModel() {
        if (this._favoritesModel == null) {
            if (this._library == null) {
                this._initialize();
            }
            if (this._library != null) {
                this._favoritesModel = new DefaultFavoritesModel(this._getHelpbookmarksFile(), (Library)this._library);
            }
        }
        return this._favoritesModel;
    }

    private URL _getHelpbookmarksFile() {
        ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
        URL url = er.getSystemDirectory(HelpSystemAddin.getExtensionID());
        return URLFactory.newURL((URL)url, (String)FAVORITES_FILE);
    }

    final void supportsNavigators(int[] supportedNavigators) {
        this._supportedNavigators = supportedNavigators;
    }

    final boolean isNavigatorSupported(int navigator) {
        for (int i = 0; i < this._supportedNavigators.length; ++i) {
            if (this._supportedNavigators[i] != navigator) continue;
            return true;
        }
        return false;
    }

    Topic getTopicForString(String topicID) {
        return this.getTopicForString(topicID, true);
    }

    Topic getTopicForString(String topicID, boolean displayError) {
        SimpleTopic topic = null;
        if (topicID != null) {
            URL topicURL = this._library.mapIDToURL(topicID);
            if (topicURL != null) {
                SimpleTopic theTopic;
                SimpleURLTarget theTarget = new SimpleURLTarget(null, topicURL.toString());
                topic = theTopic = new SimpleTopic(null, (Target)theTarget);
            } else if (displayError) {
                this._showHelpError(1, HelpArb.format(55, topicID));
            }
        } else if (displayError) {
            this._showHelpError(1, HelpArb.getString(15));
        }
        return topic;
    }

    static final void showLanguageHelpNonOHJ(final Context context, final String symbolName) {
        SwingWorker swingWorker = new SwingWorker(){
            URL url = null;

            public Object construct() {
                block4: {
                    try {
                        if (symbolName == null) break block4;
                        JDevHelpSystemImpl._processManifestForBrowseSymbolResolvers();
                        int listlen = _browseSymbolResolverList.size();
                        for (int i = 0; i < listlen; ++i) {
                            String browseResolverClass = (String)_browseSymbolResolverList.get(i);
                            Class<?> resolverClass = Class.forName(browseResolverClass);
                            BrowseSymbolResolver resolver = (BrowseSymbolResolver)resolverClass.newInstance();
                            Class[] params = new Class[]{Context.class, String.class};
                            Method method = resolverClass.getDeclaredMethod("resolveBrowseSymbol", params);
                            this.url = (URL)method.invoke((Object)resolver, context, symbolName);
                            if (this.url == null) {
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return this.url;
            }

            public void finished() {
                if (symbolName == null) {
                    HelpSystemAddin.showJavadocException(2, "");
                }
                if (this.url == null) {
                    return;
                }
                SimpleURLTarget theTarget = new SimpleURLTarget(null, this.url.toString());
                SimpleTopic theTopic = new SimpleTopic(null, (Target)theTarget);
                Context topicContext = HelpUtils.createContext((Topic)theTopic);
                HelpUtils.createHelpTopicEditor(topicContext, (Topic)theTopic);
                HelpCenterWindow hcw = HelpCenterWindow.getInstance();
                hcw.setVisible(true);
                HelpCenterWindow.getGUI().requestFocus();
            }
        };
        swingWorker.start();
    }

    public final boolean doesTopicExist(String helpTopic) {
        if (!this._initialize()) {
            this._showHelpError(0, null);
            return false;
        }
        URL helpURL = this._library.mapIDToURL(helpTopic);
        return helpURL != null;
    }

    public final Editor showHelp(URL url) {
        if (url == null) {
            throw new NullPointerException("url is null.");
        }
        HelpTopicDocument doc = new HelpTopicDocument(url);
        String shortLabel = URLFileSystem.getFileName((URL)url);
        doc.setShortLabel(shortLabel);
        Context context = Context.newIdeContext((Node)doc);
        return EditorManager.getEditorManager().openEditorInFrame(HelpTopicEditor.class, context);
    }

    public final void showHelp(final JComponent comp) {
        if (Boolean.valueOf(System.getProperty("jdev.skip.help")).booleanValue()) {
            LogManager.getIdeLogWindow().getPage().log((Object)("Help ID: " + oracle.bali.ewt.help.HelpUtils.getHelpID((Component)comp) + "\n"));
            return;
        }
        if (!this._initialize()) {
            this._showHelpError(0, null);
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    HelpInfo helpInfo;
                    String topicID = null;
                    if (comp != null) {
                        Container helpableComponent;
                        for (helpableComponent = comp; helpableComponent != null && !(helpableComponent instanceof Helpable); helpableComponent = helpableComponent.getParent()) {
                        }
                        if (comp == helpableComponent) {
                            helpInfo = ((Helpable)helpableComponent).getHelpInfo();
                            topicID = helpInfo.getHelpTopicID();
                        } else if (helpableComponent == null) {
                            topicID = oracle.bali.ewt.help.HelpUtils.getHelpID((Component)comp);
                        } else {
                            String topicIDA = oracle.bali.ewt.help.HelpUtils.getHelpID((Component)comp);
                            String topicIDB = oracle.bali.ewt.help.HelpUtils.getHelpID((Component)helpableComponent);
                            if (topicIDA != null && !topicIDA.equals(topicIDB)) {
                                topicID = topicIDA;
                            }
                            HelpInfo helpInfo2 = ((Helpable)helpableComponent).getHelpInfo();
                            topicID = helpInfo2.getHelpTopicID();
                        }
                        if (topicID == null && comp instanceof Traversable) {
                            topicID = ((Traversable)comp).getHelpID();
                        }
                    }
                    if (comp != null && topicID == null) {
                        for (Container component = comp; !(component == null || component instanceof Helpable && (helpInfo = ((Helpable)component).getHelpInfo()) != null && (topicID = helpInfo.getHelpTopicID()) != null); component = component.getParent()) {
                        }
                    }
                    if (topicID == null) {
                        JDevHelpSystemImpl.this._showHelpError(1, HelpArb.getString(15));
                    } else {
                        JDevHelpSystemImpl.this._showTopic(topicID);
                    }
                }
                catch (TopicDisplayException tdEx) {
                    JDevHelpSystemImpl.showErrorMessage(WindowUtils.getActiveWindow(), HelpArb.getString(15), null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        Window activeWindow = WindowUtils.getActiveWindow();
        if (activeWindow == null) {
            EventQueue.invokeLater(r);
        } else {
            r.run();
        }
    }

    public final void showHelp(Context ctx) {
        if (!this._initialize()) {
            this._showHelpError(0, null);
            return;
        }
        final Context fCtx = ctx;
        Runnable r = new Runnable(){

            @Override
            public void run() {
                HelpInfo hi = JDevHelpSystemImpl.this._findHelpInfoFromContext(fCtx);
                JDevHelpSystemImpl.this.showHelp(hi);
            }
        };
        SwingUtilities.invokeLater(r);
    }

    public final void showHelp(HelpInfo helpInfo) {
        if (helpInfo != null && helpInfo.getHelpType() != 1 && !this._initialize()) {
            this._showHelpError(0, null);
            return;
        }
        final HelpInfo fHelpInfo = helpInfo;
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (fHelpInfo != null && fHelpInfo.getHelpType() == 1) {
                    JDevHelpSystemImpl.this.showLanguageHelp(fHelpInfo.getContext(), fHelpInfo.getHelpTopicID());
                } else {
                    JDevHelpSystemImpl.this.goTo(fHelpInfo != null ? fHelpInfo.getHelpTopicID() : HelpInfo.getDefaultHelpInfo().getHelpTopicID());
                }
            }
        };
        SwingUtilities.invokeLater(r);
    }

    public final void registerTopic(JComponent component, String topicID) {
        String subst;
        if (this._topicSubstitutes != null && (subst = (String)this._topicSubstitutes.get(topicID)) != null) {
            topicID = subst;
        }
        oracle.bali.ewt.help.HelpUtils.setHelpID((JComponent)component, (String)topicID);
    }

    public final void registerClientWindow(Window aWindow) {
        Help.registerClientWindow((Window)aWindow);
    }

    public final void unregisterClientWindow(Window aWindow) {
        Help.unregisterClientWindow((Window)aWindow);
    }

    public void registerHelpSetURL(URL url) {
        this.registerHelpSetURL(url, null, -1);
    }

    public void registerHelpSetURL(URL url, String relativeTo, int relativePosition) {
        String origStr = url.toExternalForm();
        String[] splits = origStr.split(".jar!");
        this.registerHelpSetURL(splits[0], 0, url, relativeTo, relativePosition, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerBrowseSymbolResolver(String resolverClass) {
        List list = _browseSymbolResolverList;
        synchronized (list) {
            _browseSymbolResolverList.add(resolverClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTipOfDayURL(URL url) {
        List list = this._tipOfDayList;
        synchronized (list) {
            Locale locale;
            String lang;
            URL actualURL = url;
            String origPath = url.getPath();
            if (origPath.indexOf("$edition") != -1) {
                String editionDir = JDevHelpSystemImpl.getEditionDirectory();
                String newPath = origPath.replace("$edition", editionDir);
                actualURL = URLFactory.replacePathPart((URL)actualURL, (String)newPath);
            }
            if (!(lang = (locale = StaticLocaleContext.getLocale()).getLanguage()).equalsIgnoreCase("en")) {
                List<URL> urls = HelpSystemAddin.buildLanguageSpecificURLs(actualURL, false);
                if (urls != null) {
                    for (URL langURL : urls) {
                        if (!URLFileSystem.exists((URL)langURL)) continue;
                        this._tipOfDayList.add(langURL);
                        break;
                    }
                }
            } else if (URLFileSystem.exists((URL)actualURL)) {
                this._tipOfDayList.add(actualURL);
            }
        }
    }

    public MultiMap<String, BookContributor> getBookMap() {
        return this._bookMap;
    }

    public boolean hasTipOfDayEntries() {
        this._processManifestForTipJars();
        return this._tipOfDayList.size() > 0;
    }

    private Topic getTipOfTheDay(URL currentURL) {
        int numTipJars = this._tipOfDayList.size();
        if (numTipJars == 0) {
            return null;
        }
        Topic topic = null;
        DTCache dtCache = Ide.getDTCache();
        int lastJarNum = dtCache.getInteger(HELPSYSTEM_LAST_TIP_JAR, -1);
        int tipNum = dtCache.getInteger(HELPSYSTEM_LAST_TIP, 0);
        if (++lastJarNum >= this._tipOfDayList.size()) {
            lastJarNum = 0;
            ++tipNum;
        }
        dtCache.putInteger(HELPSYSTEM_LAST_TIP_JAR, lastJarNum);
        dtCache.putInteger(HELPSYSTEM_LAST_TIP, tipNum);
        URL tipJarURL = (URL)this._tipOfDayList.get(lastJarNum);
        try {
            JarIndex jarIndex = JarUtil.getJarIndex((URL)tipJarURL);
            String[] entries = jarIndex.getEntries();
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < entries.length; ++i) {
                if (!entries[i].endsWith("html")) continue;
                list.add(entries[i]);
            }
            int tipsAvail = list.size();
            if (tipsAvail == 0) {
                return null;
            }
            if (tipNum >= tipsAvail) {
                tipNum %= tipsAvail;
            }
            String selectedEntry = (String)list.get(tipNum);
            URL entryURL = URLFactory.newJarURL((URL)tipJarURL, (String)selectedEntry);
            if (currentURL != null) {
                String currentPath = currentURL.getPath();
                currentPath = this.replaceEditionString(currentPath);
                String selectedPath = entryURL.getPath();
                if (currentPath.equals(selectedPath = this.replaceEditionString(selectedPath))) {
                    return this.getTipOfTheDay(currentURL);
                }
            }
            HelpTopicDocument helpDocument = new HelpTopicDocument(entryURL);
            topic = helpDocument.getTopic();
        }
        catch (IOException ex) {
            return null;
        }
        return topic;
    }

    private String replaceEditionString(String path) {
        String newPath = path;
        newPath = newPath.replace("java_doc", "");
        newPath = newPath.replace("j2ee_doc", "");
        newPath = newPath.replace("studio_doc", "");
        return newPath;
    }

    public static boolean getShowTipOfDayPreference() {
        DTCache dtCache = Ide.getDTCache();
        return dtCache.getBoolean(HELPSYSTEM_SHOW_TIP_OF_DAY, true);
    }

    public void showTipOfTheDay() {
        boolean suppressTip = Boolean.valueOf(System.getProperty("suppressTipOfDay"));
        if (suppressTip) {
            return;
        }
        Topic topic = this.getTipOfTheDay(null);
        if (topic != null) {
            TipOfDayDialog dialog = new TipOfDayDialog();
            dialog.getHelpContentPanel().displayTopic(topic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerHelpSetURL(String name, int helpAction, URL controlFileURL, String relativeToName, int relativeLocation, Map<String, String> bookMap) {
        if (name == null) {
            return;
        }
        List<HelpJarInfo> list = this._addinHelpSetList;
        synchronized (list) {
            int locationInList = this._findLocationInList(name, this._addinHelpSetList);
            if (helpAction == 1 && locationInList > -1) {
                this._addinHelpSetList.remove(locationInList);
            } else if (locationInList == -1) {
                this._addinHelpSetList.add(new HelpJarInfo(name, controlFileURL, relativeToName, relativeLocation, bookMap));
            } else {
                HelpJarInfo helpJarInfo = this._addinHelpSetList.get(locationInList);
                helpJarInfo.update(controlFileURL, relativeToName, relativeLocation, bookMap);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showTopic(Topic topic) {
        if (topic != null) {
            if (topic instanceof MultipleTypeTopic) {
                MultipleTypeTopic mTopic = (MultipleTypeTopic)topic;
                if (mTopic.getTopicType() == 4) {
                    JDevHelpSystemImpl.showLanguageHelpNonOHJ(Context.newIdeContext(), mTopic.getLanguageString());
                    return;
                }
                if (mTopic.getTopicType() == 3 || mTopic.getTopicType() == 9 || mTopic.getTopicType() == 10) {
                    try {
                        URL externalURL = mTopic.getTarget().getURL();
                        BrowserRunner.getBrowserRunner().runBrowserOnURL(externalURL, null, null);
                    }
                    catch (MalformedURLException mue) {
                        // empty catch block
                    }
                    return;
                }
            }
            Context context = HelpUtils.createContext(topic);
            HelpTopicEditor helpTopicEditor = null;
            if (context != null) {
                helpTopicEditor = HelpUtils.createHelpTopicEditor(context, topic);
            }
            if (helpTopicEditor == null) {
                String err = null;
                Target target = topic.getTarget();
                if (target != null) {
                    err = target instanceof DynamicLinkTarget ? ((DynamicLinkTarget)target).getTopicId() : (target instanceof IndirectTarget ? ((IndirectTarget)target).getTargetName() : target.toString());
                }
                JDevHelpSystemImpl.showErrorMessage((Component)Ide.getMainWindow(), HelpArb.format(22, err), HelpArb.getString(21));
            } else {
                try {
                    HelpCenterWindow.getInstance().getWindow().setCursor(Cursor.getPredefinedCursor(3));
                    helpTopicEditor.displayTopic(topic);
                    if (helpTopicEditor.getParent() instanceof HelpCenterWindow) {
                        HelpCenterWindow hcw = (HelpCenterWindow)helpTopicEditor.getParent();
                        hcw.setVisible(true);
                        final Window window = hcw.getWindow();
                        HelpContentPanel hcp = helpTopicEditor.getHelpContentPanel();
                        final Component findBtn = hcp.getFindButton();
                        JPanel hcwGUI = (JPanel)hcw.getGUI();
                        final FocusTraversalPolicy policy3 = hcwGUI.getFocusTraversalPolicy();
                        Runnable focusPocus = new Runnable(){

                            @Override
                            public void run() {
                                Component focusComp = policy3.getComponentAfter(window, findBtn);
                                if (focusComp != null) {
                                    focusComp.requestFocus();
                                }
                            }
                        };
                        SwingUtilities.invokeLater(focusPocus);
                    }
                }
                finally {
                    HelpCenterWindow.getInstance().getWindow().setCursor(Cursor.getPredefinedCursor(0));
                }
            }
            JDevHelpSystemImpl.printTopicForDebugging(topic, null, null);
        }
    }

    public void showCueCard(String cueCardId) {
        HelpUtils.showCueCard(cueCardId);
    }

    public void invokeWizard(String helpWizardInvokeString, Context context) {
        HelpUtils.invokeWizard(helpWizardInvokeString, context);
    }

    public Boolean checkWizard(String helpWizardInvokeString, Context context) {
        return HelpUtils.checkWizardAvailable(helpWizardInvokeString, context);
    }

    public void invokeAction(String actionString, Context context) {
        HelpUtils.invokeAction(actionString, context);
    }

    public final void goTo(final String topicID) {
        if (!this._initialize()) {
            this._showHelpError(0, null);
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (topicID == null) {
                        JDevHelpSystemImpl.this._showHelpError(1, HelpArb.getString(15));
                    } else {
                        JDevHelpSystemImpl.this._showTopic(topicID);
                    }
                }
                catch (TopicDisplayException tdEx) {
                    JDevHelpSystemImpl.showErrorMessage(WindowUtils.getActiveWindow(), HelpArb.getString(15), null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public void clearHelpSystem() {
        this._dispose();
    }

    public void registerTopicSubstitute(String oldTopicId, String newTopicId) {
        if (this._topicSubstitutes == null) {
            this._topicSubstitutes = new HashMap();
        }
        this._topicSubstitutes.put(oldTopicId, newTopicId);
    }

    static final boolean isDocWriter() {
        return Boolean.valueOf(System.getProperty("docWriter"));
    }

    public static void printTopicForDebugging(Topic topic, String helpID, URL helpURL) {
        if (JDevHelpSystemImpl.isDocWriter()) {
            String helpIdString = null;
            if (helpID != null) {
                helpIdString = "HelpId=" + helpID;
            }
            String helpUrlString = null;
            if (helpURL != null) {
                helpUrlString = "HelpURL=" + helpURL.toString();
            }
            if (topic != null && helpIdString == null) {
                try {
                    Target target;
                    URL topicURL = topic.getTarget().getURL();
                    if (topic.hasTarget() && (target = topic.getTarget()) instanceof IndirectTarget) {
                        IndirectTarget itarget = (IndirectTarget)target;
                        helpIdString = "HelpID=" + itarget.getTargetName();
                    }
                    if (helpUrlString == null) {
                        helpUrlString = "HelpURL=" + topicURL != null ? topicURL.toString() : "unable to map topic to url";
                    }
                }
                catch (MalformedURLException ex) {
                    helpUrlString = "HelpURL= caught MalformedURLException";
                }
            }
            StringBuffer printString = new StringBuffer();
            if (helpIdString != null) {
                printString.append(helpIdString).append(" ");
            }
            if (helpUrlString != null) {
                printString.append(helpUrlString);
            }
            printString.append("\n");
            String pString = printString.toString();
            if (!pString.equals(_lastPrintString)) {
                LogManager.getIdeLogWindow().getPage().log((Object)pString);
                _lastPrintString = pString;
            }
        }
    }

    private synchronized boolean _initialize() {
        if (this._initialized) {
            return true;
        }
        this._init();
        return this._initialized;
    }

    private static void _processManifestForBrowseSymbolResolvers() {
        ExtensionRegistry extReg;
        HelpHook hook;
        if (_browseSymbolResolverList.size() == 0 && (hook = (HelpHook)(extReg = ExtensionRegistry.getExtensionRegistry()).getHook(HelpHook.ELEMENT)) != null) {
            hook.registerBrowseSymbolResolvers(_browseSymbolResolverList);
        }
    }

    static List<String> processManifestForCallbackWizardHandlers() {
        ExtensionRegistry extReg;
        HelpHook hook;
        if (_callbackWizardHandlerList.size() == 0 && (hook = (HelpHook)(extReg = ExtensionRegistry.getExtensionRegistry()).getHook(HelpHook.ELEMENT)) != null) {
            hook.registerCallbackWizardHandlers(_callbackWizardHandlerList);
        }
        return _callbackWizardHandlerList;
    }

    private void _processManifestForTipJars() {
        if (!this._hooksProcessedForTipJars) {
            ExtensionRegistry extReg = ExtensionRegistry.getExtensionRegistry();
            HelpHook hook = (HelpHook)extReg.getHook(HelpHook.ELEMENT);
            if (hook != null) {
                hook.registerHelpTipJars(this);
            }
            this._hooksProcessedForTipJars = true;
        }
    }

    private void _processManifestForHelpSetJars() {
        boolean docReview;
        List<HelpJarInfo> origList = null;
        if (this._addinHelpSetList.size() > 0) {
            origList = this._addinHelpSetList;
            this._addinHelpSetList = new ArrayList<HelpJarInfo>();
        }
        if (!this._hooksProcessedForHelpSetJars) {
            ExtensionRegistry extReg = ExtensionRegistry.getExtensionRegistry();
            HelpHook hook = (HelpHook)extReg.getHook(HelpHook.ELEMENT);
            if (hook != null) {
                hook.registerHelpSetJars(this);
            }
            this._hooksProcessedForHelpSetJars = true;
        }
        if (origList != null) {
            this._addinHelpSetList.addAll(origList);
        }
        if (docReview = JDevHelpSystemImpl.isDocReview()) {
            this.convertURLsToDocReview();
        }
        List<HelpJarInfo> sortedHelpJarList = this._sortData();
        this._addinHelpSetList = sortedHelpJarList;
        if (this._bookMap == null) {
            this._bookMap = new MultiMap();
            this._fillBookMap(this._addinHelpSetList);
        }
    }

    private synchronized void _init() {
        this._processManifestForHelpSetJars();
        this._library = new JDevLibrary();
        ImageLoader.setDefaultImageLoader((ImageLoader)new JDevImageLoader());
        if (!this._loadHelpSystem()) {
            this._dispose();
            this._initialized = false;
            return;
        }
        this._initialized = true;
    }

    private HelpInfo _findHelpInfoFromContext(Context ctx) {
        if (ctx == null) {
            return HelpInfo.getDefaultHelpInfo();
        }
        HelpInfo hi = this._findHelpInfoFromView(ctx.getView());
        if (hi != null) {
            hi.setContext(ctx);
        }
        return hi;
    }

    private HelpInfo _findHelpInfoFromView(View v) {
        if (v == null) {
            return HelpInfo.getDefaultHelpInfo();
        }
        HelpInfo helpInfo = v.getHelpInfo();
        if (helpInfo != null) {
            return helpInfo;
        }
        if (this._isViewOwnerValidAndNotSelf(v)) {
            return this._findHelpInfoFromView(v.owner());
        }
        return HelpInfo.getDefaultHelpInfo();
    }

    private boolean _isViewOwnerValidAndNotSelf(View v) {
        return v != null && v.owner() != null && v.owner() != v;
    }

    private void _showTopic(String topicID) {
        JDevHelpSystemImpl.printTopicForDebugging(null, topicID, null);
        Topic topic = this.getTopicForString(topicID);
        if (topic != null) {
            this.showTopic(topic);
        }
    }

    private final void _fillBookMap(List<HelpJarInfo> sortedHelpJarList) {
        for (HelpJarInfo hjInfo : sortedHelpJarList) {
            Map<String, String> map = hjInfo.getBookMap();
            if (map == null) continue;
            Iterator<String> titleIterator = map.keySet().iterator();
            while (titleIterator.hasNext()) {
                URL controlFileURL = hjInfo.getControlFileURL();
                if (controlFileURL != null && URLFileSystem.exists((URL)controlFileURL)) {
                    String title = titleIterator.next();
                    String label = map.get(title);
                    BookContributor bookContributor = new BookContributor(controlFileURL, label);
                    this._bookMap.add((Object)title, (Object)bookContributor);
                    continue;
                }
                titleIterator.next();
            }
        }
    }

    private URL getLanguageSpecificURL(URL controlFileURL) {
        String language = StaticLocaleContext.getLocale().getLanguage();
        if (!language.equals("_en")) {
            String controlFilePath = controlFileURL.getPath();
            StringBuffer languagePath = new StringBuffer();
            int dotJarPos = controlFilePath.indexOf(".jar!");
            languagePath.append(controlFilePath.substring(0, dotJarPos));
            languagePath.append("_");
            languagePath.append(language);
            languagePath.append(controlFilePath.substring(dotJarPos));
            return URLFactory.replacePathPart((URL)controlFileURL, (String)languagePath.toString());
        }
        return null;
    }

    private final boolean _loadHelpSystem() {
        this._loadErrors.clear();
        for (HelpJarInfo helpJarInfo : this._addinHelpSetList) {
            URL controlFile = helpJarInfo.getControlFileURL();
            URL languageSpecificControlFile = this.getLanguageSpecificURL(controlFile);
            if (languageSpecificControlFile != null && URLFileSystem.exists((URL)languageSpecificControlFile)) {
                this._loadHelpFromURL(languageSpecificControlFile);
                continue;
            }
            if (controlFile == null || !URLFileSystem.exists((URL)controlFile)) continue;
            this._loadHelpFromURL(controlFile);
        }
        this._addinHelpSetList.clear();
        if (this._library == null) {
            return false;
        }
        try {
            this._library.addBook(new JavadocBook());
        }
        catch (LibraryException libraryException) {
            // empty catch block
        }
        return this._library.getBookCount() != 0;
    }

    private List<HelpJarInfo> _sortData() {
        ArrayList<HelpJarInfo> orderedList = new ArrayList<HelpJarInfo>(this._addinHelpSetList.size());
        ArrayList<HelpJarInfo> removeList = new ArrayList<HelpJarInfo>();
        while (this._addinHelpSetList.size() > 0) {
            for (HelpJarInfo info : this._addinHelpSetList) {
                if (info.getRelativeToName() == null) {
                    orderedList.add(info);
                    removeList.add(info);
                    continue;
                }
                int pos = this._getPos(orderedList, info.getRelativeToName());
                if (pos != -1) {
                    if (info.getRelativeLocation() == 0) {
                        orderedList.add(Math.max(pos, 0), info);
                        removeList.add(info);
                        continue;
                    }
                    if (pos < orderedList.size() - 1) {
                        orderedList.add(pos + 1, info);
                    } else {
                        orderedList.add(info);
                    }
                    removeList.add(info);
                    continue;
                }
                pos = this._getPos(this._addinHelpSetList, info.getRelativeToName());
                if (pos != -1) continue;
                orderedList.add(info);
                removeList.add(info);
            }
            this._addinHelpSetList.removeAll(removeList);
            removeList.clear();
        }
        return orderedList;
    }

    private int _getPos(List<HelpJarInfo> list, String name) {
        int pos = -1;
        for (int i = 0; i < list.size(); ++i) {
            HelpJarInfo info = list.get(i);
            if (!info.getName().equals(name)) continue;
            pos = i;
            break;
        }
        return pos;
    }

    private int _findLocationInList(String findName, List list) {
        int numBooks = list.size();
        for (int i = 0; i < numBooks; ++i) {
            HelpJarInfo listHelpJarInfo = (HelpJarInfo)list.get(i);
            if (!findName.toLowerCase().equals(listHelpJarInfo.getName().toLowerCase())) continue;
            return i;
        }
        return -1;
    }

    private final void _loadHelpFromURL(URL helpUrl) {
        if (helpUrl == null) {
            return;
        }
        try {
            this._library.addBook((Book)new JDevHelpSet(helpUrl));
        }
        catch (Exception ex) {
            this._loadErrors.add(HelpArb.format(17, helpUrl.toString()));
        }
    }

    private final void _showHelpError(int errorType, String errorMsg) {
        if (this._checkModalMode()) {
            String errMsg = errorMsg;
            if (errorType == 0) {
                errMsg = HelpArb.getString(57);
            }
            JDevHelpSystemImpl.showErrorMessage(this._modalOwner, errMsg, HelpArb.getString(56));
        } else {
            HelpWindow hWindow = (HelpWindow)DockStation.getDockStation().getDockable(new ViewId("HelpSystemAddin", "HelpWindow"));
            if (hWindow != null && errorType == 0) {
                hWindow.switchNavigator(4);
                hWindow.show();
            } else {
                JDevHelpSystemImpl.showErrorMessage((Component)Ide.getMainWindow(), errorMsg, HelpArb.getString(56));
            }
        }
    }

    private final void _dispose() {
        this._library = null;
        HelpWindow helpWindow = (HelpWindow)DockStation.getDockStation().getDockable(HelpWindow.getHelpWindowViewId());
        if (helpWindow != null) {
            helpWindow.dispose();
        }
        this._topicSubstitutes = null;
        this._initialized = false;
    }

    static final boolean isDocReview() {
        return Boolean.valueOf(System.getProperty("docReview"));
    }

    static final URL convertURLToDocReview(URL helpURL) {
        URL url = helpURL;
        String urlStr = helpURL.toString();
        if (urlStr.indexOf("ohj") != -1) {
            urlStr = urlStr.replaceFirst("ohj", "hosted");
            url = URLFactory.newURL((String)urlStr);
        }
        return url;
    }

    private final void convertURLsToDocReview() {
        for (HelpJarInfo helpJarInfo : this._addinHelpSetList) {
            Map<String, String> bookMap = helpJarInfo.getBookMap();
            URL controlFileURL = helpJarInfo.getControlFileURL();
            controlFileURL = JDevHelpSystemImpl.convertURLToDocReview(controlFileURL);
            helpJarInfo.update(controlFileURL, null, -1, bookMap);
        }
    }

    protected void clearModalDialog() {
        this._modalDialog = null;
    }

    protected void setModalDialog(ModalHelpContentDialog dialog) {
        this._modalDialog = dialog;
    }

    static String getEditionDirectory() {
        if (_editionDirectory == null) {
            ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
            Extension extension = registry.findExtension("oracle.studio.help");
            _editionDirectory = extension != null ? JDevHelpSystemImpl.ensureDirectory("studio_doc") : ((extension = registry.findExtension("oracle.j2ee.help")) != null ? JDevHelpSystemImpl.ensureDirectory("j2ee_doc") : JDevHelpSystemImpl.ensureDirectory("java_doc"));
        }
        return _editionDirectory;
    }

    private static String ensureDirectory(String expectedEdition) {
        String testDir = Ide.getProductHomeDirectory();
        if (URLFileSystem.exists((URL)URLFactory.newDirURL((String)(testDir + expectedEdition)))) {
            return expectedEdition;
        }
        if (URLFileSystem.exists((URL)URLFactory.newDirURL((String)(testDir + "doc/studio_doc")))) {
            return "studio_doc";
        }
        if (URLFileSystem.exists((URL)URLFactory.newDirURL((String)(testDir + "doc/j2ee_doc")))) {
            return "j2ee_doc";
        }
        return "java_doc";
    }

    private Dialog _getActiveModalOwnerDialog() {
        Dialog modalOwner = null;
        for (Window aWindow = WindowUtils.getActiveWindow(); aWindow != null; aWindow = (Window)aWindow.getParent()) {
            Dialog theDialog;
            if (!(aWindow instanceof Dialog) || !(theDialog = (Dialog)aWindow).isModal()) continue;
            modalOwner = theDialog;
            break;
        }
        return modalOwner;
    }

    private boolean _checkModalMode() {
        Dialog newModalOwner = this._getActiveModalOwnerDialog();
        boolean modalMode = false;
        boolean aParentIsModal = false;
        if (newModalOwner != null) {
            aParentIsModal = true;
        }
        if (aParentIsModal && !modalMode) {
            modalMode = true;
        } else if (modalMode && !aParentIsModal) {
            modalMode = false;
        }
        this._modalOwner = newModalOwner;
        return modalMode;
    }

    static void showErrorMessage(final Component parent, final String message, final String title) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(parent, message, title, 0);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public URL resolveTopicId(String topicId) {
        Library library = this.getLibrary();
        if (library != null) {
            return library.mapIDToURL(topicId);
        }
        return null;
    }

    static {
        _browseSymbolResolverList = new ArrayList();
        _callbackWizardHandlerList = new ArrayList<String>();
    }

    public final class BookContributor {
        private URL _url;
        private String _label;

        public BookContributor(URL url, String label) {
            this._url = url;
            this._label = label;
        }

        public URL getURL() {
            return this._url;
        }

        public String getLabel() {
            return this._label;
        }
    }

    class TipOfDayDialog {
        private HelpContentPanel _helpContentPanel;
        private JPanel _panel;
        private JCheckBox _cBox;
        private GhostPalette _ghostPalette = new GhostPalette((JComponent)Ide.getMainWindow().getContentPane());

        public TipOfDayDialog() {
            this._panel = new JPanel(new BorderLayout(0, 5));
            this._helpContentPanel = new HelpContentPanel(this, false);
            this._panel.add(this._helpContentPanel.getGUI());
            HelpSystem.getHelpSystem().registerTopic((JComponent)this._panel, "ide_aonlinehelp_html");
            this._cBox = new JCheckBox();
            this._cBox.setSelected(JDevHelpSystemImpl.getShowTipOfDayPreference());
            ResourceUtils.resButton((AbstractButton)this._cBox, (String)HelpArb.getString(90));
            this._cBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DTCache dtCache = Ide.getDTCache();
                    dtCache.putBoolean(JDevHelpSystemImpl.HELPSYSTEM_SHOW_TIP_OF_DAY, TipOfDayDialog.this._cBox.isSelected());
                }
            });
            JButton nextTipBtn = new JButton(OracleIcons.getIcon((String)"navigateForward.png"));
            nextTipBtn.setMargin(new Insets(1, 1, 0, 0));
            nextTipBtn.setToolTipText(StringUtils.stripMnemonic((String)HelpArb.getString(91)));
            nextTipBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Topic tipTopic = JDevHelpSystemImpl.this.getTipOfTheDay(TipOfDayDialog.this.getHelpContentPanel().getTopicPanel().getCurrentURL());
                    if (tipTopic != null) {
                        TipOfDayDialog.this.getHelpContentPanel().displayTopic(tipTopic);
                    }
                }
            });
            JPanel bottomPanel = new JPanel(new BorderLayout(5, 5));
            bottomPanel.add((Component)this._cBox, "Before");
            bottomPanel.add((Component)nextTipBtn, "After");
            this._panel.add((Component)bottomPanel, "South");
            this._panel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            this._ghostPalette.add((Component)this._panel);
            this._ghostPalette.setSize(450, 400);
            this._ghostPalette.setHideOnLoseFocus(false);
            this._ghostPalette.setLook(UIConstants.Look.DARK);
            this._ghostPalette.setMinimumSize(new Dimension(450, 400));
            this._ghostPalette.setResizable(true);
            this._ghostPalette.setTitle(HelpArb.getString(89));
            this._ghostPalette.addAncestorListener(new AncestorListener(){

                @Override
                public void ancestorRemoved(AncestorEvent event) {
                    if (TipOfDayDialog.this._helpContentPanel != null) {
                        TipOfDayDialog.this._helpContentPanel.dispose();
                        TipOfDayDialog.this._helpContentPanel = null;
                    }
                    TipOfDayDialog.this._ghostPalette.removeAncestorListener((AncestorListener)this);
                }

                @Override
                public void ancestorMoved(AncestorEvent event) {
                }

                @Override
                public void ancestorAdded(AncestorEvent event) {
                }
            });
            this._ghostPalette.show(Ide.getMainWindow().getLayeredPane(), true, false);
        }

        public HelpContentPanel getHelpContentPanel() {
            return this._helpContentPanel;
        }

        public JCheckBox getCheckBox() {
            return this._cBox;
        }
    }

    private static class HelpJarInfo {
        private String _name;
        private URL _controlFileURL;
        private String _relativeToName;
        private int _relativeLocation;
        private Map<String, String> _bookMap;

        public HelpJarInfo(String name, URL controlFileURL, String relativeToName, int relativeLocation, Map<String, String> bookMap) {
            this._name = name;
            this._controlFileURL = controlFileURL;
            this._relativeToName = relativeToName;
            this._relativeLocation = relativeLocation;
            this._bookMap = bookMap;
        }

        public String getName() {
            return this._name;
        }

        public URL getControlFileURL() {
            if (this._controlFileURL.toString().indexOf("$edition") > -1) {
                String editionDir = JDevHelpSystemImpl.getEditionDirectory();
                String origPath = this._controlFileURL.getPath();
                String newPath = origPath.replace("$edition", editionDir);
                this._controlFileURL = URLFactory.replacePathPart((URL)this._controlFileURL, (String)newPath);
            }
            return this._controlFileURL;
        }

        public String getRelativeToName() {
            return this._relativeToName;
        }

        public int getRelativeLocation() {
            return this._relativeLocation;
        }

        public Map<String, String> getBookMap() {
            return this._bookMap;
        }

        public void update(URL controlFileURL, String relativeToName, int relativeLocation, Map<String, String> bookMap) {
            if (controlFileURL != null) {
                this._controlFileURL = controlFileURL;
            }
            if (relativeToName != null) {
                this._relativeToName = relativeToName;
            }
            if (relativeLocation != -1) {
                this._relativeLocation = relativeLocation;
            }
            this._bookMap = bookMap;
        }
    }
}

