/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.help.HelpUnavailableException;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.help.common.util.java.StaticLocaleContext;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeAdapter;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.ProductInformation;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.config.IdeSettings;
import oracle.ide.config.Preferences;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.DocumentInfo;
import oracle.ide.model.Node;
import oracle.ide.model.Recognizer;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.print.PrintManager;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.MenuSpec;
import oracle.ide.webbrowser.BrowserRunner;
import oracle.ideri.util.Product;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.Copyable;
import oracle.jdevimpl.help.HelpArb;
import oracle.jdevimpl.help.HelpCenterWindow;
import oracle.jdevimpl.help.HelpContentPanel;
import oracle.jdevimpl.help.HelpOptions;
import oracle.jdevimpl.help.HelpSystemConstants;
import oracle.jdevimpl.help.HelpTopicDocument;
import oracle.jdevimpl.help.HelpTopicDocumentPrintFactory;
import oracle.jdevimpl.help.HelpTopicEditor;
import oracle.jdevimpl.help.HelpWindow;
import oracle.jdevimpl.help.JDevHelpSystemImpl;
import oracle.jdevimpl.help.JDevTOCNavigator;

public final class HelpSystemAddin
extends EditorAddin
implements ShutdownHook,
Controller {
    private static final float WEIGHT_HELP_SEARCH = 1.0f;
    private static final float WEIGHT_HELP_TOC = 2.0f;
    private static final float WEIGHT_HELP_CUECARDS = 3.0f;
    private static final float WEIGHT_HELP_FAVORITES = 4.0f;
    private static final float WEIGHT_HELP_DYNAMIC_LINKS = 5.0f;
    private static final float WEIGHT_HELP_START_PAGE = 6.0f;
    private static final float WEIGHT_HELP_FORUM = 7.0f;
    private static final float WEIGHT_HELP_OTN = 8.0f;
    private static final float WEIGHT_HELP_RELEASE_NOTES = 0.0f;
    private static final float WEIGHT_HELP_TIP_OF_DAY = 1.0f;
    private static HelpSystem _helpSystem;
    private MenuSpec _menuSpec;
    private boolean _readmeFileExists;
    private static final String GLOBAL_ACCELERATORS = "oracle/jdevimpl/help/accelerators.xml";
    static final String LOCAL_ACCELERATORS = "oracle/jdevimpl/help/localaccelerators.xml";
    private static final String WEBLINK_README_FILENAME = "readme.html";
    private static final String WELCOME_PAGE_FILENAME = "welcome";
    private static final String WELCOME_PAGE_FILE_EXT = ".html";
    private static final String WELCOME_DIR = "doc/welcome";
    private static final String CUE_CARD_MAIN_TOPIC = "cc_jdevmain_html";
    static final int DOCERROR_URL_FAILED = 0;
    static final int DOCERROR_SYMBOL_NOT_FOUND = 1;
    static final int DOCERROR_SYMBOL_NOT_DETERMINED = 2;
    static String START_PAGE_PROTOCOL;

    public final void initialize() {
        File readmeFile;
        int[] supportedNavigators;
        JDevHelpSystemImpl helpSystemImpl = new JDevHelpSystemImpl();
        _helpSystem = helpSystemImpl;
        this._initHelpProvider();
        if (Product.isRaptor()) {
            supportedNavigators = new int[]{0};
            helpSystemImpl.supportsNavigators(supportedNavigators);
        } else {
            supportedNavigators = new int[]{0, 1, 2, 3};
            helpSystemImpl.supportsNavigators(supportedNavigators);
        }
        WindowUtils.registerWindow((Window)Ide.getMainWindow());
        Menubar mm = Ide.getMenubar();
        AddinManager am = AddinManager.getAddinManager();
        JMenu help = MenuManager.getJMenu((String)"Help");
        File ideHome = new File(Ide.getProductHomeDirectory());
        String sCategory = IdeArb.getString((int)417);
        URLFileSystem.addURLStreamHandlerFactory((URLStreamHandlerFactory)new StartPageStreamHandlerFactory());
        URLFileSystem.registerHelper((String)START_PAGE_PROTOCOL, (URLFileSystemHelper)new StartPageFileSystemHelper());
        URL welcomeFile = this.getWelcomePageUrl();
        if (welcomeFile != null) {
            this._createActionAndMenu(mm, help, HelpSystemConstants.SHOW_WELCOME_PAGE_CMD_ID, "oracle.jdevimpl.help.welcomePage", sCategory, HelpArb.getString(3), null, 6.0f, 1.0f);
        }
        if (helpSystemImpl.isNavigatorSupported(0)) {
            this._createActionAndMenu(mm, help, HelpSystemConstants.SHOW_TOC_CMD_ID, "oracle.jdevimpl.help.TableOfContents", sCategory, HelpArb.getString(7), OracleIcons.getIcon((String)"library.png"), 2.0f, 1.0f);
        }
        if (helpSystemImpl.isNavigatorSupported(3)) {
            this._createActionAndMenu(mm, help, HelpSystemConstants.SHOW_CUE_CMD_ID, "oracle.jdevimpl.help.CueCards", sCategory, HelpArb.getString(11), OracleIcons.getIcon((String)"cuecard.png"), 3.0f, 1.0f);
        }
        if (helpSystemImpl.isNavigatorSupported(2)) {
            this._createActionAndMenu(mm, help, HelpSystemConstants.SHOW_DYNAMIC_LINKS_CMD_ID, "oracle.jdevimpl.help.DynamicLinks", sCategory, HelpArb.getString(10), OracleIcons.getIcon((String)"dynamicLink.png"), 5.0f, 1.0f);
        }
        this._createActionAndMenu(mm, help, HelpSystemConstants.SHOW_FULL_TEXT_SEARCH_CMD_ID, "oracle.jdevimpl.help.FullTextSearch", sCategory, HelpArb.getString(8), OracleIcons.getIcon((String)"find.png"), 1.0f, 1.0f);
        if (helpSystemImpl.isNavigatorSupported(1)) {
            this._createActionAndMenu(mm, help, HelpSystemConstants.SHOW_FAV_CMD_ID, "oracle.jdevimpl.help.Favorites", sCategory, HelpArb.getString(9), OracleIcons.getIcon((String)"favorites.png"), 4.0f, 1.0f);
        }
        if (Product.isJDeveloper()) {
            this._createActionAndMenu(mm, help, HelpSystemConstants.SHOW_FORUM_CMD_ID, "oracle.jdevimpl.help.ShowOTNForum", sCategory, HelpArb.getString(5), OracleIcons.getIcon((String)"forum.png"), 7.0f, MenuConstants.SECTION_HELP_GENERAL_HELP);
            this._createActionAndMenu(mm, help, HelpSystemConstants.WEBLINK_OTN_CMD_ID, "oracle.jdevimpl.help.WebLinkOtn", sCategory, HelpArb.getString(0), null, 8.0f, MenuConstants.SECTION_HELP_GENERAL_HELP);
        }
        if ((readmeFile = new File(ideHome, WEBLINK_README_FILENAME)).exists()) {
            this._createActionAndMenu(mm, help, HelpSystemConstants.WEBLINK_README_CMD_ID, "oracle.jdevimpl.help.WebLinkReadme", sCategory, HelpArb.getString(1), null, 0.0f, MenuConstants.SECTION_HELP_UPDATES);
            this._readmeFileExists = true;
        }
        this._createActionAndMenu(mm, help, HelpSystemConstants.SHOW_TIP_OF_DAY_CMD_ID, "oracle.jdevimpl.help.tipOfDay", sCategory, HelpArb.getString(6), null, 1.0f, MenuConstants.SECTION_HELP_ADDINS);
        IdeAction action = IdeAction.find((int)HelpSystemConstants.SHOW_TIP_OF_DAY_CMD_ID);
        if (action != null) {
            action.setEnabled(false);
        }
        String chelpTopicsCmd = am.getCommand(HelpSystemConstants.CHELP_TOPICS_ID, "oracle.jdevimpl.help.ContextHelpCommand");
        IdeAction a = IdeAction.get((int)HelpSystemConstants.CHELP_TOPICS_ID, (String)chelpTopicsCmd, (String)HelpArb.getString(50), (String)sCategory, null, null, null, (boolean)true);
        a.addController((Controller)this);
        IdeAction.get((int)HelpSystemConstants.BACKWARD_CMD_ID, null, (String)HelpArb.getString(45), (String)sCategory, null, (Icon)OracleIcons.getIcon((String)"navigateBack.png"), null, (boolean)true);
        IdeAction.get((int)HelpSystemConstants.FORWARD_CMD_ID, null, (String)HelpArb.getString(46), (String)sCategory, null, (Icon)OracleIcons.getIcon((String)"navigateForward.png"), null, (boolean)true);
        IdeAction.get((int)HelpSystemConstants.ADD_FAVORITE_CMD_ID, (String)"oracle.jdevimpl.help.AddFavoriteCmd", (String)HelpArb.getString(60), (String)sCategory, (Integer)HelpArb.getInteger(61), (Icon)OracleIcons.getIcon((String)"addFavorites.png"), null, (boolean)true);
        Ide.getKeyStrokeContextRegistry().addAcceleratorDefinitionFile(((Object)((Object)this)).getClass().getClassLoader(), GLOBAL_ACCELERATORS);
        Ide.getKeyStrokeContextRegistry().addAcceleratorDefinitionFile(((Object)((Object)this)).getClass().getClassLoader(), LOCAL_ACCELERATORS);
        this._initIdePreferencesPanels();
        EditorManager editorMgr = EditorManager.getEditorManager();
        Class[] types = new Class[]{HelpTopicDocument.class};
        editorMgr.register((EditorAddin)this, types);
        PrintManager.getPrintManager().registerDocumentPrintFactory(HelpTopicEditor.class, HelpTopicDocumentPrintFactory.class);
        PrintManager.getPrintManager().registerDocumentPrintFactory(HelpWindow.class, HelpTopicDocumentPrintFactory.class);
        PrintManager.getPrintManager().registerDocumentPrintFactory(HelpContentPanel.class, HelpTopicDocumentPrintFactory.class);
        Recognizer.mapExtensionToClass((String)".helpT", HelpTopicDocument.class);
        Recognizer.mapExtensionToClass((String)".help", HelpTopicDocument.class);
        Recognizer.registerDocumentInfo(HelpTopicDocument.class, (DocumentInfo)new DocumentInfo(HelpArb.getString(49)));
        Ide.addIdeListener((IdeListener)new IdeAdapter(){

            public void mainWindowOpened(IdeEvent e) {
                HelpSystemAddin.this._mainWindowOpened();
                ((JDevHelpSystemImpl)_helpSystem).loadHelpWindows();
                Ide.removeIdeListener((IdeListener)this);
            }
        });
        ExitCommand.addShutdownHook((ShutdownHook)this);
    }

    private final void _createActionAndMenu(Menubar mm, JMenu help, int commandId, String commandString, String commandCategory, String label, Icon icon, float menuWeight, float menuSection) {
        IdeAction a = IdeAction.get((int)commandId, (String)commandString, (String)StringUtils.stripMnemonic((String)label), (String)commandCategory, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)label)), (Icon)icon, null, (boolean)true);
        a.addController((Controller)this);
        JMenuItem mitem = mm.createMenuItem((ToggleAction)a, menuWeight);
        mm.add((Component)mitem, help, menuSection);
    }

    private final void _mainWindowOpened() {
        HelpOptions helpOptions;
        boolean noNag = Ide.getIdeArgs().hasArg("-nonag");
        String showWelcomePageProperty = Ide.getProperty((String)"Ide.ShowWelcomePage", (String)Boolean.TRUE.toString());
        boolean showWelcomePage = Boolean.valueOf(showWelcomePageProperty);
        if (showWelcomePage) {
            URL welcomeURL = this.getWelcomePageUrl();
            if (welcomeURL != null && URLFileSystem.exists((URL)welcomeURL) && !noNag) {
                HelpSystemAddin.openEditorInFrameExternal(welcomeURL, null, HelpArb.getString(4));
            }
            Ide.setProperty((String)"Ide.ShowWelcomePage", (String)Boolean.FALSE.toString());
        }
        if (_helpSystem.hasTipOfDayEntries()) {
            IdeAction action = IdeAction.find((int)HelpSystemConstants.SHOW_TIP_OF_DAY_CMD_ID);
            if (action != null) {
                action.setEnabled(true);
            }
            if (JDevHelpSystemImpl.getShowTipOfDayPreference() && !noNag) {
                _helpSystem.showTipOfTheDay();
            }
        }
        if ((helpOptions = HelpOptions.getInstance()).getHelpCenterWindowOpen()) {
            this.showNavigator(0, null);
        }
    }

    private final void _initHelpProvider() {
        HelpUtils.setDefaultHelpProvider((HelpProvider)new HelpProvider(){

            public void showHelp(Component component) throws HelpUnavailableException {
                if (component instanceof JComponent) {
                    _helpSystem.showHelp((JComponent)component);
                }
            }
        });
        HelpSystem.setHelpSystem((HelpSystem)_helpSystem);
    }

    private final void _initIdePreferencesPanels() {
        Preferences prefs = Preferences.getPreferences();
        HelpOptions helpOptions = HelpOptions.getInstance((PropertyStorage)prefs);
        IdeSettings ideSettings = Ide.getSettings();
        ideSettings.putLegacyData("HelpOptions", (Copyable)helpOptions);
    }

    public final void shutdown() {
        HelpCenterWindow.saveLayout();
        _helpSystem.clearHelpSystem();
    }

    public boolean canShutdown() {
        return true;
    }

    public final boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == HelpSystemConstants.WEBLINK_README_CMD_ID) {
            if (this._readmeFileExists) {
                File ideHome = new File(Ide.getProductHomeDirectory());
                File readmeFile = new File(ideHome, WEBLINK_README_FILENAME);
                URL url = URLFactory.newFileURL((File)readmeFile);
                HelpSystemAddin.openEditorInFrameExternal(url, null, HelpArb.getString(2));
            }
            return true;
        }
        if (cmdId == HelpSystemConstants.WEBLINK_OTN_CMD_ID) {
            this.showWebSite(HelpArb.getString(13));
            return true;
        }
        if (cmdId == HelpSystemConstants.SHOW_TOC_CMD_ID) {
            this.showNavigator(0, null);
            return true;
        }
        if (cmdId == HelpSystemConstants.SHOW_DYNAMIC_LINKS_CMD_ID) {
            this.showNavigator(2, null);
            return true;
        }
        if (cmdId == HelpSystemConstants.SHOW_FULL_TEXT_SEARCH_CMD_ID) {
            this.showSearch();
            return true;
        }
        if (cmdId == HelpSystemConstants.SHOW_FAV_CMD_ID) {
            this.showNavigator(1, null);
            return true;
        }
        if (cmdId == HelpSystemConstants.SHOW_CUE_CMD_ID) {
            this.showNavigator(0, null);
            HelpSystem.getHelpSystem().goTo(CUE_CARD_MAIN_TOPIC);
            return true;
        }
        if (cmdId == HelpSystemConstants.SHOW_FORUM_CMD_ID) {
            this.showWebSite(HelpArb.getString(14));
            return true;
        }
        if (cmdId == HelpSystemConstants.SHOW_WELCOME_PAGE_CMD_ID) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    URL url = HelpSystemAddin.this.getWelcomePageUrl();
                    if (url != null) {
                        HelpSystemAddin.openEditorInFrameExternal(url, null, HelpArb.getString(4));
                    }
                }
            };
            EventQueue.invokeLater(r);
            return true;
        }
        if (cmdId == HelpSystemConstants.SHOW_TIP_OF_DAY_CMD_ID) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    _helpSystem.showTipOfTheDay();
                }
            };
            EventQueue.invokeLater(r);
            return true;
        }
        if (cmdId == HelpSystemConstants.FORWARD_CMD_ID && context.getView() instanceof HelpContentPanel) {
            return context.getView().getController().handleEvent(action, context);
        }
        return false;
    }

    private static URL replaceWelcomeURLProtocol(URL welcomePage) {
        URL newURL = URLFactory.replaceProtocolPart((URL)welcomePage, (String)START_PAGE_PROTOCOL);
        return newURL;
    }

    private URL getWelcomePageUrl() {
        String editionName;
        URL welcomePageUrl = null;
        ProductInformation productInfo = ProductInformation.getProductInformation();
        if (productInfo != null && !URLFileSystem.exists((URL)(welcomePageUrl = productInfo.getWelcomePage())) && (editionName = productInfo.getEditionName()) != null && (editionName.equals("Java Edition") || editionName.equals("J2EE Edition"))) {
            String path = welcomePageUrl.getPath();
            path = path.replace("welcome-java", "welcome-studio");
            path = path.replace("welcome-j2ee", "welcome-studio");
            welcomePageUrl = URLFactory.replacePathPart((URL)welcomePageUrl, (String)path);
        }
        if (welcomePageUrl == null) {
            File ideHome = new File(Ide.getProductHomeDirectory());
            File welcomeDir = new File(ideHome, WELCOME_DIR);
            File welcomeFile = new File(welcomeDir, WELCOME_PAGE_FILENAME);
            welcomePageUrl = URLFactory.newFileURL((File)welcomeFile);
        }
        URL welcomeFileDir = URLFileSystem.getParent((URL)welcomePageUrl);
        String welcomeFileName = URLFileSystem.getName((URL)welcomePageUrl);
        List<URL> potentialDirURLs = HelpSystemAddin.buildLanguageSpecificURLs(welcomeFileDir, true);
        for (URL url : potentialDirURLs) {
            URL welcomeURL = URLFactory.newURL((URL)url, (String)(welcomeFileName + WELCOME_PAGE_FILE_EXT));
            if (!URLFileSystem.exists((URL)welcomeURL)) continue;
            return HelpSystemAddin.replaceWelcomeURLProtocol(welcomeURL);
        }
        return null;
    }

    static List<URL> buildLanguageSpecificURLs(URL url, boolean includeBase) {
        ArrayList<URL> urlList = new ArrayList<URL>();
        ArrayList<String> langList = new ArrayList<String>();
        Locale locale = StaticLocaleContext.getLocale();
        String lang = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        StringBuffer sb = new StringBuffer();
        if (lang != null && lang.length() > 0) {
            sb.append(lang);
            String langPath = sb.toString();
            if (country != null && country.length() > 0) {
                sb.append("_");
                sb.append(country);
                String langCountryPath = sb.toString();
                if (variant != null && variant.length() > 0) {
                    sb.append("_");
                    sb.append(variant);
                    String langCountryVariantPath = sb.toString();
                    langList.add(langCountryVariantPath);
                }
                langList.add(langCountryPath);
            }
            langList.add(langPath);
        }
        if (langList.size() > 0) {
            String ext = URLFileSystem.getSuffix((URL)url);
            String path = URLFileSystem.getPathNoExt((URL)url);
            for (String langExt : langList) {
                sb = new StringBuffer(path);
                if (ext != null && ext.length() > 0) {
                    sb.append("_");
                    sb.append(langExt);
                    sb.append(ext);
                } else {
                    sb.append(langExt);
                }
                urlList.add(URLFactory.replacePathPart((URL)url, (String)sb.toString()));
            }
        }
        if (includeBase) {
            urlList.add(url);
        }
        if (urlList.size() == 0) {
            return null;
        }
        return urlList;
    }

    private void showSearch() {
        HelpCenterWindow hcWindow = null;
        hcWindow = HelpCenterWindow.getInstance();
        hcWindow.setVisible(true);
        hcWindow.requestFocus();
        this.showNavigator(0, null);
        hcWindow.focusSearchControl();
    }

    private void showNavigator(int navigatorToShow, String bookTitle) {
        Component c;
        JDevTOCNavigator tocNav;
        HelpCenterWindow hcWindow = null;
        hcWindow = HelpCenterWindow.getInstance();
        hcWindow.setVisible(true);
        hcWindow.requestFocus();
        hcWindow.switchNavigator(navigatorToShow);
        if (navigatorToShow == 0 && (tocNav = HelpCenterWindow.getTOCNavigator()) != null) {
            tocNav.setTOCSelection(bookTitle);
        }
        if ((c = HelpCenterWindow.getInstance().getCurrentNavigator()) != null) {
            GraphicsUtils.focusComponentOrChild((Component)c, (boolean)true);
        }
    }

    private void showWebSite(String webSiteString) {
        try {
            URL webSiteURL = new URL(webSiteString);
            BrowserRunner.getBrowserRunner().runBrowserOnURL(webSiteURL, null, null);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public final boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == HelpSystemConstants.CHELP_TOPICS_ID || cmdId == HelpSystemConstants.SHOW_WELCOME_PAGE_CMD_ID || cmdId == HelpSystemConstants.SHOW_TOC_CMD_ID || cmdId == HelpSystemConstants.SHOW_DYNAMIC_LINKS_CMD_ID || cmdId == HelpSystemConstants.SHOW_FULL_TEXT_SEARCH_CMD_ID || cmdId == HelpSystemConstants.SHOW_FAV_CMD_ID || cmdId == HelpSystemConstants.SHOW_CUE_CMD_ID || cmdId == HelpSystemConstants.SHOW_FORUM_CMD_ID || cmdId == HelpSystemConstants.WEBLINK_OTN_CMD_ID) {
            action.setEnabled(true);
            return true;
        }
        if (cmdId == HelpSystemConstants.WEBLINK_README_CMD_ID) {
            if (this._readmeFileExists) {
                action.setEnabled(true);
            }
            return true;
        }
        return false;
    }

    public static void openEditorInFrameExternal(URL url) {
        HelpSystemAddin.openEditorInFrameExternal(url, null, null);
    }

    public static void openEditorInFrameExternal(URL url, Icon icon, String shortLabel) {
        HelpTopicDocument doc = new HelpTopicDocument(url);
        if (icon != null) {
            doc.setIcon(icon);
        }
        if (shortLabel != null) {
            doc.setShortLabel(shortLabel);
        }
        Context context = Context.newIdeContext((Node)doc);
        context.setWorkspace(null);
        context.setProject(null);
        EditorManager editorMgr = EditorManager.getEditorManager();
        HelpTopicEditor editor = (HelpTopicEditor)editorMgr.openEditorInFrame(HelpTopicEditor.class, context);
        if (shortLabel == null) {
            editor.setSharable(true);
        } else {
            editor.setSharable(false);
        }
        if (editor == null) {
            HelpSystemAddin.showJavadocException(0, url.toString());
        }
    }

    static void showJavadocException(int errorCode, String msg) {
        String errorMsg = null;
        switch (errorCode) {
            case 0: {
                errorMsg = HelpArb.format(17, msg);
                break;
            }
            case 1: {
                errorMsg = HelpArb.format(18, msg);
                break;
            }
            case 2: {
                errorMsg = HelpArb.format(19, msg);
                break;
            }
            default: {
                errorMsg = HelpArb.getString(20);
            }
        }
        final String innerMsg = errorMsg;
        Runnable r = new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), innerMsg);
            }
        };
        EventQueue.invokeLater(r);
    }

    public Class getEditorClass() {
        return HelpTopicEditor.class;
    }

    public synchronized MenuSpec getMenuSpecification() {
        if (this._menuSpec == null) {
            this._menuSpec = new MenuSpec(null, null, HelpArb.getIcon(44));
        }
        return this._menuSpec;
    }

    public boolean isDefault() {
        return true;
    }

    static String getExtensionID() {
        return AddinManager.getAddinManager().getExtensionIDForAddin(HelpSystemAddin.class);
    }

    static {
        START_PAGE_PROTOCOL = "startpage";
    }

    private static final class StartPageFileSystemHelper
    extends URLFileSystemHelper {
        private StartPageFileSystemHelper() {
        }

        public boolean exists(URL url) {
            return URLFileSystem.exists((URL)this.redirectToURL(url));
        }

        public long getLength(URL url) {
            return URLFileSystem.getLength((URL)this.redirectToURL(url));
        }

        public boolean isRegularFile(URL url) {
            return true;
        }

        public URL getParent(URL url) {
            return URLFileSystem.getParent((URL)this.redirectToURL(url));
        }

        private URL redirectToURL(URL url) {
            URL newURL = url;
            newURL = URLFactory.replaceProtocolPart((URL)newURL, (String)"file");
            newURL = URLFactory.replaceQueryPart((URL)newURL, null);
            return newURL;
        }

        public InputStream openInputStream(URL url) throws IOException {
            return URLFileSystem.openInputStream((URL)this.redirectToURL(url));
        }

        public OutputStream openOutputStream(URL url) throws IOException {
            return URLFileSystem.openOutputStream((URL)this.redirectToURL(url));
        }
    }

    private static final class StartPageConnection
    extends URLConnection {
        protected StartPageConnection(URL url) {
            super(url);
        }

        @Override
        public void connect() {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            URL url = super.getURL();
            url = URLFactory.replaceProtocolPart((URL)url, (String)"file");
            url = URLFactory.replaceQueryPart((URL)url, null);
            return URLFileSystem.openInputStream((URL)url);
        }
    }

    private static final class StartPageStreamHandler
    extends URLStreamHandler {
        private StartPageStreamHandler() {
        }

        @Override
        protected URLConnection openConnection(URL u) {
            return new StartPageConnection(u);
        }
    }

    private static final class StartPageStreamHandlerFactory
    implements URLStreamHandlerFactory {
        private StartPageStreamHandlerFactory() {
        }

        @Override
        public URLStreamHandler createURLStreamHandler(String protocol) {
            if (protocol.startsWith(START_PAGE_PROTOCOL)) {
                return new StartPageStreamHandler();
            }
            return null;
        }
    }
}

