/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.help.HelpArb;
import oracle.jdevimpl.help.HelpOptions;
import oracle.jdevimpl.help.JDevHelpSystemImpl;

public final class HelpOptionsPanel
extends DefaultTraversablePanel {
    private HelpOptions _options;
    private JLabel _spacer = new JLabel();
    private JCheckBox _showTOCCB = new JCheckBox();
    private JCheckBox _showFavoritesCB = new JCheckBox();
    private JCheckBox _showDynamicLinksCB = new JCheckBox();

    public HelpOptionsPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onEntry(TraversableContext tc) {
        HelpOptions options;
        this._options = options = HelpOptions.getInstance(tc.getPropertyStorage());
        this.load(this._options);
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        HelpOptions options = HelpOptions.getInstance(tc.getPropertyStorage());
        if (!(this._showTOCCB.isSelected() || this._showFavoritesCB.isSelected() || this._showDynamicLinksCB.isSelected())) {
            throw new TraversalException(HelpArb.getString(88));
        }
        this.commit(options);
    }

    private void jbInit() throws Exception {
        GridBagLayout layout = new GridBagLayout();
        ResourceUtils.resButton((AbstractButton)this._showTOCCB, (String)"TOC");
        ResourceUtils.resButton((AbstractButton)this._showFavoritesCB, (String)"Favorites");
        ResourceUtils.resButton((AbstractButton)this._showDynamicLinksCB, (String)"Dynamic Links");
        this.setLayout(layout);
        JPanel tabsPanel = new JPanel(new GridBagLayout());
        CompoundBorder tabsBorder = BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Show Tabs"), BorderFactory.createEmptyBorder(0, 8, 8, 8));
        tabsPanel.setBorder(tabsBorder);
        JDevHelpSystemImpl helpSys = (JDevHelpSystemImpl)HelpSystem.getHelpSystem();
        if (helpSys.isNavigatorSupported(0)) {
            tabsPanel.add((Component)this._showTOCCB, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        }
        if (helpSys.isNavigatorSupported(1)) {
            tabsPanel.add((Component)this._showFavoritesCB, new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        }
        if (helpSys.isNavigatorSupported(2)) {
            tabsPanel.add((Component)this._showDynamicLinksCB, new GridBagConstraints(0, 4, 3, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        }
        this.add(tabsPanel, new GridBagConstraints(0, 2, 3, 6, 1.0, 0.0, 18, 2, new Insets(20, 0, 20, 0), 0, 0));
        this.add(this._spacer, new GridBagConstraints(0, 7, 3, 1, 1.0, 1.0, 17, 3, new Insets(0, 0, 20, 0), 0, 0));
        this.setHelpID("f1_dochosted_html");
    }

    private void load(HelpOptions options) {
        this._showTOCCB.setSelected(options.getShowTOC());
        this._showFavoritesCB.setSelected(options.getShowFavorites());
        this._showDynamicLinksCB.setSelected(options.getShowDynamicLinks());
    }

    private void commit(HelpOptions options) {
        options.setShowTOC(this._showTOCCB.isSelected());
        options.setShowFavorites(this._showFavoritesCB.isSelected());
        options.setShowDynamicLinks(this._showDynamicLinksCB.isSelected());
    }
}

