/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.EventObject;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import oracle.bali.share.event.ListenerManager;
import oracle.bali.share.nls.StringUtils;
import oracle.help.common.Topic;
import oracle.help.library.Library;
import oracle.help.topicDisplay.TopicDisplayEvent;
import oracle.help.topicDisplay.TopicDisplayListener;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.customtab.CustomTab;
import oracle.ide.controls.customtab.DefaultCustomTabPage;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.GraphicsUtils;
import oracle.javatools.icons.OracleIcons;
import oracle.jdevimpl.help.CueCardSet;
import oracle.jdevimpl.help.HelpArb;
import oracle.jdevimpl.help.HelpContentPanel;
import oracle.jdevimpl.help.JDevHelpSystemImpl;

public class CueCardOverviewPanel
extends JPanel
implements Controller,
ContextMenuListener,
TreeWillExpandListener,
ListSelectionListener {
    private JTree _tree;
    private DefaultTreeModel _treeModel;
    private JScrollPane _scrollPane;
    private CueCardSet _cueCardSet;
    private ListenerManager _listeners;
    private ContextMenu _contextMenu;
    private JMenuItem _closeMenuItem;
    private JMenuItem _gotoMenuItem;
    private JMenuItem _showStepsItem;
    private JMenuItem _showRoadmapItem;
    private CustomTab _tab;
    private DefaultListModel _tabModel = new DefaultListModel();
    private DefaultCustomTabPage _stepsPage;
    private DefaultCustomTabPage _roadmapPage;
    private JPanel _topPanel;
    private HelpContentPanel _roadmapViewer;
    private boolean _usingHelpContentPanelContextMenu;
    private static final int CLOSE_PANEL_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdevimpl.help.CueCardOverviewPanel.CloseOverviewPanelCmd");
    private static final int GOTO_TOPIC_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdevimpl.help.CueCardOverviewPanel.GoToTopicCmd");
    private static final String MOUSE_EVENT = "mouseEvent";
    private static final int SHOW_STEPS_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdevimpl.help.CueCardOverviewPanel.ShowStepsCmd");
    private static final int SHOW_ROADMAP_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdevimpl.help.CueCardOverviewPanel.ShowRoadmapCmd");

    public CueCardOverviewPanel() {
        this._listeners = new ListenerManager();
        this.setLayout(new BorderLayout());
        this._tree = new JTree();
        this._scrollPane = new JScrollPane(this._tree);
        this._scrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.add((Component)this._scrollPane, "Center");
        this._tree.setCellRenderer(new CueCardTreeCellRenderer());
        CueCardMouseAdapter mouseAdapter = new CueCardMouseAdapter();
        this._tree.addMouseListener(mouseAdapter);
        this._tree.addTreeWillExpandListener(this);
        this._tree.getInputMap().put(KeyStroke.getKeyStroke("SPACE"), "pressed");
        this._tree.getActionMap().put("pressed", new PressAction());
        String label = HelpArb.getString(78);
        label = StringUtils.stripMnemonic((String)label);
        this._stepsPage = new DefaultCustomTabPage(OracleIcons.getIcon((String)"cuecard.png"), label, (Object)this._scrollPane);
        label = HelpArb.getString(79);
        label = StringUtils.stripMnemonic((String)label);
        this._roadmapPage = new DefaultCustomTabPage(HelpArb.getIcon(80), label, (Object)this._roadmapViewer);
        this._tabModel.addElement(this._stepsPage);
        this._tab = new CustomTab((ListModel)this._tabModel, 3);
        this._tab.addSelectionListener((ListSelectionListener)this);
        this._topPanel = new JPanel();
        this._topPanel.setLayout(new BorderLayout());
        this._topPanel.add((Component)this._tab, "West");
        this.add((Component)this._topPanel, "South");
    }

    public void setCueCardSet(CueCardSet cueCardSet) {
        JDevHelpSystemImpl helpSys;
        Topic topic;
        this._cueCardSet = cueCardSet;
        if (cueCardSet.getRoadmapId() == null) {
            if (this._tabModel.getSize() > 1) {
                this._tabModel.remove(1);
                this._tab.setSelectedPage(0);
            }
        } else if (this._tabModel.getSize() < 2) {
            this._tabModel.addElement(this._roadmapPage);
            this._tab.setSelectedPage(0);
        } else if (this._roadmapViewer != null && (topic = (helpSys = (JDevHelpSystemImpl)HelpSystem.getHelpSystem()).getTopicForString(this._cueCardSet.getRoadmapId())) != null) {
            this._roadmapViewer.displayTopic(topic);
        }
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(this._cueCardSet.getLabel());
        List dataList = this._cueCardSet.getStepList();
        this._treeModel = new DefaultTreeModel(rootNode);
        int listLen = dataList.size();
        for (int i = 0; i < listLen; ++i) {
            TreeNodeData nodeData = new TreeNodeData((Topic)dataList.get(i));
            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(nodeData);
            this._treeModel.insertNodeInto(childNode, rootNode, rootNode.getChildCount());
        }
        this._tree.setModel(this._treeModel);
        this._tree.setSelectionInterval(1, 1);
    }

    public void selectMatchingURL(URL url) {
        List list = this._cueCardSet.getStepList();
        int listLen = list.size();
        for (int i = 0; i < listLen; ++i) {
            Topic topic = (Topic)list.get(i);
            try {
                URL topicURL = topic.getTarget().getURL();
                if (!url.equals(topicURL)) continue;
                this._tree.setSelectionInterval(i + 1, i + 1);
                break;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void dispose() {
        this._listeners = null;
    }

    public void addTopicDisplayListener(TopicDisplayListener listener) {
        if (listener != null) {
            this._listeners.addListener((EventListener)listener);
        }
    }

    public void removeTopicDisplayListener(TopicDisplayListener listener) {
        if (listener != null) {
            this._listeners.removeListener((EventListener)listener);
        }
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == CLOSE_PANEL_CMD_ID) {
            return true;
        }
        if (cmdId == GOTO_TOPIC_CMD_ID) {
            return true;
        }
        if (cmdId == SHOW_STEPS_CMD_ID) {
            this._showSteps();
            return true;
        }
        if (cmdId == SHOW_ROADMAP_CMD_ID) {
            this._showRoadmap();
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == CLOSE_PANEL_CMD_ID) {
            action.setEnabled(true);
            return true;
        }
        if (cmdId == GOTO_TOPIC_CMD_ID) {
            action.setEnabled(true);
            action.putValue(MOUSE_EVENT, (Object)context.getEvent());
            return true;
        }
        if (cmdId == SHOW_STEPS_CMD_ID) {
            if (this._roadmapViewer != null && this._roadmapViewer.getGUI().getParent() != null) {
                action.setEnabled(true);
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == SHOW_ROADMAP_CMD_ID) {
            if (this._roadmapViewer != null && this._roadmapViewer.getGUI().getParent() != null) {
                action.setEnabled(false);
            } else if (this._roadmapViewer == null) {
                JDevHelpSystemImpl helpSys = (JDevHelpSystemImpl)HelpSystem.getHelpSystem();
                Topic topic = helpSys.getTopicForString(this._cueCardSet.getRoadmapId());
                if (topic == null) {
                    action.setEnabled(false);
                } else {
                    action.setEnabled(true);
                }
            }
            return true;
        }
        return false;
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public void menuWillShow(ContextMenu popup) {
        popup.add((Component)this._gotoMenuItem);
        popup.add((Component)this._showStepsItem);
        popup.add((Component)this._showRoadmapItem);
        popup.addSeparator();
        popup.add((Component)this._closeMenuItem);
    }

    public void menuWillHide(ContextMenu popup) {
        if (this._usingHelpContentPanelContextMenu) {
            popup.removeContextMenuListener((ContextMenuListener)this);
        }
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent event) {
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
        throw new ExpandVetoException(event);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getFirstIndex() == -1) {
            return;
        }
        if (e.getFirstIndex() == 0) {
            this._showSteps();
        } else {
            this._showRoadmap();
        }
    }

    private void _fireTopicDisplayEvent(TopicDisplayEvent event) {
        Enumeration listenEnum = this._listeners.getListeners();
        if (listenEnum != null) {
            while (listenEnum.hasMoreElements()) {
                TopicDisplayListener l = (TopicDisplayListener)listenEnum.nextElement();
                l.topicDisplayChanged(event);
            }
        }
    }

    public ContextMenu getContextMenu() {
        ContextMenu currentContextMenu = null;
        if (this._contextMenu == null) {
            this._contextMenu = new ContextMenu();
            String label = HelpArb.getString(93);
            IdeAction action = IdeAction.get((int)CLOSE_PANEL_CMD_ID, null, (String)StringUtils.stripMnemonic((String)label), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)label)), null, null, null, (boolean)true);
            action.addController((Controller)this);
            this._closeMenuItem = this._contextMenu.createMenuItem((ToggleAction)action);
            label = HelpArb.getString(94);
            action = IdeAction.get((int)GOTO_TOPIC_CMD_ID, null, (String)StringUtils.stripMnemonic((String)label), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)label)), null, null, null, (boolean)true);
            action.addController((Controller)this);
            this._gotoMenuItem = this._contextMenu.createMenuItem((ToggleAction)action);
            label = HelpArb.getString(78);
            action = IdeAction.get((int)SHOW_STEPS_CMD_ID, null, (String)StringUtils.stripMnemonic((String)label), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)label)), null, null, null, (boolean)true);
            action.addController((Controller)this);
            this._showStepsItem = this._contextMenu.createMenuItem((ToggleAction)action);
            label = HelpArb.getString(79);
            action = IdeAction.get((int)SHOW_ROADMAP_CMD_ID, null, (String)StringUtils.stripMnemonic((String)label), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)label)), null, null, null, (boolean)true);
            action.addController((Controller)this);
            this._showRoadmapItem = this._contextMenu.createMenuItem((ToggleAction)action);
            this._contextMenu.addContextMenuListener((ContextMenuListener)this);
        }
        if (this._roadmapViewer != null) {
            currentContextMenu = this._roadmapViewer.getContextMenu();
            this._usingHelpContentPanelContextMenu = true;
            currentContextMenu.addContextMenuListener((ContextMenuListener)this);
        } else {
            this._usingHelpContentPanelContextMenu = false;
            currentContextMenu = this._contextMenu;
        }
        return currentContextMenu;
    }

    private void _fireEventForTopic(Topic topic) {
        if (topic != null) {
            try {
                URL url = topic.getTarget().getURL();
                TopicDisplayEvent displayEvent = new TopicDisplayEvent((Object)this._tree, 2000, 0, url, null);
                this._fireTopicDisplayEvent(displayEvent);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private Topic _getTopic(MouseEvent e) {
        Topic topic = null;
        JTree tree = (JTree)e.getComponent();
        TreePath treepath = tree.getClosestPathForLocation(e.getX(), e.getY());
        Object pathObj = treepath.getLastPathComponent();
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)pathObj;
        Object userObj = treeNode.getUserObject();
        if (userObj instanceof TreeNodeData) {
            TreeNodeData data = (TreeNodeData)userObj;
            topic = data.getTopic();
        }
        return topic;
    }

    private void _showRoadmap() {
        JDevHelpSystemImpl helpSys;
        Topic topic;
        if (this._roadmapViewer == null && (topic = (helpSys = (JDevHelpSystemImpl)HelpSystem.getHelpSystem()).getTopicForString(this._cueCardSet.getRoadmapId())) != null) {
            Library library = helpSys.getLibrary();
            this._roadmapViewer = new HelpContentPanel(library, HelpContentPanel.ViewerType.ROADMAP_VIEWER);
            this._roadmapViewer.displayTopic(topic);
        }
        if (this._roadmapViewer != null && this._roadmapViewer.getGUI().getParent() == null) {
            this.remove(this._scrollPane);
            this.add(this._roadmapViewer.getGUI(), "Center");
            this.repaint();
            GraphicsUtils.focusComponentOrChild((Component)this, (boolean)true);
        }
        if (this._tab.getSelectedPage() != 1) {
            this._tab.setSelectedPage(1);
        }
    }

    private void _showSteps() {
        if (this._roadmapViewer != null && this._roadmapViewer.getGUI().getParent() != null) {
            this.remove(this._roadmapViewer.getGUI());
            this._roadmapViewer = null;
            this.add((Component)this._scrollPane, "Center");
            this.repaint();
            GraphicsUtils.focusComponentOrChild((Component)this, (boolean)true);
        }
        if (this._tab.getSelectedPage() != 0) {
            this._tab.setSelectedPage(0);
        }
    }

    private class PressAction
    extends AbstractAction {
        private PressAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTree tree = (JTree)e.getSource();
            TreePath treePath = tree.getSelectionPath();
            DefaultMutableTreeNode dtm = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Object userObj = dtm.getUserObject();
            if (userObj instanceof TreeNodeData) {
                TreeNodeData data = (TreeNodeData)userObj;
                Topic topic = data.getTopic();
                CueCardOverviewPanel.this._fireEventForTopic(topic);
            }
        }
    }

    private class CueCardMouseAdapter
    extends MouseAdapter {
        private CueCardMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this._showContextMenu(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this._showContextMenu(e);
            }
        }

        private void _showContextMenu(MouseEvent e) {
            Context context = Context.newIdeContext();
            context.setEvent((EventObject)e);
            CueCardOverviewPanel.this.getContextMenu().show(context);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 1 && e.getButton() == 1) {
                Topic topic = CueCardOverviewPanel.this._getTopic(e);
                CueCardOverviewPanel.this._fireEventForTopic(topic);
            }
        }
    }

    private static class TreeNodeData {
        private Topic _topic;

        public TreeNodeData(Topic topic) {
            this._topic = topic;
        }

        public Topic getTopic() {
            return this._topic;
        }

        public String toString() {
            return this._topic.getLabel();
        }
    }

    private class CueCardTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private CueCardTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value != null) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                Object userobj = node.getUserObject();
                if (userobj instanceof TreeNodeData) {
                    TreeNodeData data = (TreeNodeData)userobj;
                    this.setToolTipText(data.toString());
                    this.setText(data.toString());
                    this.setIcon(null);
                } else if (userobj instanceof String) {
                    this.setIcon(OracleIcons.getIcon((String)"cuecard.png"));
                    this.setToolTipText((String)userobj);
                    this.setText((String)userobj);
                }
            }
            return this;
        }
    }
}

