/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.thirdparty.jdbc;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.classloader.util.AnnotatedClassNotFoundException;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.navigator.ConnectionInfo;
import oracle.dbtools.raptor.navigator.ConnectionRecognizer;
import oracle.dbtools.thirdparty.jdbc.JDBCBasicPanel;
import oracle.javatools.util.Version;

public class JdbcConnectionRecognizer
implements ConnectionRecognizer {
    public static String getURL(Connection connection) {
        String string = null;
        try {
            Method method;
            Class<Connection> clazz = Class.forName("sun.jdbc.odbc.JdbcOdbcConnection").asSubclass(Connection.class);
            if (clazz.isAssignableFrom(connection.getClass()) && (method = clazz.getDeclaredMethod("getURL", new Class[0])) != null) {
                string = (String)method.invoke((Object)connection, new Object[0]);
            }
        }
        catch (AnnotatedClassNotFoundException annotatedClassNotFoundException) {
        }
        catch (Exception exception) {
            Logger.getLogger(JDBCBasicPanel.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return string;
    }

    public ConnectionInfo createConnectionInfo(String string, Connection connection) {
        ConnectionInfo connectionInfo = null;
        DatabaseMetaData databaseMetaData = null;
        try {
            databaseMetaData = connection.getMetaData();
            Version version = DBUtil.getDbVersion((Connection)connection);
            String string2 = JdbcConnectionRecognizer.getURL(connection);
            if (string2 != null && string2.indexOf("Microsoft Access") == -1) {
                connectionInfo = new ConnectionInfo(string, connection, version, "ODBCBridge", null, databaseMetaData.getUserName());
            }
        }
        catch (SQLException sQLException) {
            Logger.getLogger(JDBCBasicPanel.class.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        return connectionInfo;
    }
}

