/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleDatumWithConnection;
import oracle.sql.Datum;
import oracle.sql.TypeDescriptor;

public abstract class DatumWithConnection
extends Datum
implements OracleDatumWithConnection {
    private oracle.jdbc.internal.OracleConnection physicalConnection = null;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Jun_28_00:48:08_PDT_2012";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    oracle.jdbc.internal.OracleConnection getPhysicalConnection() {
        if (this.physicalConnection == null) {
            try {
                this.physicalConnection = (oracle.jdbc.internal.OracleConnection)new OracleDriver().defaultConnection();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this.physicalConnection;
    }

    public DatumWithConnection(byte[] byArray) throws SQLException {
        super(byArray);
    }

    public DatumWithConnection() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertNotNull(Connection connection) throws SQLException {
        if (connection == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DatumWithConnection.logger().log(Level.SEVERE, "         Throwing SQLException: 68Connection is null");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(null, 68, "Connection is null");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertNotNull(TypeDescriptor typeDescriptor) throws SQLException {
        if (typeDescriptor == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DatumWithConnection.logger().log(Level.SEVERE, "         Throwing SQLException: 61");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(null, 61);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setPhysicalConnectionOf(Connection connection) {
        this.physicalConnection = ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getJavaSqlConnection() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        DatumWithConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            oracle.jdbc.OracleConnection oracleConnection = this.getPhysicalConnection().getWrapper();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        DatumWithConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + oracleConnection);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            oracle.jdbc.OracleConnection oracleConnection2 = oracleConnection;
            return oracleConnection2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DatumWithConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public oracle.jdbc.OracleConnection getOracleConnection() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        DatumWithConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            oracle.jdbc.OracleConnection oracleConnection = this.getPhysicalConnection().getWrapper();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        DatumWithConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + oracleConnection);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            oracle.jdbc.OracleConnection oracleConnection2 = oracleConnection;
            return oracleConnection2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DatumWithConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public oracle.jdbc.internal.OracleConnection getInternalConnection() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        DatumWithConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            oracle.jdbc.internal.OracleConnection oracleConnection = this.getPhysicalConnection();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        DatumWithConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + oracleConnection);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            oracle.jdbc.internal.OracleConnection oracleConnection2 = oracleConnection;
            return oracleConnection2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DatumWithConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OracleConnection getConnection() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        DatumWithConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleConnection oracleConnection = null;
            try {
                oracleConnection = (OracleConnection)((OracleConnection)this.physicalConnection).getWrapper();
            }
            catch (ClassCastException classCastException) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        DatumWithConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 103);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 103);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        DatumWithConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + oracleConnection);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleConnection oracleConnection2 = oracleConnection;
            return oracleConnection2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DatumWithConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling() {
        return this.physicalConnection;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.DatumWithConnection"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

