/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleData;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.ANYDATA;
import oracle.sql.Datum;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;

class AnyDataFactory
implements ORADataFactory,
OracleDataFactory {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Jun_28_00:48:08_PDT_2012";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    AnyDataFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ORAData create(Datum datum, int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        AnyDataFactory.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(datum) + ", " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (datum == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            AnyDataFactory.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                ORAData oRAData = null;
                return oRAData;
            }
            if (datum instanceof OPAQUE) {
                ANYDATA aNYDATA = new ANYDATA((OPAQUE)datum);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            AnyDataFactory.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + aNYDATA);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                ANYDATA aNYDATA2 = aNYDATA;
                return aNYDATA2;
            }
            String string = "expected oracle.sql.OPAQUE got: " + datum.getClass().getName();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AnyDataFactory.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1 + string);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AnyDataFactory.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OracleData create(Object object, int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        AnyDataFactory.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(object) + ", " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (object == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            AnyDataFactory.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                OracleData oracleData = null;
                return oracleData;
            }
            if (object instanceof OPAQUE) {
                ANYDATA aNYDATA = new ANYDATA((OPAQUE)object);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            AnyDataFactory.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + aNYDATA);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                ANYDATA aNYDATA2 = aNYDATA;
                return aNYDATA2;
            }
            String string = "expected oracle.sql.OPAQUE got: " + object.getClass().getName();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AnyDataFactory.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1 + string);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AnyDataFactory.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.AnyDataFactory"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

