/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.io.IOException;
import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.oracore.Util;
import oracle.jdbc.xa.client.OracleXAConnection;
import oracle.jdbc.xa.client.OracleXAResource;

public class OracleXAHeteroResource
extends OracleXAResource {
    private int rmid;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Jun_28_00:48:08_PDT_2012";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleXAHeteroResource(Connection connection, OracleXAConnection oracleXAConnection) throws XAException {
        block19: {
            this.rmid = -1;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleXAHeteroResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(connection) + ", " + OracleLog.argument(oracleXAConnection));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.connection = connection;
                this.xaconnection = oracleXAConnection;
                if (this.connection != null) break block19;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAHeteroResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -7);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new XAException(-7);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAHeteroResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(Xid xid, int n2) throws XAException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleXAHeteroResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(xid) + ", " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (xid == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAHeteroResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -5);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new XAException(-5);
            }
            int n3 = n2 & 0xFF00;
            if (((n2 &= 0xFFFF00FF) & 0x8200002) != n2) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAHeteroResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -5);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new XAException(-5);
            }
            if ((n3 & 0xFF00) != 0 && n3 != 256 && n3 != 512 && n3 != 1024) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAHeteroResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -5);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new XAException(-5);
            }
            if ((n3 & 0xFF00) != 0 && (n2 & 0x8200000) != 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAHeteroResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -5);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new XAException(-5);
            }
            try {
                this.saveAndAlterAutoCommitModeForGlobalTransaction();
                int n4 = xid.getFormatId();
                byte[] byArray = xid.getGlobalTransactionId();
                byte[] byArray2 = xid.getBranchQualifier();
                int n5 = this.t2cDoXaStart(n4, byArray, byArray2, this.rmid, n2 |= n3, 0);
                this.checkStatus(n5);
                this.enterGlobalTxnMode();
            }
            catch (XAException xAException) {
                this.restoreAutoCommitModeForGlobalTransaction();
                throw xAException;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAHeteroResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end(Xid xid, int n2) throws XAException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleXAHeteroResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(xid) + ", " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            try {
                if (xid == null) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXAHeteroResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -5);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw new XAException(-5);
                }
                int n3 = 638582786;
                if ((n2 & n3) != n2) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXAHeteroResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -5);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw new XAException(-5);
                }
                int n4 = xid.getFormatId();
                byte[] byArray = xid.getGlobalTransactionId();
                byte[] byArray2 = xid.getBranchQualifier();
                this.exitGlobalTxnMode();
                int n5 = this.t2cDoXaEnd(n4, byArray, byArray2, this.rmid, n2, 0);
                this.checkStatus(n5);
            }
            finally {
                this.restoreAutoCommitModeForGlobalTransaction();
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAHeteroResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(Xid xid, boolean bl) throws XAException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleXAHeteroResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(xid) + ", " + OracleLog.argument(bl));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (xid == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAHeteroResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -5);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new XAException(-5);
            }
            int n2 = bl ? 0x40000000 : 0;
            int n3 = xid.getFormatId();
            byte[] byArray = xid.getGlobalTransactionId();
            byte[] byArray2 = xid.getBranchQualifier();
            int n4 = this.t2cDoXaCommit(n3, byArray, byArray2, this.rmid, n2, 0);
            this.checkStatus(n4);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAHeteroResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int prepare(Xid xid) throws XAException {
        try {
            byte[] byArray;
            byte[] byArray2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleXAHeteroResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(xid));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (xid == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAHeteroResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -5);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new XAException(-5);
            }
            int n2 = xid.getFormatId();
            int n3 = this.t2cDoXaPrepare(n2, byArray2 = xid.getGlobalTransactionId(), byArray = xid.getBranchQualifier(), this.rmid, 0, 0);
            if (n3 != 0 && n3 != 3) {
                this.checkStatus(n3);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleXAHeteroResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n3);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n4 = n3;
            return n4;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAHeteroResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forget(Xid xid) throws XAException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleXAHeteroResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(xid));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (xid == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAHeteroResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -5);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new XAException(-5);
            }
            int n2 = xid.getFormatId();
            byte[] byArray = xid.getGlobalTransactionId();
            byte[] byArray2 = xid.getBranchQualifier();
            int n3 = this.t2cDoXaForget(n2, byArray, byArray2, this.rmid, 0, 0);
            this.checkStatus(n3);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAHeteroResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Xid xid) throws XAException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleXAHeteroResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(xid));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (xid == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAHeteroResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -5);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new XAException(-5);
            }
            int n2 = xid.getFormatId();
            byte[] byArray = xid.getGlobalTransactionId();
            byte[] byArray2 = xid.getBranchQualifier();
            int n3 = this.t2cDoXaRollback(n2, byArray, byArray2, this.rmid, 0, 0);
            this.checkStatus(n3);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAHeteroResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private native int t2cDoXaStart(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int t2cDoXaEnd(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int t2cDoXaCommit(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int t2cDoXaPrepare(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int t2cDoXaForget(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int t2cDoXaRollback(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    synchronized void setRmid(int n2) {
        this.rmid = n2;
    }

    synchronized int getRmid() {
        return this.rmid;
    }

    private static byte[] getSerializedBytes(Xid xid) {
        try {
            return Util.serializeObject(xid);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkStatus(int n2) throws XAException {
        if (n2 != 0) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAHeteroResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + n2);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw new XAException(n2);
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.xa.client");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.xa.client.OracleXAHeteroResource"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

