/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;

public class OracleMultiPhaseArgs {
    int action;
    int nsites;
    Vector dbLinks;
    Vector xids;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Jun_28_00:48:08_PDT_2012";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleMultiPhaseArgs() {
        block13: {
            this.action = 0;
            this.nsites = 0;
            this.dbLinks = null;
            this.xids = null;
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block13;
                try {
                    if (OracleLog.enter()) {
                        OracleMultiPhaseArgs.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleMultiPhaseArgs.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleMultiPhaseArgs(int n2, int n3, Vector vector, Vector vector2) {
        this.action = 0;
        this.nsites = 0;
        this.dbLinks = null;
        this.xids = null;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleMultiPhaseArgs.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(n3) + ", " + OracleLog.argument(vector) + ", " + OracleLog.argument(vector2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (n3 <= 1) {
                this.action = 0;
                this.nsites = 0;
                this.dbLinks = null;
                this.xids = null;
            } else if (!vector.isEmpty() && !vector2.isEmpty() && vector2.size() == n3) {
                if (vector.size() != 3 * n3) {
                } else {
                    this.action = n2;
                    this.nsites = n3;
                    this.xids = vector;
                    this.dbLinks = vector2;
                }
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleMultiPhaseArgs(byte[] byArray) {
        this.action = 0;
        this.nsites = 0;
        this.dbLinks = null;
        this.xids = null;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleMultiPhaseArgs.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(byArray));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            this.xids = new Vector();
            this.dbLinks = new Vector();
            try {
                this.action = dataInputStream.readInt();
                this.nsites = dataInputStream.readInt();
                int n2 = dataInputStream.readInt();
                int n3 = dataInputStream.readInt();
                byte[] byArray2 = new byte[n3];
                int n4 = dataInputStream.read(byArray2, 0, n3);
                for (int i2 = 0; i2 < this.nsites; ++i2) {
                    int n5 = dataInputStream.readInt();
                    byte[] byArray3 = new byte[n5];
                    int n6 = dataInputStream.read(byArray3, 0, n5);
                    this.xids.addElement(n2);
                    this.xids.addElement(byArray2);
                    this.xids.addElement(byArray3);
                    String string = dataInputStream.readUTF();
                    this.dbLinks.addElement(string);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toByteArray() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleMultiPhaseArgs.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = this.toByteArrayOS().toByteArray();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleMultiPhaseArgs.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + byArray);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteArrayOutputStream toByteArrayOS() {
        byte[] byArray = null;
        int n2 = 0;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleMultiPhaseArgs.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            try {
                dataOutputStream.writeInt(this.action);
                dataOutputStream.writeInt(this.nsites);
                for (int i2 = 0; i2 < this.nsites; ++i2) {
                    String string = (String)this.dbLinks.elementAt(i2);
                    int n3 = (Integer)this.xids.elementAt(i2 * 3);
                    byte[] byArray2 = (byte[])this.xids.elementAt(i2 * 3 + 1);
                    byte[] byArray3 = (byte[])this.xids.elementAt(i2 * 3 + 2);
                    if (i2 == 0) {
                        n2 = n3;
                        byArray = byArray2;
                        dataOutputStream.writeInt(n3);
                        dataOutputStream.writeInt(byArray2.length);
                        dataOutputStream.write(byArray2, 0, byArray2.length);
                    }
                    dataOutputStream.writeInt(byArray3.length);
                    dataOutputStream.write(byArray3, 0, byArray3.length);
                    dataOutputStream.writeUTF(string);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleMultiPhaseArgs.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + byteArrayOutputStream);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
            return byteArrayOutputStream2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAction() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleMultiPhaseArgs.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleMultiPhaseArgs.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.action);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.action;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getnsite() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleMultiPhaseArgs.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleMultiPhaseArgs.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.nsites);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.nsites;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getdbLinks() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleMultiPhaseArgs.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleMultiPhaseArgs.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.dbLinks);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Vector vector = this.dbLinks;
            return vector;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getXids() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleMultiPhaseArgs.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleMultiPhaseArgs.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.xids);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Vector vector = this.xids;
            return vector;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    public void printMPArgs() {
        for (int i2 = 0; i2 < this.nsites; ++i2) {
            String string = (String)this.dbLinks.elementAt(i2);
            int n2 = (Integer)this.xids.elementAt(i2 * 3);
            byte[] byArray = (byte[])this.xids.elementAt(i2 * 3 + 1);
            byte[] byArray2 = (byte[])this.xids.elementAt(i2 * 3 + 2);
            this.printByteArray(byArray);
            this.printByteArray(byArray2);
        }
    }

    private void printByteArray(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            stringBuffer.append(byArray[i2] + " ");
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.xa");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.xa.OracleMultiPhaseArgs"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

