/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringBufferInputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetInternal;
import javax.sql.RowSetMetaData;
import javax.sql.RowSetReader;
import javax.sql.RowSetWriter;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.RowSetWarning;
import javax.sql.rowset.spi.SyncFactory;
import javax.sql.rowset.spi.SyncFactoryException;
import javax.sql.rowset.spi.SyncProvider;
import javax.sql.rowset.spi.SyncProviderException;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleSavepoint;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.rowset.OracleCachedRowSetReader;
import oracle.jdbc.rowset.OracleCachedRowSetWriter;
import oracle.jdbc.rowset.OracleRow;
import oracle.jdbc.rowset.OracleRowSet;
import oracle.jdbc.rowset.OracleRowSetMetaData;
import oracle.jdbc.rowset.OracleSerialBlob;
import oracle.jdbc.rowset.OracleSerialClob;
import oracle.jdbc.rowset.OracleSqlForRowSet;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.ROWID;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

public class OracleCachedRowSet
extends OracleRowSet
implements RowSet,
RowSetInternal,
Serializable,
Cloneable,
CachedRowSet {
    static final long serialVersionUID = -2066958142885801470L;
    private SQLWarning sqlWarning;
    private RowSetWarning rowsetWarning;
    protected int presentRow;
    private int currentPage;
    private boolean isPopulateDone;
    private boolean previousColumnWasNull;
    private OracleRow insertRow;
    private int insertRowPosition;
    private boolean insertRowFlag;
    private int updateRowPosition;
    private boolean updateRowFlag;
    protected ResultSetMetaData rowsetMetaData;
    private transient ResultSet resultSet;
    private transient Connection connection;
    private transient boolean isConnectionStayingOpenForTxnControl = false;
    private transient OracleSqlForRowSet osql = null;
    protected Vector rows;
    private Vector param;
    private String[] metaData;
    protected int colCount;
    protected int rowCount;
    private RowSetReader reader;
    private RowSetWriter writer;
    private int[] keyColumns;
    private int pageSize;
    private SyncProvider syncProvider;
    private static final String DEFAULT_SYNCPROVIDER = "com.sun.rowset.providers.RIOptimisticProvider";
    private String tableName;
    private boolean executeCalled = false;
    private boolean driverManagerInitialized = false;
    private static final int MAX_CHAR_BUFFER_SIZE = 1024;
    private static final int MAX_BYTE_BUFFER_SIZE = 1024;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Jun_28_00:48:08_PDT_2012";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleCachedRowSet() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.insertRowFlag = false;
            this.updateRowFlag = false;
            this.presentRow = 0;
            this.previousColumnWasNull = false;
            this.param = new Vector();
            this.rows = new Vector();
            this.sqlWarning = new SQLWarning();
            try {
                this.syncProvider = SyncFactory.getInstance(DEFAULT_SYNCPROVIDER);
            }
            catch (SyncFactoryException syncFactoryException) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 304);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 304);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setReader(new OracleCachedRowSetReader());
            this.setWriter(new OracleCachedRowSetWriter());
            this.currentPage = 0;
            this.pageSize = 0;
            this.isPopulateDone = false;
            this.keyColumns = null;
            this.tableName = null;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Connection connection = this.getConnectionInternal();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + connection);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Connection connection2 = connection;
            return connection2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Connection getConnectionInternal() throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            String string = this.getUsername();
            String string2 = this.getPassword();
            if (this.getDataSourceName() != null) {
                try {
                    Object object;
                    InitialContext initialContext = null;
                    try {
                        object = System.getProperties();
                        initialContext = new InitialContext((Hashtable<?, ?>)object);
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                    if (initialContext == null) {
                        initialContext = new InitialContext();
                    }
                    object = (DataSource)initialContext.lookup(this.getDataSourceName());
                    if (this.username == null || string2 == null) {
                        this.connection = object.getConnection();
                    }
                    this.connection = object.getConnection(this.username, string2);
                }
                catch (NamingException namingException) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 300 + namingException.getMessage());
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 300, namingException.getMessage());
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
            } else if (this.getUrl() != null) {
                String string3;
                if (!this.driverManagerInitialized) {
                    DriverManager.registerDriver(new OracleDriver());
                    this.driverManagerInitialized = true;
                }
                if ((string3 = this.getUrl()).equals("") || string.equals("") || string2.equals("")) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 301);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 301);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.connection = DriverManager.getConnection(string3, string, string2);
            } else {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 301);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 301);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statement getStatement() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.resultSet == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 305);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 305);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Statement statement = this.resultSet.getStatement();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + statement);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Statement statement2 = statement;
            return statement2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowSetReader getReader() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.reader);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            RowSetReader rowSetReader = this.reader;
            return rowSetReader;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowSetWriter getWriter() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.writer);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            RowSetWriter rowSetWriter = this.writer;
            return rowSetWriter;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void setFetchDirection(int var1_1) throws SQLException {
        try {
            if (OracleCachedRowSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(var1_1));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowsetType == 1005) {
                if (OracleCachedRowSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 306);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var2_3 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 306);
                var2_3.fillInStackTrace();
                throw var2_3;
            }
            switch (var1_1) {
                case 1000: 
                case 1002: {
                    this.presentRow = 0;
                    break;
                }
                case 1001: {
                    if (this.rowsetType != 1003) ** GOTO lbl41
                    if (OracleCachedRowSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 307);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var2_4 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 307);
                    var2_4.fillInStackTrace();
                    throw var2_4;
lbl41:
                    // 1 sources

                    this.presentRow = this.rowCount + 1;
                    break;
                }
                default: {
                    if (OracleCachedRowSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 308);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var2_5 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 308);
                    var2_5.fillInStackTrace();
                    throw var2_5;
                }
            }
            super.setFetchDirection(var1_1);
        }
        finally {
            if (OracleCachedRowSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCommand(String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            super.setCommand(string);
            this.osql = string == null || string.equals("") ? null : new OracleSqlForRowSet(string);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReader(RowSetReader rowSetReader) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(rowSetReader));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.reader = rowSetReader;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWriter(RowSetWriter rowSetWriter) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(rowSetWriter));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.writer = rowSetWriter;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int getColumnIndex(String string) throws SQLException {
        int n2;
        if (string == null || string.equals("")) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6 + string);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        string = string.toUpperCase();
        for (n2 = 0; n2 < this.metaData.length && !string.equals(this.metaData[n2]); ++n2) {
        }
        if (n2 >= this.metaData.length) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6 + string);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return n2 + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkColumnIndex(int n2) throws SQLException {
        if (this.readOnly) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 309);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 309);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (n2 < 1 || n2 > this.colCount) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3 + "" + n2);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "" + n2);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isUpdated(int n2) throws SQLException {
        if (n2 < 1 || n2 > this.colCount) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3 + "" + n2);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "" + n2);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.getCurrentRow().isColumnChanged(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkParamIndex(int n2) throws SQLException {
        if (n2 < 1) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 310 + "" + n2);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 310, "" + n2);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    private final void populateInit(ResultSet resultSet) throws SQLException {
        this.resultSet = resultSet;
        Statement statement = resultSet.getStatement();
        this.maxFieldSize = statement.getMaxFieldSize();
        this.fetchSize = statement.getFetchSize();
        this.queryTimeout = statement.getQueryTimeout();
        this.connection = statement.getConnection();
        this.transactionIsolation = this.connection.getTransactionIsolation();
        this.typeMap = this.connection.getTypeMap();
        DatabaseMetaData databaseMetaData = this.connection.getMetaData();
        this.url = databaseMetaData.getURL();
        this.username = databaseMetaData.getUserName();
        this.presentRow = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized InputStream getStream(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null) {
            return null;
        }
        if (object instanceof InputStream) {
            return (InputStream)object;
        }
        if (object instanceof String) {
            return new ByteArrayInputStream(((String)object).getBytes());
        }
        if (object instanceof byte[]) {
            return new ByteArrayInputStream((byte[])object);
        }
        if (object instanceof OracleSerialClob) {
            return ((OracleSerialClob)object).getAsciiStream();
        }
        if (object instanceof OracleSerialBlob) {
            return ((OracleSerialBlob)object).getBinaryStream();
        }
        if (object instanceof Reader) {
            BufferedReader bufferedReader = null;
            PipedOutputStream pipedOutputStream = null;
            try {
                bufferedReader = new BufferedReader((Reader)object);
                int n3 = 0;
                PipedInputStream pipedInputStream = new PipedInputStream();
                pipedOutputStream = new PipedOutputStream(pipedInputStream);
                while ((n3 = ((Reader)bufferedReader).read()) != -1) {
                    pipedOutputStream.write(n3);
                }
                PipedInputStream pipedInputStream2 = pipedInputStream;
                return pipedInputStream2;
            }
            catch (IOException iOException) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 311 + iOException.getMessage());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 311, iOException.getMessage());
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        ((Reader)bufferedReader).close();
                    }
                }
                catch (IOException iOException) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 311 + iOException.getMessage());
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 311, iOException.getMessage());
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                try {
                    if (pipedOutputStream != null) {
                        pipedOutputStream.close();
                    }
                }
                catch (IOException iOException) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 311 + iOException.getMessage());
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 311, iOException.getMessage());
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
            }
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 312);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 312);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    private final Calendar getSessionCalendar(Connection connection) {
        Calendar calendar;
        String string = ((OracleConnection)connection).getSessionTimeZone();
        if (string == null) {
            calendar = Calendar.getInstance();
        } else {
            TimeZone timeZone = TimeZone.getDefault();
            timeZone.setID(string);
            calendar = Calendar.getInstance(timeZone);
        }
        return calendar;
    }

    private boolean isStreamType(int n2) {
        return n2 == 2004 || n2 == 2005 || n2 == -4 || n2 == -1;
    }

    @Override
    protected synchronized void notifyCursorMoved() {
        if (this.insertRowFlag) {
            this.insertRowFlag = false;
            this.insertRow.setRowUpdated(false);
            this.sqlWarning.setNextWarning(new SQLWarning("Cancelling insertion, due to cursor movement."));
        } else if (this.updateRowFlag) {
            try {
                this.updateRowFlag = false;
                int n2 = this.presentRow;
                this.presentRow = this.updateRowPosition;
                this.getCurrentRow().setRowUpdated(false);
                this.presentRow = n2;
                this.sqlWarning.setNextWarning(new SQLWarning("Cancelling all updates, due to cursor movement."));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        super.notifyCursorMoved();
    }

    protected void checkAndFilterObject(int n2, Object object) throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OracleRow getCurrentRow() throws SQLException {
        int n2 = this.presentRow - 1;
        if (this.presentRow < 1 || this.presentRow > this.rowCount) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 313);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 313);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return (OracleRow)this.rows.elementAt(this.presentRow - 1);
    }

    boolean isExecuteCalled() {
        return this.executeCalled;
    }

    int getCurrentPage() {
        return this.currentPage;
    }

    boolean isConnectionStayingOpen() {
        return this.isConnectionStayingOpenForTxnControl;
    }

    void setOriginal() throws SQLException {
        int n2 = 1;
        do {
            boolean bl;
            if (bl = this.setOriginalRowInternal(n2)) continue;
            ++n2;
        } while (n2 <= this.rowCount);
        this.notifyRowSetChanged();
        this.presentRow = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setOriginalRowInternal(int n2) throws SQLException {
        if (n2 < 1 || n2 > this.rowCount) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 313);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 313);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        boolean bl = false;
        OracleRow oracleRow = (OracleRow)this.rows.elementAt(n2 - 1);
        if (oracleRow.isRowDeleted()) {
            this.rows.remove(n2 - 1);
            --this.rowCount;
            bl = true;
        } else {
            if (oracleRow.isRowInserted()) {
                oracleRow.setInsertedFlag(false);
            }
            if (oracleRow.isRowUpdated()) {
                oracleRow.makeUpdatesOriginal();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean next() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowCount < 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = false;
                return bl;
            }
            if (this.fetchDirection == 1000 || this.fetchDirection == 1002) {
                if (this.presentRow + 1 <= this.rowCount) {
                    ++this.presentRow;
                    if (!this.showDeleted && this.getCurrentRow().isRowDeleted()) {
                        boolean bl = this.next();
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                if (OracleLog.isPublic()) {
                                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                                }
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        boolean bl2 = bl;
                        return bl2;
                    }
                    this.notifyCursorMoved();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    boolean bl = true;
                    return bl;
                }
                this.presentRow = this.rowCount + 1;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = false;
                return bl;
            }
            if (this.fetchDirection == 1001) {
                if (this.presentRow - 1 > 0) {
                    --this.presentRow;
                    if (!this.showDeleted && this.getCurrentRow().isRowDeleted()) {
                        boolean bl = this.next();
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                if (OracleLog.isPublic()) {
                                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                                }
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        boolean bl3 = bl;
                        return bl3;
                    }
                    this.notifyCursorMoved();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    boolean bl = true;
                    return bl;
                }
                this.presentRow = 0;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = false;
                return bl;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean previous() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowCount < 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = false;
                return bl;
            }
            if (this.fetchDirection == 1001) {
                if (this.presentRow + 1 <= this.rowCount) {
                    ++this.presentRow;
                    if (!this.showDeleted && this.getCurrentRow().isRowDeleted()) {
                        boolean bl = this.previous();
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                if (OracleLog.isPublic()) {
                                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                                }
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        boolean bl2 = bl;
                        return bl2;
                    }
                    this.notifyCursorMoved();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    boolean bl = true;
                    return bl;
                }
                this.presentRow = this.rowCount + 1;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = false;
                return bl;
            }
            if (this.fetchDirection == 1000 || this.fetchDirection == 1002) {
                if (this.presentRow - 1 > 0) {
                    --this.presentRow;
                    if (!this.showDeleted && this.getCurrentRow().isRowDeleted()) {
                        boolean bl = this.previous();
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                if (OracleLog.isPublic()) {
                                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                                }
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        boolean bl3 = bl;
                        return bl3;
                    }
                    this.notifyCursorMoved();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    boolean bl = true;
                    return bl;
                }
                this.presentRow = 0;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = false;
                return bl;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBeforeFirst() throws SQLException {
        try {
            boolean bl;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = bl = this.rowCount > 0 && this.presentRow == 0;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl3 = bl;
            return bl3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAfterLast() throws SQLException {
        try {
            boolean bl;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = bl = this.rowCount > 0 && this.presentRow == this.rowCount + 1;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl3 = bl;
            return bl3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFirst() throws SQLException {
        try {
            boolean bl;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = bl = this.presentRow == 1;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl3 = bl;
            return bl3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLast() throws SQLException {
        try {
            boolean bl;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = bl = this.presentRow == this.rowCount;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl3 = bl;
            return bl3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeFirst() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.presentRow = 0;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterLast() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.presentRow = this.rowCount + 1;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean first() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = this.absolute(1);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean last() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = this.absolute(-1);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean absolute(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowsetType == 1003) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 314);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 314);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 == 0 || Math.abs(n2) > this.rowCount) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = false;
                return bl;
            }
            this.presentRow = n2 < 0 ? this.rowCount + n2 + 1 : n2;
            this.notifyCursorMoved();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean relative(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = this.absolute(this.presentRow + n2);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void populate(ResultSet resultSet) throws SQLException {
        try {
            int n2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(resultSet));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rows == null) {
                this.rows = new Vector(50, 10);
            } else {
                this.rows.clear();
            }
            this.rowsetMetaData = new OracleRowSetMetaData(resultSet.getMetaData());
            this.colCount = this.rowsetMetaData.getColumnCount();
            this.metaData = new String[this.colCount];
            for (n2 = 0; n2 < this.colCount; ++n2) {
                this.metaData[n2] = this.rowsetMetaData.getColumnName(n2 + 1);
            }
            if (!(resultSet instanceof OracleCachedRowSet)) {
                this.populateInit(resultSet);
            }
            n2 = this.fetchDirection == 1000 || this.fetchDirection == 1002 ? 1 : 0;
            this.rowCount = 0;
            OracleRow oracleRow = null;
            int n3 = this.maxRows == 0 && this.pageSize == 0 ? Integer.MAX_VALUE : (this.maxRows == 0 || this.pageSize == 0 ? Math.max(this.maxRows, this.pageSize) : Math.min(this.maxRows, this.pageSize));
            if (resultSet.getType() != 1003 && this.rows.size() == 0 && n2 == 0) {
                resultSet.afterLast();
            }
            boolean bl = false;
            while (this.rowCount < n3) {
                if (n2 != 0) {
                    if (!resultSet.next()) {
                        bl = true;
                        break;
                    }
                } else if (!resultSet.previous()) {
                    bl = true;
                    break;
                }
                oracleRow = new OracleRow(this.colCount);
                for (int i2 = 1; i2 <= this.colCount; ++i2) {
                    Object object = null;
                    try {
                        object = resultSet.getObject(i2, this.typeMap);
                    }
                    catch (Exception exception) {
                        object = resultSet.getObject(i2);
                    }
                    catch (AbstractMethodError abstractMethodError) {
                        object = resultSet.getObject(i2);
                    }
                    if (object instanceof Clob || object instanceof CLOB) {
                        oracleRow.setColumnValue(i2, new OracleSerialClob((Clob)object));
                    } else if (object instanceof Blob || object instanceof BLOB) {
                        oracleRow.setColumnValue(i2, new OracleSerialBlob((Blob)object));
                    } else {
                        oracleRow.setColumnValue(i2, object);
                    }
                    oracleRow.markOriginalNull(i2, resultSet.wasNull());
                }
                if (n2 != 0) {
                    this.rows.add(oracleRow);
                } else {
                    this.rows.add(1, oracleRow);
                }
                ++this.rowCount;
            }
            if (bl || n2 != 0 && resultSet.isAfterLast() || n2 == 0 && resultSet.isBeforeFirst()) {
                this.isPopulateDone = true;
            }
            this.connection = null;
            this.notifyRowSetChanged();
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCursorName() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 23);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void clearParameters() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.param = null;
            this.param = new Vector();
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean wasNull() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.previousColumnWasNull);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = this.previousColumnWasNull;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.release();
            this.isClosed = true;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.sqlWarning);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLWarning sQLWarning = this.sqlWarning;
            return sQLWarning;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearWarnings() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.sqlWarning = null;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.rowsetMetaData);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ResultSetMetaData resultSetMetaData = this.rowsetMetaData;
            return resultSetMetaData;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int findColumn(String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.getColumnIndex(string);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n2);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n3 = n2;
            return n3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] getParams() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object[] objectArray = this.param.toArray();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + objectArray);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object[] objectArray2 = objectArray;
            return objectArray2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMetaData(RowSetMetaData rowSetMetaData) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(rowSetMetaData));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.rowsetMetaData = rowSetMetaData;
            if (rowSetMetaData != null) {
                this.colCount = rowSetMetaData.getColumnCount();
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void execute() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.isConnectionStayingOpenForTxnControl = false;
            this.getReader().readData(this);
            this.executeCalled = true;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acceptChanges() throws SyncProviderException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            try {
                this.getWriter().writeData(this);
            }
            catch (SQLException sQLException) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SyncProviderException: " + sQLException.getMessage());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new SyncProviderException(sQLException.getMessage());
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acceptChanges(Connection connection) throws SyncProviderException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(connection));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.connection = connection;
            this.isConnectionStayingOpenForTxnControl = true;
            this.acceptChanges();
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() throws CloneNotSupportedException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            try {
                CachedRowSet cachedRowSet = this.createCopy();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + cachedRowSet);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                CachedRowSet cachedRowSet2 = cachedRowSet;
                return cachedRowSet2;
            }
            catch (SQLException sQLException) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing CloneNotSupportedException: " + "SQL Error occured while cloning: " + sQLException.getMessage());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new CloneNotSupportedException("SQL Error occured while cloning: " + sQLException.getMessage());
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CachedRowSet createCopy() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleCachedRowSet oracleCachedRowSet = (OracleCachedRowSet)this.createShared();
            int n2 = this.rows.size();
            oracleCachedRowSet.rows = new Vector(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                oracleCachedRowSet.rows.add(((OracleRow)this.rows.elementAt(i2)).createCopy());
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + oracleCachedRowSet);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleCachedRowSet oracleCachedRowSet2 = oracleCachedRowSet;
            return oracleCachedRowSet2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowSet createShared() throws SQLException {
        try {
            int n2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleCachedRowSet oracleCachedRowSet = new OracleCachedRowSet();
            oracleCachedRowSet.rows = this.rows;
            oracleCachedRowSet.setDataSource(this.getDataSource());
            oracleCachedRowSet.setDataSourceName(this.getDataSourceName());
            oracleCachedRowSet.setUsername(this.getUsername());
            oracleCachedRowSet.setPassword(this.getPassword());
            oracleCachedRowSet.setUrl(this.getUrl());
            oracleCachedRowSet.setTypeMap(this.getTypeMap());
            oracleCachedRowSet.setMaxFieldSize(this.getMaxFieldSize());
            oracleCachedRowSet.setMaxRows(this.getMaxRows());
            oracleCachedRowSet.setQueryTimeout(this.getQueryTimeout());
            oracleCachedRowSet.setFetchSize(this.getFetchSize());
            oracleCachedRowSet.setEscapeProcessing(this.getEscapeProcessing());
            oracleCachedRowSet.setConcurrency(this.getConcurrency());
            oracleCachedRowSet.setReadOnly(this.readOnly);
            this.rowsetType = this.getType();
            this.fetchDirection = this.getFetchDirection();
            oracleCachedRowSet.setCommand(this.getCommand());
            oracleCachedRowSet.setTransactionIsolation(this.getTransactionIsolation());
            oracleCachedRowSet.presentRow = this.presentRow;
            oracleCachedRowSet.colCount = this.colCount;
            oracleCachedRowSet.rowCount = this.rowCount;
            oracleCachedRowSet.showDeleted = this.showDeleted;
            oracleCachedRowSet.syncProvider = this.syncProvider;
            oracleCachedRowSet.currentPage = this.currentPage;
            oracleCachedRowSet.pageSize = this.pageSize;
            oracleCachedRowSet.tableName = this.tableName == null ? null : this.tableName;
            oracleCachedRowSet.keyColumns = this.keyColumns == null ? null : (int[])this.keyColumns.clone();
            int n3 = this.listener.size();
            for (n2 = 0; n2 < n3; ++n2) {
                oracleCachedRowSet.listener.add(this.listener.elementAt(n2));
            }
            oracleCachedRowSet.rowsetMetaData = new OracleRowSetMetaData(this.rowsetMetaData);
            n3 = this.param.size();
            for (n2 = 0; n2 < n3; ++n2) {
                oracleCachedRowSet.param.add(this.param.elementAt(n2));
            }
            oracleCachedRowSet.metaData = new String[this.metaData.length];
            System.arraycopy(this.metaData, 0, oracleCachedRowSet.metaData, 0, this.metaData.length);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + oracleCachedRowSet);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleCachedRowSet oracleCachedRowSet2 = oracleCachedRowSet;
            return oracleCachedRowSet2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.rows = null;
            this.rows = new Vector();
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
            this.rowCount = 0;
            this.presentRow = 0;
            this.notifyRowSetChanged();
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreOriginal() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = false;
            for (int i2 = 0; i2 < this.rowCount; ++i2) {
                OracleRow oracleRow = (OracleRow)this.rows.elementAt(i2);
                if (oracleRow.isRowInserted()) {
                    this.rows.remove(i2);
                    --this.rowCount;
                    --i2;
                    bl = true;
                    continue;
                }
                if (oracleRow.isRowUpdated()) {
                    oracleRow.setRowUpdated(false);
                    bl = true;
                    continue;
                }
                if (!oracleRow.isRowDeleted()) continue;
                oracleRow.setRowDeleted(false);
                bl = true;
            }
            if (!bl) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 315);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 315);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.notifyRowSetChanged();
            this.presentRow = 0;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection toCollection() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Map<Integer, Collection> map = Collections.synchronizedMap(new TreeMap());
            try {
                for (int i2 = 0; i2 < this.rowCount; ++i2) {
                    map.put(i2, ((OracleRow)this.rows.elementAt(i2)).toCollection());
                }
            }
            catch (Exception exception) {
                map = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 316);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 316);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Collection collection = map.values();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + collection);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Collection collection2 = collection;
            return collection2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection toCollection(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (n2 < 1 || n2 > this.colCount) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3 + "" + n2);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "" + n2);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Vector<Object> vector = new Vector<Object>(this.rowCount);
            for (int i2 = 0; i2 < this.rowCount; ++i2) {
                OracleRow oracleRow = (OracleRow)this.rows.elementAt(i2);
                Object object = oracleRow.isColumnChanged(n2) ? oracleRow.getModifiedColumn(n2) : oracleRow.getColumn(n2);
                vector.add(object);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + vector);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Vector<Object> vector2 = vector;
            return vector2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection toCollection(String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Collection collection = this.toCollection(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + collection);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Collection collection2 = collection;
            return collection2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRow() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.presentRow > this.rowCount) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.rowCount);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int n2 = this.rowCount;
                return n2;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.presentRow);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n3 = this.presentRow;
            return n3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelRowInsert() throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.getCurrentRow().isRowInserted()) {
                    this.rows.remove(--this.presentRow);
                    --this.rowCount;
                    this.notifyRowChanged();
                    break block20;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 317);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 317);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelRowDelete() throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.getCurrentRow().isRowDeleted()) {
                    this.getCurrentRow().setRowDeleted(false);
                    this.notifyRowChanged();
                    break block20;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 318);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 318);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelRowUpdates() throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.getCurrentRow().isRowUpdated()) {
                    this.updateRowFlag = false;
                    this.getCurrentRow().setRowUpdated(false);
                    this.notifyRowChanged();
                    break block20;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 319);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 319);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertRow() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.isReadOnly()) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 309);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 309);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (!this.insertRowFlag) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 317);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 317);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (!this.insertRow.isRowFullyPopulated()) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 320);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 320);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.insertRow.insertRow();
            this.rows.insertElementAt(this.insertRow, this.insertRowPosition - 1);
            this.insertRowFlag = false;
            ++this.rowCount;
            this.notifyRowChanged();
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRow() throws SQLException {
        block26: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.isReadOnly()) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 309);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 309);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (this.updateRowFlag) {
                    this.updateRowFlag = false;
                    this.getCurrentRow().setRowUpdated(true);
                    this.notifyRowChanged();
                    break block26;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 319);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 319);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteRow() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.isReadOnly()) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 309);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 309);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.getCurrentRow().setRowDeleted(true);
            this.notifyRowChanged();
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshRow() throws SQLException {
        try {
            OracleRow oracleRow;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if ((oracleRow = this.getCurrentRow()).isRowUpdated()) {
                oracleRow.cancelRowUpdates();
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveToInsertRow() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.isReadOnly()) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 309);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 309);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.insertRow = new OracleRow(this.colCount, true);
            this.insertRowFlag = true;
            this.insertRowPosition = this.isAfterLast() ? this.presentRow : this.presentRow + 1;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveToCurrentRow() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.isReadOnly()) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 309);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 309);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.insertRowFlag = false;
            this.updateRowFlag = false;
            this.absolute(this.presentRow);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rowUpdated() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = this.getCurrentRow().isRowUpdated();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rowInserted() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = this.getCurrentRow().isRowInserted();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rowDeleted() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = this.getCurrentRow().isRowDeleted();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getOriginalRow() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleCachedRowSet oracleCachedRowSet = new OracleCachedRowSet();
            oracleCachedRowSet.rowsetMetaData = this.rowsetMetaData;
            oracleCachedRowSet.rowCount = 1;
            oracleCachedRowSet.colCount = this.colCount;
            oracleCachedRowSet.presentRow = 0;
            oracleCachedRowSet.setReader(null);
            oracleCachedRowSet.setWriter(null);
            OracleRow oracleRow = new OracleRow(this.rowsetMetaData.getColumnCount(), this.getCurrentRow().getOriginalRow());
            oracleCachedRowSet.rows.add(oracleRow);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + oracleCachedRowSet);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleCachedRowSet oracleCachedRowSet2 = oracleCachedRowSet;
            return oracleCachedRowSet2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getOriginal() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleCachedRowSet oracleCachedRowSet = new OracleCachedRowSet();
            oracleCachedRowSet.rowsetMetaData = this.rowsetMetaData;
            oracleCachedRowSet.rowCount = this.rowCount;
            oracleCachedRowSet.colCount = this.colCount;
            oracleCachedRowSet.presentRow = 0;
            oracleCachedRowSet.setType(1004);
            oracleCachedRowSet.setConcurrency(1008);
            oracleCachedRowSet.setReader(null);
            oracleCachedRowSet.setWriter(null);
            int n2 = this.rowsetMetaData.getColumnCount();
            OracleRow oracleRow = null;
            Object object = this.rows.iterator();
            while (object.hasNext()) {
                oracleRow = new OracleRow(n2, ((OracleRow)object.next()).getOriginalRow());
                oracleCachedRowSet.rows.add(oracleRow);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + oracleCachedRowSet);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            object = oracleCachedRowSet;
            return object;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNull(int n2, int n3) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(n3));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.checkParamIndex(n2);
            this.param.add(n2 - 1, null);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNull(int n2, int n3, String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(n3) + ", " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.checkParamIndex(n2);
            Object[] objectArray = new Object[]{n3, string};
            this.param.add(n2 - 1, objectArray);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBoolean(int n2, boolean bl) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(bl));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.checkParamIndex(n2);
            this.param.add(n2 - 1, bl);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setByte(int n2, byte by) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(by));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.checkParamIndex(n2);
            this.param.add(n2 - 1, new Byte(by));
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setShort(int n2, short s2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(s2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.checkParamIndex(n2);
            this.param.add(n2 - 1, s2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInt(int n2, int n3) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(n3));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.checkParamIndex(n2);
            this.param.add(n2 - 1, n3);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLong(int n2, long l2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(l2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.checkParamIndex(n2);
            this.param.add(n2 - 1, l2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFloat(int n2, float f2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(f2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.checkParamIndex(n2);
            this.param.add(n2 - 1, Float.valueOf(f2));
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDouble(int n2, double d2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(d2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.checkParamIndex(n2);
            this.param.add(n2 - 1, d2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(bigDecimal));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.checkParamIndex(n2);
            this.param.add(n2 - 1, bigDecimal);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setString(int n2, String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.checkParamIndex(n2);
            this.param.add(n2 - 1, string);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBytes(int n2, byte[] byArray) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(byArray));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.checkParamIndex(n2);
            this.param.add(n2 - 1, byArray);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDate(int n2, java.sql.Date date) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(date));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.checkParamIndex(n2);
            this.param.add(n2 - 1, date);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTime(int n2, Time time) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(time));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.checkParamIndex(n2);
            this.param.add(n2 - 1, time);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObject(int n2, Object object) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(object));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.checkParamIndex(n2);
            this.param.add(n2 - 1, object);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRef(int n2, Ref ref) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(ref));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.checkParamIndex(n2);
            this.param.add(n2 - 1, ref);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlob(int n2, Blob blob) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(blob));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.checkParamIndex(n2);
            this.param.add(n2 - 1, blob);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClob(int n2, Clob clob) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(clob));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.checkParamIndex(n2);
            this.param.add(n2 - 1, clob);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setArray(int n2, Array array) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(array));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.checkParamIndex(n2);
            this.param.add(n2 - 1, array);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(inputStream) + ", " + OracleLog.argument(n3));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.checkParamIndex(n2);
            Object[] objectArray = new Object[]{inputStream, n3, 2};
            this.param.add(n2 - 1, objectArray);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTime(int n2, Time time, Calendar calendar) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(time) + ", " + OracleLog.argument(calendar));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.checkParamIndex(n2);
            Object[] objectArray = new Object[]{time, calendar};
            this.param.add(n2 - 1, objectArray);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimestamp(int n2, Timestamp timestamp, Calendar calendar) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(timestamp) + ", " + OracleLog.argument(calendar));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.checkParamIndex(n2);
            Object[] objectArray = new Object[]{timestamp, calendar};
            this.param.add(n2 - 1, objectArray);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimestamp(int n2, Timestamp timestamp) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(timestamp));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.checkParamIndex(n2);
            this.param.add(n2 - 1, timestamp);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(inputStream) + ", " + OracleLog.argument(n3));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.checkParamIndex(n2);
            Object[] objectArray = new Object[]{inputStream, n3, 3};
            this.param.add(n2 - 1, objectArray);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUnicodeStream(int n2, InputStream inputStream, int n3) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(inputStream) + ", " + OracleLog.argument(n3));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.checkParamIndex(n2);
            Object[] objectArray = new Object[]{inputStream, n3, 1};
            this.param.add(n2 - 1, objectArray);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(reader) + ", " + OracleLog.argument(n3));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.checkParamIndex(n2);
            Object[] objectArray = new Object[]{reader, n3, 4};
            this.param.add(n2 - 1, objectArray);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObject(int n2, Object object, int n3, int n4) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(object) + ", " + OracleLog.argument(n3) + ", " + OracleLog.argument(n4));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.checkParamIndex(n2);
            Object[] objectArray = new Object[]{object, n3, n4};
            this.param.add(n2 - 1, objectArray);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObject(int n2, Object object, int n3) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(object) + ", " + OracleLog.argument(n3));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.checkParamIndex(n2);
            Object[] objectArray = new Object[]{object, n3};
            this.param.add(n2 - 1, objectArray);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDate(int n2, java.sql.Date date, Calendar calendar) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(date) + ", " + OracleLog.argument(calendar));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.checkParamIndex(n2);
            Object[] objectArray = new Object[]{date, calendar};
            this.param.add(n2 - 1, objectArray);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setURL(int n2, URL uRL) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(uRL));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.checkParamIndex(n2);
            this.param.add(n2 - 1, uRL.toString());
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Object getObject(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n3 = this.presentRow * this.colCount + n2 - 1;
            Object object = null;
            object = !this.isUpdated(n2) ? this.getCurrentRow().getColumn(n2) : this.getCurrentRow().getModifiedColumn(n2);
            boolean bl = this.previousColumnWasNull = object == null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object object2 = object;
            return object2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Number getNumber(int n2) throws SQLException {
        block51: {
            Object object;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if ((object = this.getObject(n2)) == null || object instanceof BigDecimal || object instanceof Number) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (Number)object);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Number number = (Number)object;
                return number;
            }
            if (object instanceof Boolean) {
                Integer n3 = (Boolean)object != false ? 1 : 0;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n3);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Integer n4 = n3;
                return n4;
            }
            if (!(object instanceof String)) break block51;
            try {
                BigDecimal bigDecimal = new BigDecimal((String)object);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bigDecimal);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                BigDecimal bigDecimal2 = bigDecimal;
                return bigDecimal2;
            }
            catch (NumberFormatException numberFormatException) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 59);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 59);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59);
        sQLException.fillInStackTrace();
        throw sQLException;
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(int n2, Map map) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(map));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object object = this.getObject(n2);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object object2 = object;
            return object2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBoolean(int n2) throws SQLException {
        try {
            Object object;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if ((object = this.getObject(n2)) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = false;
                return bl;
            }
            if (object instanceof Boolean) {
                boolean bl = (Boolean)object;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl2 = bl;
                return bl2;
            }
            if (object instanceof Number) {
                boolean bl;
                boolean bl3 = bl = ((Number)object).doubleValue() != 0.0;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl4 = bl;
                return bl4;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 59);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte getByte(int n2) throws SQLException {
        try {
            Object object;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if ((object = this.getObject(n2)) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byte by = 0;
                return by;
            }
            if (object instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)object;
                if (bigDecimal.compareTo(new BigDecimal(127)) == 1 || bigDecimal.compareTo(new BigDecimal(-128)) == -1) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 26);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 26);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                byte by = bigDecimal.byteValue();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + by);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byte by2 = by;
                return by2;
            }
            if (object instanceof Number) {
                byte by = ((Number)object).byteValue();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + by);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byte by3 = by;
                return by3;
            }
            if (object instanceof String) {
                byte by = ((String)object).getBytes()[0];
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + by);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byte by4 = by;
                return by4;
            }
            if (object instanceof OracleSerialBlob) {
                OracleSerialBlob oracleSerialBlob = (OracleSerialBlob)object;
                byte by = oracleSerialBlob.getBytes(1L, 1)[0];
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + by);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byte by5 = by;
                return by5;
            }
            if (object instanceof OracleSerialClob) {
                OracleSerialClob oracleSerialClob = (OracleSerialClob)object;
                byte by = oracleSerialClob.getSubString(1L, 1).getBytes()[0];
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + by);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byte by6 = by;
                return by6;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 59);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getShort(int n2) throws SQLException {
        try {
            Number number;
            short s2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            short s3 = s2 = (number = this.getNumber(n2)) == null ? (short)0 : number.shortValue();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + s2);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            short s4 = s2;
            return s4;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInt(int n2) throws SQLException {
        try {
            Number number;
            int n3;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n4 = n3 = (number = this.getNumber(n2)) == null ? 0 : number.intValue();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n3);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n5 = n3;
            return n5;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLong(int n2) throws SQLException {
        try {
            Number number;
            long l2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            long l3 = l2 = (number = this.getNumber(n2)) == null ? 0L : number.longValue();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + l2);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            long l4 = l2;
            return l4;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getFloat(int n2) throws SQLException {
        try {
            Number number;
            float f2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            float f3 = f2 = (number = this.getNumber(n2)) == null ? 0.0f : number.floatValue();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + f2);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            float f4 = f2;
            return f4;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getDouble(int n2) throws SQLException {
        try {
            Number number;
            double d2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            double d3 = d2 = (number = this.getNumber(n2)) == null ? 0.0 : number.doubleValue();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + d2);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            double d4 = d2;
            return d4;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(int n2) throws SQLException {
        try {
            Number number;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if ((number = this.getNumber(n2)) == null || number instanceof BigDecimal) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (BigDecimal)number);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                BigDecimal bigDecimal = (BigDecimal)number;
                return bigDecimal;
            }
            BigDecimal bigDecimal = new BigDecimal(number.doubleValue());
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bigDecimal);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            BigDecimal bigDecimal2 = bigDecimal;
            return bigDecimal2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(n3));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            BigDecimal bigDecimal = this.getBigDecimal(n2);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bigDecimal);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            BigDecimal bigDecimal2 = bigDecimal;
            return bigDecimal2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public java.sql.Date getDate(int n2) throws SQLException {
        try {
            Object object;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if ((object = this.getObject(n2)) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (java.sql.Date)object);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                java.sql.Date date = (java.sql.Date)object;
                return date;
            }
            if (object instanceof Time) {
                Time time = (Time)object;
                java.sql.Date date = new java.sql.Date(time.getTime());
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + date);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                java.sql.Date date2 = date;
                return date2;
            }
            if (object instanceof Date) {
                Date date = (Date)object;
                java.sql.Date date3 = new java.sql.Date(date.getYear(), date.getMonth(), date.getDate());
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + date3);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                java.sql.Date date4 = date3;
                return date4;
            }
            if (object instanceof TIMESTAMP) {
                java.sql.Date date = ((TIMESTAMP)object).dateValue();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + date);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                java.sql.Date date5 = date;
                return date5;
            }
            if (object instanceof TIMESTAMPTZ) {
                java.sql.Date date = ((TIMESTAMPTZ)object).dateValue(this.getConnectionInternal());
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + date);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                java.sql.Date date6 = date;
                return date6;
            }
            if (object instanceof TIMESTAMPLTZ) {
                Connection connection = this.getConnectionInternal();
                java.sql.Date date = ((TIMESTAMPLTZ)object).dateValue(connection, this.getSessionCalendar(connection));
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + date);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                java.sql.Date date7 = date;
                return date7;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public java.sql.Date getDate(int n2, Calendar calendar) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(calendar));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            java.sql.Date date = this.getDate(n2);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + date);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            java.sql.Date date2 = date;
            return date2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(int n2) throws SQLException {
        try {
            Object object;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if ((object = this.getObject(n2)) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (Time)object);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Time time = (Time)object;
                return time;
            }
            if (object instanceof Date) {
                Date date = (Date)object;
                Time time = new Time(date.getHours(), date.getMinutes(), date.getSeconds());
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + time);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Time time2 = time;
                return time2;
            }
            if (object instanceof TIMESTAMP) {
                Time time = ((TIMESTAMP)object).timeValue();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + time);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Time time3 = time;
                return time3;
            }
            if (object instanceof TIMESTAMPTZ) {
                Time time = ((TIMESTAMPTZ)object).timeValue(this.getConnectionInternal());
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + time);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Time time4 = time;
                return time4;
            }
            if (object instanceof TIMESTAMPLTZ) {
                Connection connection = this.getConnectionInternal();
                Time time = ((TIMESTAMPLTZ)object).timeValue(connection, this.getSessionCalendar(connection));
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + time);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Time time5 = time;
                return time5;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(int n2, Calendar calendar) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(calendar));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Time time = this.getTime(n2);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + time);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Time time2 = time;
            return time2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(int n2) throws SQLException {
        try {
            Object object;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if ((object = this.getObject(n2)) == null || object instanceof Timestamp) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (Timestamp)object);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Timestamp timestamp = (Timestamp)object;
                return timestamp;
            }
            if (object instanceof Date) {
                Timestamp timestamp = new Timestamp(((Date)object).getTime());
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + timestamp);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Timestamp timestamp2 = timestamp;
                return timestamp2;
            }
            if (object instanceof TIMESTAMP) {
                Timestamp timestamp = ((TIMESTAMP)object).timestampValue();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + timestamp);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Timestamp timestamp3 = timestamp;
                return timestamp3;
            }
            if (object instanceof TIMESTAMPTZ) {
                Timestamp timestamp = ((TIMESTAMPTZ)object).timestampValue(this.getConnectionInternal());
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + timestamp);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Timestamp timestamp4 = timestamp;
                return timestamp4;
            }
            if (object instanceof TIMESTAMPLTZ) {
                Connection connection = this.getConnectionInternal();
                Timestamp timestamp = ((TIMESTAMPLTZ)object).timestampValue(connection, this.getSessionCalendar(connection));
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + timestamp);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Timestamp timestamp5 = timestamp;
                return timestamp5;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(calendar));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Timestamp timestamp = this.getTimestamp(n2);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + timestamp);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Timestamp timestamp2 = timestamp;
            return timestamp2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes(int n2) throws SQLException {
        try {
            Object object;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if ((object = this.getObject(n2)) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (byte[])object);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byte[] byArray = (byte[])object;
                return byArray;
            }
            if (object instanceof byte[]) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (byte[])object);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byte[] byArray = (byte[])object;
                return byArray;
            }
            if (object instanceof String) {
                byte[] byArray = ((String)object).getBytes();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + byArray);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byte[] byArray2 = byArray;
                return byArray2;
            }
            if (object instanceof Number) {
                byte[] byArray = ((Number)object).toString().getBytes();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + byArray);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byte[] byArray3 = byArray;
                return byArray3;
            }
            if (object instanceof BigDecimal) {
                byte[] byArray = ((BigDecimal)object).toString().getBytes();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + byArray);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byte[] byArray4 = byArray;
                return byArray4;
            }
            if (object instanceof OracleSerialBlob) {
                OracleSerialBlob oracleSerialBlob = (OracleSerialBlob)object;
                byte[] byArray = oracleSerialBlob.getBytes(1L, (int)oracleSerialBlob.length());
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + byArray);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byte[] byArray5 = byArray;
                return byArray5;
            }
            if (object instanceof OracleSerialClob) {
                OracleSerialClob oracleSerialClob = (OracleSerialClob)object;
                byte[] byArray = oracleSerialClob.getSubString(1L, (int)oracleSerialClob.length()).getBytes();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + byArray);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byte[] byArray6 = byArray;
                return byArray6;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 59);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Ref getRef(int n2) throws SQLException {
        try {
            Object object;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if ((object = this.getObject(n2)) == null || object instanceof Ref) {
                Ref ref = (Ref)object;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ref);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Ref ref2 = ref;
                return ref2;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob getBlob(int n2) throws SQLException {
        try {
            Object object;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if ((object = this.getObject(n2)) == null || object instanceof OracleSerialBlob) {
                Blob blob = (Blob)object;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + blob);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Blob blob2 = blob;
                return blob2;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Clob getClob(int n2) throws SQLException {
        try {
            Object object;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if ((object = this.getObject(n2)) == null || object instanceof OracleSerialClob) {
                Clob clob = (Clob)object;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + clob);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Clob clob2 = clob;
                return clob2;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Array getArray(int n2) throws SQLException {
        try {
            Object object;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if ((object = this.getObject(n2)) == null || object instanceof Array) {
                Array array = (Array)object;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + array);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Array array2 = array;
                return array2;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getString(int n2) throws SQLException {
        block132: {
            Object object;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if ((object = this.getObject(n2)) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (String)object);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string = (String)object;
                return string;
            }
            if (object instanceof String) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (String)object);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string = (String)object;
                return string;
            }
            if (object instanceof Number || object instanceof BigDecimal) {
                String string = object.toString();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + string);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string2 = string;
                return string2;
            }
            if (object instanceof java.sql.Date) {
                String string = object.toString();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + string);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string3 = string;
                return string3;
            }
            if (object instanceof Timestamp) {
                String string = object.toString();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + string);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string4 = string;
                return string4;
            }
            if (object instanceof byte[]) {
                String string = new String((byte[])object);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + string);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string5 = string;
                return string5;
            }
            if (object instanceof OracleSerialClob) {
                OracleSerialClob oracleSerialClob = (OracleSerialClob)object;
                String string = oracleSerialClob.getSubString(1L, (int)oracleSerialClob.length());
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + string);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string6 = string;
                return string6;
            }
            if (object instanceof OracleSerialBlob) {
                OracleSerialBlob oracleSerialBlob = (OracleSerialBlob)object;
                String string = new String(oracleSerialBlob.getBytes(1L, (int)oracleSerialBlob.length()));
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + string);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string7 = string;
                return string7;
            }
            if (object instanceof URL) {
                String string = ((URL)object).toString();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + string);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string8 = string;
                return string8;
            }
            if (object instanceof ROWID) {
                String string = ((ROWID)object).stringValue();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + string);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string9 = string;
                return string9;
            }
            if (!(object instanceof Reader)) break block132;
            try {
                Reader reader = (Reader)object;
                char[] cArray = new char[1024];
                int n3 = 0;
                StringBuffer stringBuffer = new StringBuffer(1024);
                while ((n3 = reader.read(cArray)) > 0) {
                    stringBuffer.append(cArray, 0, n3);
                }
                String string = stringBuffer.substring(0, stringBuffer.length());
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + string);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string10 = string;
                return string10;
            }
            catch (IOException iOException) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 321 + iOException.getMessage());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 321, iOException.getMessage());
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 59);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59);
        sQLException.fillInStackTrace();
        throw sQLException;
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getAsciiStream(int n2) throws SQLException {
        try {
            InputStream inputStream;
            InputStream inputStream2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            InputStream inputStream3 = inputStream2 = (inputStream = this.getStream(n2)) == null ? null : inputStream;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + inputStream2);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            InputStream inputStream4 = inputStream2;
            return inputStream4;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getUnicodeStream(int n2) throws SQLException {
        try {
            Object object;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if ((object = this.getObject(n2)) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (InputStream)object);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                InputStream inputStream = (InputStream)object;
                return inputStream;
            }
            if (object instanceof String) {
                StringBufferInputStream stringBufferInputStream = new StringBufferInputStream((String)object);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + stringBufferInputStream);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                StringBufferInputStream stringBufferInputStream2 = stringBufferInputStream;
                return stringBufferInputStream2;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 59);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getBinaryStream(int n2) throws SQLException {
        try {
            InputStream inputStream;
            InputStream inputStream2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            InputStream inputStream3 = inputStream2 = (inputStream = this.getStream(n2)) == null ? null : inputStream;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + inputStream2);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            InputStream inputStream4 = inputStream2;
            return inputStream4;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Reader getCharacterStream(int n2) throws SQLException {
        try {
            int n3;
            StringBuffer stringBuffer;
            InputStream inputStream;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            try {
                inputStream = this.getAsciiStream(n2);
                if (inputStream == null) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    Reader reader = null;
                    return reader;
                }
                stringBuffer = new StringBuffer();
                n3 = 0;
            }
            catch (IOException iOException) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 322);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 322);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            while ((n3 = inputStream.read()) != -1) {
                stringBuffer.append((char)n3);
            }
            char[] cArray = new char[stringBuffer.length()];
            stringBuffer.getChars(0, stringBuffer.length(), cArray, 0);
            CharArrayReader charArrayReader = new CharArrayReader(cArray);
            cArray = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + charArrayReader);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            CharArrayReader charArrayReader2 = charArrayReader;
            return charArrayReader2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Object getObject(String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object object = this.getObject(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object object2 = object;
            return object2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBoolean(String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = this.getBoolean(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte getByte(String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte by = this.getByte(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + by);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte by2 = by;
            return by2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getShort(String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            short s2 = this.getShort(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + s2);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            short s3 = s2;
            return s3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInt(String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.getInt(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n2);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n3 = n2;
            return n3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLong(String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            long l2 = this.getLong(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + l2);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            long l3 = l2;
            return l3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getFloat(String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            float f2 = this.getFloat(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + f2);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            float f3 = f2;
            return f3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getDouble(String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            double d2 = this.getDouble(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + d2);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            double d3 = d2;
            return d3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(String string, int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            BigDecimal bigDecimal = this.getBigDecimal(this.getColumnIndex(string), n2);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bigDecimal);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            BigDecimal bigDecimal2 = bigDecimal;
            return bigDecimal2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes(String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = this.getBytes(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + byArray);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public java.sql.Date getDate(String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            java.sql.Date date = this.getDate(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + date);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            java.sql.Date date2 = date;
            return date2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Time time = this.getTime(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + time);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Time time2 = time;
            return time2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Timestamp timestamp = this.getTimestamp(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + timestamp);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Timestamp timestamp2 = timestamp;
            return timestamp2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(calendar));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Time time = this.getTime(this.getColumnIndex(string), calendar);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + time);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Time time2 = time;
            return time2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public java.sql.Date getDate(String string, Calendar calendar) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(calendar));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            java.sql.Date date = this.getDate(this.getColumnIndex(string), calendar);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + date);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            java.sql.Date date2 = date;
            return date2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            InputStream inputStream = this.getAsciiStream(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + inputStream);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            InputStream inputStream2 = inputStream;
            return inputStream2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getUnicodeStream(String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            InputStream inputStream = this.getUnicodeStream(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + inputStream);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            InputStream inputStream2 = inputStream;
            return inputStream2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getString(String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string2 = this.getString(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + string2);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string3 = string2;
            return string3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            InputStream inputStream = this.getBinaryStream(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + inputStream);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            InputStream inputStream2 = inputStream;
            return inputStream2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Reader reader = this.getCharacterStream(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + reader);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Reader reader2 = reader;
            return reader2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            BigDecimal bigDecimal = this.getBigDecimal(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bigDecimal);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            BigDecimal bigDecimal2 = bigDecimal;
            return bigDecimal2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(calendar));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Timestamp timestamp = this.getTimestamp(this.getColumnIndex(string), calendar);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + timestamp);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Timestamp timestamp2 = timestamp;
            return timestamp2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(String string, Map map) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(map));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object object = this.getObject(this.getColumnIndex(string), map);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object object2 = object;
            return object2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Ref getRef(String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Ref ref = this.getRef(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ref);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Ref ref2 = ref;
            return ref2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob getBlob(String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Blob blob = this.getBlob(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + blob);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Blob blob2 = blob;
            return blob2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Clob getClob(String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Clob clob = this.getClob(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + clob);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Clob clob2 = clob;
            return clob2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Array getArray(String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Array array = this.getArray(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + array);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Array array2 = array;
            return array2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateObject(int n2, Object object) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(object));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateObject(n2, object, (int[])null);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void updateObject(int n2, Object object, int[] nArray) throws SQLException {
        block21: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(object));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.checkColumnIndex(n2);
                if (this.insertRowFlag) {
                    this.checkAndFilterObject(n2, object);
                    this.insertRow.updateObject(n2, object, nArray);
                    break block21;
                }
                if (!this.isBeforeFirst() && !this.isAfterLast()) {
                    this.updateRowFlag = true;
                    this.updateRowPosition = this.presentRow;
                    this.getCurrentRow().updateObject(n2, object, nArray);
                    break block21;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNull(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateObject(n2, null);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void updateCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(reader) + ", " + OracleLog.argument(n3));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateCharacterStreamInternal(n2, reader, n3, false);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateCharacterStreamInternal(int n2, Reader reader, int n3, boolean bl) throws SQLException {
        this.checkColumnIndex(n2);
        if (n3 < 0) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        int n4 = this.getMetaData().getColumnType(n2);
        if (!this.isStreamType(n4)) {
            try {
                int n5;
                int n6 = 0;
                char[] cArray = new char[1024];
                StringBuilder stringBuilder = new StringBuilder(1024);
                for (n5 = n3; n5 > 0 && (n6 = n5 >= 1024 ? reader.read(cArray) : reader.read(cArray, 0, n5)) != -1; n5 -= n6) {
                    stringBuilder.append(cArray, 0, n6);
                }
                reader.close();
                if (n5 == n3) {
                    this.updateNull(n2);
                    return;
                }
                this.updateString(n2, stringBuilder.toString());
            }
            catch (IOException iOException) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + iOException);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        int n7 = bl ? 4 : 3;
        int[] nArray = new int[]{n3, n7};
        this.updateObject(n2, (Object)reader, nArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCharacterStream(String string, Reader reader, int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(reader) + ", " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateCharacterStream(this.getColumnIndex(string), reader, n2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(timestamp));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateTimestamp(this.getColumnIndex(string), timestamp);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(inputStream) + ", " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateBinaryStream(this.getColumnIndex(string), inputStream, n2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void updateBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        block34: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(inputStream) + ", " + OracleLog.argument(n3));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.checkColumnIndex(n2);
                if (n3 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n4 = this.getMetaData().getColumnType(n2);
                if (!this.isStreamType(n4)) {
                    ByteArrayOutputStream byteArrayOutputStream;
                    block33: {
                        try {
                            int n5;
                            int n6 = 0;
                            byte[] byArray = new byte[1024];
                            byteArrayOutputStream = new ByteArrayOutputStream(1024);
                            for (n5 = n3; n5 > 0 && (n6 = n5 >= 1024 ? inputStream.read(byArray) : inputStream.read(byArray, 0, n5)) != -1; n5 -= n6) {
                                byteArrayOutputStream.write(byArray, 0, n6);
                            }
                            inputStream.close();
                            if (n5 != n3) break block33;
                            this.updateNull(n2);
                            return;
                        }
                        catch (IOException iOException) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + iOException);
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                            sQLException.fillInStackTrace();
                            throw sQLException;
                        }
                    }
                    this.updateBytes(n2, byteArrayOutputStream.toByteArray());
                    break block34;
                }
                int[] nArray = new int[]{n3, 2};
                this.updateObject(n2, (Object)inputStream, nArray);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void updateAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        block34: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(inputStream) + ", " + OracleLog.argument(n3));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.checkColumnIndex(n2);
                if (n3 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n4 = this.getMetaData().getColumnType(n2);
                if (!this.isStreamType(n4)) {
                    StringBuilder stringBuilder;
                    block33: {
                        try {
                            int n5;
                            int n6 = 0;
                            byte[] byArray = new byte[1024];
                            char[] cArray = new char[1024];
                            stringBuilder = new StringBuilder(1024);
                            for (n5 = n3; n5 > 0 && (n6 = n5 >= 1024 ? inputStream.read(byArray) : inputStream.read(byArray, 0, n5)) != -1; n5 -= n6) {
                                DBConversion.asciiBytesToJavaChars(byArray, n6, cArray);
                                stringBuilder.append(cArray, 0, n6);
                            }
                            inputStream.close();
                            if (n5 != n3) break block33;
                            this.updateNull(n2);
                            return;
                        }
                        catch (IOException iOException) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + iOException);
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                            sQLException.fillInStackTrace();
                            throw sQLException;
                        }
                    }
                    this.updateString(n2, stringBuilder.toString());
                    break block34;
                }
                int[] nArray = new int[]{n3, 1};
                this.updateObject(n2, (Object)inputStream, nArray);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTimestamp(int n2, Timestamp timestamp) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(timestamp));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateObject(n2, (Object)timestamp);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBoolean(int n2, boolean bl) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(bl));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateObject(n2, (Object)bl);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateByte(int n2, byte by) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(by));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateObject(n2, (Object)new Byte(by));
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateShort(int n2, short s2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(s2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateObject(n2, (Object)s2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateInt(int n2, int n3) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(n3));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateObject(n2, (Object)n3);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLong(int n2, long l2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(l2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateObject(n2, (Object)l2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFloat(int n2, float f2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(f2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateObject(n2, (Object)Float.valueOf(f2));
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDouble(int n2, double d2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(d2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateObject(n2, (Object)d2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(bigDecimal));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateObject(n2, (Object)bigDecimal);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateString(int n2, String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateObject(n2, (Object)string);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBytes(int n2, byte[] byArray) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(byArray));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateObject(n2, (Object)byArray);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDate(int n2, java.sql.Date date) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(date));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateObject(n2, (Object)date);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTime(int n2, Time time) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(time));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateObject(n2, (Object)new Timestamp(0, 0, 0, time.getHours(), time.getMinutes(), time.getSeconds(), 0));
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateObject(int n2, Object object, int n3) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(object) + ", " + OracleLog.argument(n3));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!(object instanceof Number)) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 323);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 323);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.updateObject(n2, (Object)new BigDecimal(new BigInteger(((Number)object).toString()), n3));
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNull(String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateNull(this.getColumnIndex(string));
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(inputStream) + ", " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateAsciiStream(this.getColumnIndex(string), inputStream, n2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(bl));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateBoolean(this.getColumnIndex(string), bl);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateByte(String string, byte by) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(by));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateByte(this.getColumnIndex(string), by);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateShort(String string, short s2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(s2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateShort(this.getColumnIndex(string), s2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateInt(String string, int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateInt(this.getColumnIndex(string), n2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLong(String string, long l2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(l2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateLong(this.getColumnIndex(string), l2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFloat(String string, float f2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(f2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateFloat(this.getColumnIndex(string), f2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDouble(String string, double d2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(d2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateDouble(this.getColumnIndex(string), d2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(bigDecimal));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateBigDecimal(this.getColumnIndex(string), bigDecimal);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateString(String string, String string2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(string2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateString(this.getColumnIndex(string), string2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(byArray));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateBytes(this.getColumnIndex(string), byArray);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDate(String string, java.sql.Date date) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(date));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateDate(this.getColumnIndex(string), date);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTime(String string, Time time) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(time));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateTime(this.getColumnIndex(string), time);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateObject(String string, Object object) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(object));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateObject(this.getColumnIndex(string), object);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateObject(String string, Object object, int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(object) + ", " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateObject(this.getColumnIndex(string), object, n2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getURL(int n2) throws SQLException {
        block51: {
            Object object;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if ((object = this.getObject(n2)) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (URL)object);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                URL uRL = (URL)object;
                return uRL;
            }
            if (object instanceof URL) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (URL)object);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                URL uRL = (URL)object;
                return uRL;
            }
            if (!(object instanceof String)) break block51;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + new URL((String)object));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                URL uRL = new URL((String)object);
                return uRL;
            }
            catch (MalformedURLException malformedURLException) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 136);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 136);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
        sQLException.fillInStackTrace();
        throw sQLException;
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getURL(String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            URL uRL = this.getURL(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + uRL);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            URL uRL2 = uRL;
            return uRL2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRef(int n2, Ref ref) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(ref));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateObject(n2, (Object)ref);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(ref));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateRef(this.getColumnIndex(string), ref);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBlob(int n2, Blob blob) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(blob));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateObject(n2, (Object)blob);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(blob));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateBlob(this.getColumnIndex(string), blob);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateClob(int n2, Clob clob) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(clob));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateObject(n2, (Object)clob);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(clob));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateClob(this.getColumnIndex(string), clob);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateArray(int n2, Array array) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(array));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateObject(n2, (Object)array);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateArray(String string, Array array) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(array));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateArray(this.getColumnIndex(string), array);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getKeyColumns() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.keyColumns);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int[] nArray = this.keyColumns;
            return nArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setKeyColumns(int[] nArray) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = 0;
            if (this.rowsetMetaData != null) {
                n2 = this.rowsetMetaData.getColumnCount();
                if (nArray == null || nArray.length > n2) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 324);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 324);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
            }
            int n3 = nArray.length;
            this.keyColumns = new int[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                if (nArray[i2] <= 0 || nArray[i2] > n2) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3 + "" + nArray[i2]);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "" + nArray[i2]);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.keyColumns[i2] = nArray[i2];
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPageSize() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.pageSize);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.pageSize;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPageSize(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (n2 < 0 || this.maxRows > 0 && n2 > this.maxRows) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 325);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 325);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.pageSize = n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SyncProvider getSyncProvider() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.syncProvider);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SyncProvider syncProvider = this.syncProvider;
            return syncProvider;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSyncProvider(String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.syncProvider = SyncFactory.getInstance(string);
            this.reader = this.syncProvider.getRowSetReader();
            this.writer = this.syncProvider.getRowSetWriter();
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getTableName() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.tableName);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = this.tableName;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTableName(String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.tableName = string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CachedRowSet createCopyNoConstraints() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleCachedRowSet oracleCachedRowSet = (OracleCachedRowSet)this.createCopy();
            oracleCachedRowSet.initializeProperties();
            oracleCachedRowSet.listener = new Vector();
            try {
                oracleCachedRowSet.unsetMatchColumn(oracleCachedRowSet.getMatchColumnIndexes());
                oracleCachedRowSet.unsetMatchColumn(oracleCachedRowSet.getMatchColumnNames());
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + oracleCachedRowSet);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleCachedRowSet oracleCachedRowSet2 = oracleCachedRowSet;
            return oracleCachedRowSet2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CachedRowSet createCopySchema() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleCachedRowSet oracleCachedRowSet = (OracleCachedRowSet)this.createCopy();
            oracleCachedRowSet.rows = null;
            oracleCachedRowSet.rowCount = 0;
            oracleCachedRowSet.currentPage = 0;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + oracleCachedRowSet);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleCachedRowSet oracleCachedRowSet2 = oracleCachedRowSet;
            return oracleCachedRowSet2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean columnUpdated(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.insertRowFlag) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 326);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 326);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            boolean bl = this.getCurrentRow().isColumnChanged(n2);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean columnUpdated(String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = this.columnUpdated(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void execute(Connection connection) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(connection));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.connection = connection;
            this.execute();
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.getConnectionInternal().commit();
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.getConnectionInternal().rollback();
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(savepoint));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Connection connection = this.getConnectionInternal();
            boolean bl = connection.getAutoCommit();
            try {
                connection.setAutoCommit(false);
                connection.rollback(savepoint);
            }
            finally {
                connection.setAutoCommit(bl);
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void oracleRollback(OracleSavepoint oracleSavepoint) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(oracleSavepoint));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ((OracleConnection)this.getConnectionInternal()).oracleRollback(oracleSavepoint);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOriginalRow() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.insertRowFlag) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 327);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 327);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setOriginalRowInternal(this.presentRow);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.rowCount);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.rowCount;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean nextPage() throws SQLException {
        try {
            boolean bl;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.fetchDirection == 1001 && this.resultSet != null && this.resultSet.getType() == 1003) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 328);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 328);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.rows.size() == 0 && !this.isPopulateDone) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 329);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 329);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if ((this.isExecuteCalled() || this.isPopulateDone) && this.rowCount < this.pageSize) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl2 = false;
                return bl2;
            }
            if (this.isExecuteCalled()) {
                ++this.currentPage;
                this.execute();
            } else {
                this.populate(this.resultSet);
                ++this.currentPage;
            }
            boolean bl3 = bl = !this.isPopulateDone;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl4 = bl;
            return bl4;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean previousPage() throws SQLException {
        try {
            boolean bl;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.resultSet != null && this.resultSet.getType() == 1003) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 328);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 328);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.rows.size() == 0 && !this.isPopulateDone) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 329);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 329);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentPage == 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl2 = false;
                return bl2;
            }
            if (this.fetchDirection == 1001) {
                this.resultSet.relative(this.pageSize * 2);
            } else {
                this.resultSet.relative(-2 * this.pageSize);
            }
            this.populate(this.resultSet);
            if (this.currentPage > 0) {
                --this.currentPage;
            }
            boolean bl3 = bl = this.currentPage != 0;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl4 = bl;
            return bl4;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rowSetPopulated(RowSetEvent rowSetEvent, int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(rowSetEvent) + ", " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (n2 <= 0 || n2 < this.fetchSize) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 330);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 330);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.rowCount % n2 == 0) {
                this.rowsetEvent = new RowSetEvent(this);
                this.notifyRowSetChanged();
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowSetWarning getRowSetWarnings() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.rowsetWarning);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            RowSetWarning rowSetWarning = this.rowsetWarning;
            return rowSetWarning;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void populate(ResultSet resultSet, int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(resultSet) + ", " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (n2 < 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 331);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 331);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (resultSet == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 332);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 332);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = resultSet.getType();
            if (n3 == 1003) {
                int n4;
                boolean bl = false;
                for (n4 = 0; n4 < n2; ++n4) {
                    if (resultSet.next()) continue;
                    bl = true;
                    break;
                }
                if (n4 < n2 && n2 > 0 && bl) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 333);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 333);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
            } else if (n2 == 0) {
                resultSet.beforeFirst();
            } else {
                resultSet.absolute(n2);
            }
            this.populate(resultSet);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undoDelete() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.cancelRowDelete();
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undoInsert() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.cancelRowInsert();
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undoUpdate() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.cancelRowUpdates();
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getNCharacterStream(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Reader reader = this.getCharacterStream(n2);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + reader);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Reader reader2 = reader;
            return reader2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NClob getNClob(int n2) throws SQLException {
        try {
            Object object;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if ((object = this.getObject(n2)) == null || object instanceof OracleSerialClob) {
                NClob nClob = (NClob)object;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + nClob);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                NClob nClob2 = nClob;
                return nClob2;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNString(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = this.getString(n2);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + string);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string2 = string;
            return string2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowId getRowId(int n2) throws SQLException {
        try {
            Object object;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if ((object = this.getObject(n2)) instanceof RowId) {
                RowId rowId;
                RowId rowId2 = rowId = object == null ? null : (RowId)object;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + rowId);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                RowId rowId3 = rowId;
                return rowId3;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLXML getSQLXML(int n2) throws SQLException {
        try {
            Object object;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if ((object = this.getObject(n2)) == null || object instanceof SQLXML) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (SQLXML)object);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLXML sQLXML = (SQLXML)object;
                return sQLXML;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Reader reader = this.getNCharacterStream(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + reader);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Reader reader2 = reader;
            return reader2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NClob getNClob(String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            NClob nClob = this.getNClob(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + nClob);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            NClob nClob2 = nClob;
            return nClob2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNString(String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string2 = this.getNString(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + string2);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string3 = string2;
            return string3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowId getRowId(String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            RowId rowId = this.getRowId(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + rowId);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            RowId rowId2 = rowId;
            return rowId2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLXML sQLXML = this.getSQLXML(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + sQLXML);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLXML sQLXML2 = sQLXML;
            return sQLXML2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAsciiStream(int n2, InputStream inputStream) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(inputStream));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.checkParamIndex(n2);
            Object[] objectArray = new Object[]{inputStream, 7};
            this.param.add(n2 - 1, objectArray);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAsciiStream(int n2, InputStream inputStream, long l2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(inputStream) + ", " + OracleLog.argument(l2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.checkParamIndex(n2);
            Object[] objectArray = new Object[]{inputStream, l2, 8};
            this.param.add(n2 - 1, objectArray);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryStream(int n2, InputStream inputStream) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(inputStream));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.checkParamIndex(n2);
            Object[] objectArray = new Object[]{inputStream, 5};
            this.param.add(n2 - 1, objectArray);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBinaryStream(int n2, InputStream inputStream, long l2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(inputStream) + ", " + OracleLog.argument(l2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.checkParamIndex(n2);
            Object[] objectArray = new Object[]{inputStream, l2, 6};
            this.param.add(n2 - 1, objectArray);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlob(int n2, InputStream inputStream) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(inputStream));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.checkParamIndex(n2);
            Object[] objectArray = new Object[]{inputStream, 13};
            this.param.add(n2 - 1, objectArray);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlob(int n2, InputStream inputStream, long l2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(inputStream) + ", " + OracleLog.argument(l2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.checkParamIndex(n2);
            Object[] objectArray = new Object[]{inputStream, l2, 14};
            this.param.add(n2 - 1, objectArray);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCharacterStream(int n2, Reader reader) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(reader));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.checkParamIndex(n2);
            Object[] objectArray = new Object[]{reader, 9};
            this.param.add(n2 - 1, objectArray);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(reader) + ", " + OracleLog.argument(l2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.checkParamIndex(n2);
            Object[] objectArray = new Object[]{reader, l2, 10};
            this.param.add(n2 - 1, objectArray);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClob(int n2, Reader reader) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(reader));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.checkParamIndex(n2);
            Object[] objectArray = new Object[]{reader, 15};
            this.param.add(n2 - 1, objectArray);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClob(int n2, Reader reader, long l2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(this.reader) + ", " + OracleLog.argument(l2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.checkParamIndex(n2);
            Object[] objectArray = new Object[]{this.reader, l2, 16};
            this.param.add(n2 - 1, objectArray);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNCharacterStream(int n2, Reader reader) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(reader));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.checkParamIndex(n2);
            Object[] objectArray = new Object[]{reader, 11};
            this.param.add(n2 - 1, objectArray);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(reader) + ", " + OracleLog.argument(l2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.checkParamIndex(n2);
            Object[] objectArray = new Object[]{reader, l2, 12};
            this.param.add(n2 - 1, objectArray);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNClob(int n2, NClob nClob) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(nClob));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.checkParamIndex(n2);
            this.param.add(n2 - 1, nClob);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNClob(int n2, Reader reader) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(this.reader));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.checkParamIndex(n2);
            Object[] objectArray = new Object[]{this.reader, 17};
            this.param.add(n2 - 1, objectArray);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNClob(int n2, Reader reader, long l2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(this.reader) + ", " + OracleLog.argument(l2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.checkParamIndex(n2);
            Object[] objectArray = new Object[]{this.reader, l2, 18};
            this.param.add(n2 - 1, objectArray);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNString(int n2, String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.checkParamIndex(n2);
            this.param.add(n2 - 1, string);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRowId(int n2, RowId rowId) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(rowId));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.checkParamIndex(n2);
            this.param.add(n2 - 1, rowId);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSQLXML(int n2, SQLXML sQLXML) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(sQLXML));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.checkParamIndex(n2);
            this.param.add(n2 - 1, sQLXML);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setArray(String string, Array array) throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(array));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string2 = string.intern();
                String[] stringArray = this.osql.getParameterList();
                boolean bl = false;
                int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (stringArray[i2] != string2) continue;
                    this.setArray(i2 + 1, array);
                    bl = true;
                }
                if (bl) break block20;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 147 + string);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(bigDecimal));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string2 = string.intern();
                String[] stringArray = this.osql.getParameterList();
                boolean bl = false;
                int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (stringArray[i2] != string2) continue;
                    this.setBigDecimal(i2 + 1, bigDecimal);
                    bl = true;
                }
                if (bl) break block20;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 147 + string);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlob(String string, Blob blob) throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(blob));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string2 = string.intern();
                String[] stringArray = this.osql.getParameterList();
                boolean bl = false;
                int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (stringArray[i2] != string2) continue;
                    this.setBlob(i2 + 1, blob);
                    bl = true;
                }
                if (bl) break block20;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 147 + string);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBoolean(String string, boolean bl) throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(bl));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string2 = string.intern();
                String[] stringArray = this.osql.getParameterList();
                boolean bl2 = false;
                int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (stringArray[i2] != string2) continue;
                    this.setBoolean(i2 + 1, bl);
                    bl2 = true;
                }
                if (bl2) break block20;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 147 + string);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setByte(String string, byte by) throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(by));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string2 = string.intern();
                String[] stringArray = this.osql.getParameterList();
                boolean bl = false;
                int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (stringArray[i2] != string2) continue;
                    this.setByte(i2 + 1, by);
                    bl = true;
                }
                if (bl) break block20;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 147 + string);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBytes(String string, byte[] byArray) throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(byArray));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string2 = string.intern();
                String[] stringArray = this.osql.getParameterList();
                boolean bl = false;
                int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (stringArray[i2] != string2) continue;
                    this.setBytes(i2 + 1, byArray);
                    bl = true;
                }
                if (bl) break block20;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 147 + string);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClob(String string, Clob clob) throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(clob));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string2 = string.intern();
                String[] stringArray = this.osql.getParameterList();
                boolean bl = false;
                int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (stringArray[i2] != string2) continue;
                    this.setClob(i2 + 1, clob);
                    bl = true;
                }
                if (bl) break block20;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 147 + string);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDate(String string, java.sql.Date date) throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(date));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string2 = string.intern();
                String[] stringArray = this.osql.getParameterList();
                boolean bl = false;
                int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (stringArray[i2] != string2) continue;
                    this.setDate(i2 + 1, date);
                    bl = true;
                }
                if (bl) break block20;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 147 + string);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDate(String string, java.sql.Date date, Calendar calendar) throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(date) + ", " + OracleLog.argument(calendar));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string2 = string.intern();
                String[] stringArray = this.osql.getParameterList();
                boolean bl = false;
                int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (stringArray[i2] != string2) continue;
                    this.setDate(i2 + 1, date, calendar);
                    bl = true;
                }
                if (bl) break block20;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 147 + string);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDouble(String string, double d2) throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(d2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string2 = string.intern();
                String[] stringArray = this.osql.getParameterList();
                boolean bl = false;
                int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (stringArray[i2] != string2) continue;
                    this.setDouble(i2 + 1, d2);
                    bl = true;
                }
                if (bl) break block20;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 147 + string);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFloat(String string, float f2) throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(f2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string2 = string.intern();
                String[] stringArray = this.osql.getParameterList();
                boolean bl = false;
                int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (stringArray[i2] != string2) continue;
                    this.setFloat(i2 + 1, f2);
                    bl = true;
                }
                if (bl) break block20;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 147 + string);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInt(String string, int n2) throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string2 = string.intern();
                String[] stringArray = this.osql.getParameterList();
                boolean bl = false;
                int n3 = Math.min(this.osql.getParameterCount(), stringArray.length);
                for (int i2 = 0; i2 < n3; ++i2) {
                    if (stringArray[i2] != string2) continue;
                    this.setInt(i2 + 1, n2);
                    bl = true;
                }
                if (bl) break block20;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 147 + string);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLong(String string, long l2) throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(l2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string2 = string.intern();
                String[] stringArray = this.osql.getParameterList();
                boolean bl = false;
                int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (stringArray[i2] != string2) continue;
                    this.setLong(i2 + 1, l2);
                    bl = true;
                }
                if (bl) break block20;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 147 + string);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNClob(String string, NClob nClob) throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(nClob));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string2 = string.intern();
                String[] stringArray = this.osql.getParameterList();
                boolean bl = false;
                int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (stringArray[i2] != string2) continue;
                    this.setNClob(i2 + 1, nClob);
                    bl = true;
                }
                if (bl) break block20;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 147 + string);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNString(String string, String string2) throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(string2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string3 = string.intern();
                String[] stringArray = this.osql.getParameterList();
                boolean bl = false;
                int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (stringArray[i2] != string3) continue;
                    this.setNString(i2 + 1, string2);
                    bl = true;
                }
                if (bl) break block20;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 147 + string);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObject(String string, Object object) throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(object));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string2 = string.intern();
                String[] stringArray = this.osql.getParameterList();
                boolean bl = false;
                int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (stringArray[i2] != string2) continue;
                    this.setObject(i2 + 1, object);
                    bl = true;
                }
                if (bl) break block20;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 147 + string);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObject(String string, Object object, int n2) throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(object) + ", " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string2 = string.intern();
                String[] stringArray = this.osql.getParameterList();
                boolean bl = false;
                int n3 = Math.min(this.osql.getParameterCount(), stringArray.length);
                for (int i2 = 0; i2 < n3; ++i2) {
                    if (stringArray[i2] != string2) continue;
                    this.setObject(i2 + 1, object, n2);
                    bl = true;
                }
                if (bl) break block20;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 147 + string);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRef(String string, Ref ref) throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(ref));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string2 = string.intern();
                String[] stringArray = this.osql.getParameterList();
                boolean bl = false;
                int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (stringArray[i2] != string2) continue;
                    this.setRef(i2 + 1, ref);
                    bl = true;
                }
                if (bl) break block20;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 147 + string);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRowId(String string, RowId rowId) throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(rowId));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string2 = string.intern();
                String[] stringArray = this.osql.getParameterList();
                boolean bl = false;
                int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (stringArray[i2] != string2) continue;
                    this.setRowId(i2 + 1, rowId);
                    bl = true;
                }
                if (bl) break block20;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 147 + string);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setShort(String string, short s2) throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(s2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string2 = string.intern();
                String[] stringArray = this.osql.getParameterList();
                boolean bl = false;
                int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (stringArray[i2] != string2) continue;
                    this.setShort(i2 + 1, s2);
                    bl = true;
                }
                if (bl) break block20;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 147 + string);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSQLXML(String string, SQLXML sQLXML) throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(sQLXML));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string2 = string.intern();
                String[] stringArray = this.osql.getParameterList();
                boolean bl = false;
                int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (stringArray[i2] != string2) continue;
                    this.setSQLXML(i2 + 1, sQLXML);
                    bl = true;
                }
                if (bl) break block20;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 147 + string);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setString(String string, String string2) throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(string2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string3 = string.intern();
                String[] stringArray = this.osql.getParameterList();
                boolean bl = false;
                int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (stringArray[i2] != string3) continue;
                    this.setString(i2 + 1, string2);
                    bl = true;
                }
                if (bl) break block20;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 147 + string);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTime(String string, Time time) throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(time));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string2 = string.intern();
                String[] stringArray = this.osql.getParameterList();
                boolean bl = false;
                int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (stringArray[i2] != string2) continue;
                    this.setTime(i2 + 1, time);
                    bl = true;
                }
                if (bl) break block20;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 147 + string);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(time) + ", " + OracleLog.argument(calendar));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string2 = string.intern();
                String[] stringArray = this.osql.getParameterList();
                boolean bl = false;
                int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (stringArray[i2] != string2) continue;
                    this.setTime(i2 + 1, time, calendar);
                    bl = true;
                }
                if (bl) break block20;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 147 + string);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(timestamp));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string2 = string.intern();
                String[] stringArray = this.osql.getParameterList();
                boolean bl = false;
                int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (stringArray[i2] != string2) continue;
                    this.setTimestamp(i2 + 1, timestamp);
                    bl = true;
                }
                if (bl) break block20;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 147 + string);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(timestamp) + ", " + OracleLog.argument(calendar));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string2 = string.intern();
                String[] stringArray = this.osql.getParameterList();
                boolean bl = false;
                int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (stringArray[i2] != string2) continue;
                    this.setTimestamp(i2 + 1, timestamp, calendar);
                    bl = true;
                }
                if (bl) break block20;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 147 + string);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setURL(String string, URL uRL) throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(uRL));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string2 = string.intern();
                String[] stringArray = this.osql.getParameterList();
                boolean bl = false;
                int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (stringArray[i2] != string2) continue;
                    this.setURL(i2 + 1, uRL);
                    bl = true;
                }
                if (bl) break block20;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 147 + string);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlob(String string, InputStream inputStream) throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(inputStream));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string2 = string.intern();
                String[] stringArray = this.osql.getParameterList();
                boolean bl = false;
                int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (stringArray[i2] != string2) continue;
                    this.setBlob(i2 + 1, inputStream);
                    bl = true;
                }
                if (bl) break block20;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 147 + string);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlob(String string, InputStream inputStream, long l2) throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(inputStream) + ", " + OracleLog.argument(l2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string2 = string.intern();
                String[] stringArray = this.osql.getParameterList();
                boolean bl = false;
                int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (stringArray[i2] != string2) continue;
                    this.setBlob(i2 + 1, inputStream, l2);
                    bl = true;
                }
                if (bl) break block20;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 147 + string);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClob(String string, Reader reader) throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(reader));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string2 = string.intern();
                String[] stringArray = this.osql.getParameterList();
                boolean bl = false;
                int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (stringArray[i2] != string2) continue;
                    this.setClob(i2 + 1, reader);
                    bl = true;
                }
                if (bl) break block20;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 147 + string);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClob(String string, Reader reader, long l2) throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(reader) + ", " + OracleLog.argument(l2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string2 = string.intern();
                String[] stringArray = this.osql.getParameterList();
                boolean bl = false;
                int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (stringArray[i2] != string2) continue;
                    this.setClob(i2 + 1, reader, l2);
                    bl = true;
                }
                if (bl) break block20;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 147 + string);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNClob(String string, Reader reader) throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(reader));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string2 = string.intern();
                String[] stringArray = this.osql.getParameterList();
                boolean bl = false;
                int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (stringArray[i2] != string2) continue;
                    this.setNClob(i2 + 1, reader);
                    bl = true;
                }
                if (bl) break block20;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 147 + string);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNClob(String string, Reader reader, long l2) throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(reader) + ", " + OracleLog.argument(l2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string2 = string.intern();
                String[] stringArray = this.osql.getParameterList();
                boolean bl = false;
                int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (stringArray[i2] != string2) continue;
                    this.setNClob(i2 + 1, reader, l2);
                    bl = true;
                }
                if (bl) break block20;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 147 + string);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAsciiStream(String string, InputStream inputStream) throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(inputStream));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string2 = string.intern();
                String[] stringArray = this.osql.getParameterList();
                boolean bl = false;
                int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (stringArray[i2] != string2) continue;
                    this.setAsciiStream(i2 + 1, inputStream);
                    bl = true;
                }
                if (bl) break block20;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 147 + string);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAsciiStream(String string, InputStream inputStream, int n2) throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(inputStream) + ", " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string2 = string.intern();
                String[] stringArray = this.osql.getParameterList();
                boolean bl = false;
                int n3 = Math.min(this.osql.getParameterCount(), stringArray.length);
                for (int i2 = 0; i2 < n3; ++i2) {
                    if (stringArray[i2] != string2) continue;
                    this.setAsciiStream(i2 + 1, inputStream, n2);
                    bl = true;
                }
                if (bl) break block20;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 147 + string);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAsciiStream(String string, InputStream inputStream, long l2) throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(inputStream) + ", " + OracleLog.argument(l2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string2 = string.intern();
                String[] stringArray = this.osql.getParameterList();
                boolean bl = false;
                int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (stringArray[i2] != string2) continue;
                    this.setAsciiStream(i2 + 1, inputStream, l2);
                    bl = true;
                }
                if (bl) break block20;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 147 + string);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryStream(String string, InputStream inputStream) throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(inputStream));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string2 = string.intern();
                String[] stringArray = this.osql.getParameterList();
                boolean bl = false;
                int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (stringArray[i2] != string2) continue;
                    this.setBinaryStream(i2 + 1, inputStream);
                    bl = true;
                }
                if (bl) break block20;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 147 + string);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryStream(String string, InputStream inputStream, int n2) throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(inputStream) + ", " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string2 = string.intern();
                String[] stringArray = this.osql.getParameterList();
                boolean bl = false;
                int n3 = Math.min(this.osql.getParameterCount(), stringArray.length);
                for (int i2 = 0; i2 < n3; ++i2) {
                    if (stringArray[i2] != string2) continue;
                    this.setBinaryStream(i2 + 1, inputStream, n2);
                    bl = true;
                }
                if (bl) break block20;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 147 + string);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBinaryStream(String string, InputStream inputStream, long l2) throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(inputStream) + ", " + OracleLog.argument(l2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string2 = string.intern();
                String[] stringArray = this.osql.getParameterList();
                boolean bl = false;
                int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (stringArray[i2] != string2) continue;
                    this.setBinaryStream(i2 + 1, inputStream, l2);
                    bl = true;
                }
                if (bl) break block20;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 147 + string);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCharacterStream(String string, Reader reader) throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(reader));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string2 = string.intern();
                String[] stringArray = this.osql.getParameterList();
                boolean bl = false;
                int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (stringArray[i2] != string2) continue;
                    this.setCharacterStream(i2 + 1, reader);
                    bl = true;
                }
                if (bl) break block20;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 147 + string);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCharacterStream(String string, Reader reader, int n2) throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(reader) + ", " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string2 = string.intern();
                String[] stringArray = this.osql.getParameterList();
                boolean bl = false;
                int n3 = Math.min(this.osql.getParameterCount(), stringArray.length);
                for (int i2 = 0; i2 < n3; ++i2) {
                    if (stringArray[i2] != string2) continue;
                    this.setCharacterStream(i2 + 1, reader, n2);
                    bl = true;
                }
                if (bl) break block20;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 147 + string);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCharacterStream(String string, Reader reader, long l2) throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(reader) + ", " + OracleLog.argument(l2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string2 = string.intern();
                String[] stringArray = this.osql.getParameterList();
                boolean bl = false;
                int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (stringArray[i2] != string2) continue;
                    this.setCharacterStream(i2 + 1, reader, l2);
                    bl = true;
                }
                if (bl) break block20;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 147 + string);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNCharacterStream(String string, Reader reader) throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(reader));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string2 = string.intern();
                String[] stringArray = this.osql.getParameterList();
                boolean bl = false;
                int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (stringArray[i2] != string2) continue;
                    this.setNCharacterStream(i2 + 1, reader);
                    bl = true;
                }
                if (bl) break block20;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 147 + string);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNCharacterStream(String string, Reader reader, long l2) throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(reader) + ", " + OracleLog.argument(l2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string2 = string.intern();
                String[] stringArray = this.osql.getParameterList();
                boolean bl = false;
                int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (stringArray[i2] != string2) continue;
                    this.setNCharacterStream(i2 + 1, reader, l2);
                    bl = true;
                }
                if (bl) break block20;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 147 + string);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUnicodeStream(String string, InputStream inputStream, int n2) throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(inputStream) + ", " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string2 = string.intern();
                String[] stringArray = this.osql.getParameterList();
                boolean bl = false;
                int n3 = Math.min(this.osql.getParameterCount(), stringArray.length);
                for (int i2 = 0; i2 < n3; ++i2) {
                    if (stringArray[i2] != string2) continue;
                    this.setUnicodeStream(i2 + 1, inputStream, n2);
                    bl = true;
                }
                if (bl) break block20;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 147 + string);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNull(String string, int n2) throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string2 = string.intern();
                String[] stringArray = this.osql.getParameterList();
                boolean bl = false;
                int n3 = Math.min(this.osql.getParameterCount(), stringArray.length);
                for (int i2 = 0; i2 < n3; ++i2) {
                    if (stringArray[i2] != string2) continue;
                    this.setNull(i2 + 1, n2);
                    bl = true;
                }
                if (bl) break block20;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 147 + string);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNull(String string, int n2, String string2) throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(n2) + ", " + OracleLog.argument(string2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string3 = string.intern();
                String[] stringArray = this.osql.getParameterList();
                boolean bl = false;
                int n3 = Math.min(this.osql.getParameterCount(), stringArray.length);
                for (int i2 = 0; i2 < n3; ++i2) {
                    if (stringArray[i2] != string3) continue;
                    this.setNull(i2 + 1, n2, string2);
                    bl = true;
                }
                if (bl) break block20;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 147 + string);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObject(String string, Object object, int n2, int n3) throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(object) + ", " + OracleLog.argument(n2) + ", " + OracleLog.argument(n3));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string2 = string.intern();
                String[] stringArray = this.osql.getParameterList();
                boolean bl = false;
                int n4 = Math.min(this.osql.getParameterCount(), stringArray.length);
                for (int i2 = 0; i2 < n4; ++i2) {
                    if (stringArray[i2] != string2) continue;
                    this.setObject(i2 + 1, object, n2, n3);
                    bl = true;
                }
                if (bl) break block20;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 147 + string);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAsciiStream(int n2, InputStream inputStream) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(inputStream));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateAsciiStream(n2, inputStream, Integer.MAX_VALUE);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAsciiStream(int n2, InputStream inputStream, long l2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(inputStream) + ", " + OracleLog.argument(l2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateAsciiStream(n2, inputStream, (int)l2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(inputStream));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateAsciiStream(this.getColumnIndex(string), inputStream);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(inputStream) + ", " + OracleLog.argument(l2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateAsciiStream(this.getColumnIndex(string), inputStream, l2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBinaryStream(int n2, InputStream inputStream) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(inputStream));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateBinaryStream(n2, inputStream, Integer.MAX_VALUE);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBinaryStream(int n2, InputStream inputStream, long l2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(inputStream) + ", " + OracleLog.argument(l2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateBinaryStream(n2, inputStream, (int)l2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(inputStream));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateBinaryStream(this.getColumnIndex(string), inputStream);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(inputStream) + ", " + OracleLog.argument(l2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateBinaryStream(this.getColumnIndex(string), inputStream, l2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBlob(int n2, InputStream inputStream) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(inputStream));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateBinaryStream(n2, inputStream);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBlob(int n2, InputStream inputStream, long l2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(inputStream) + ", " + OracleLog.argument(l2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateBinaryStream(n2, inputStream, l2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(inputStream));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateBlob(this.getColumnIndex(string), inputStream);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBlob(String string, InputStream inputStream, long l2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(inputStream) + ", " + OracleLog.argument(l2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateBlob(this.getColumnIndex(string), inputStream, l2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCharacterStream(int n2, Reader reader) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(reader));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateCharacterStream(n2, reader, Integer.MAX_VALUE);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(reader) + ", " + OracleLog.argument(l2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateCharacterStream(n2, reader, (int)l2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(reader));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateCharacterStream(this.getColumnIndex(string), reader);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCharacterStream(String string, Reader reader, long l2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(reader) + ", " + OracleLog.argument(l2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateCharacterStream(this.getColumnIndex(string), reader, l2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateClob(int n2, Reader reader) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(reader));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateCharacterStream(n2, reader);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateClob(int n2, Reader reader, long l2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(reader) + ", " + OracleLog.argument(l2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateCharacterStream(n2, reader, l2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(reader));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateClob(this.getColumnIndex(string), reader);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateClob(String string, Reader reader, long l2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(reader) + ", " + OracleLog.argument(l2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateClob(this.getColumnIndex(string), reader, l2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNCharacterStream(int n2, Reader reader) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(reader));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateNCharacterStream(n2, reader, Integer.MAX_VALUE);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(reader) + ", " + OracleLog.argument(l2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateCharacterStreamInternal(n2, reader, (int)l2, true);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(reader));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateNCharacterStream(this.getColumnIndex(string), reader);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNCharacterStream(String string, Reader reader, long l2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(reader) + ", " + OracleLog.argument(l2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateNCharacterStream(this.getColumnIndex(string), reader, l2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNClob(int n2, NClob nClob) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(nClob));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateObject(n2, (Object)new OracleSerialClob(nClob));
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNClob(int n2, Reader reader) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(reader));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateClob(n2, (Clob)new OracleSerialClob(reader));
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNClob(int n2, Reader reader, long l2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(reader) + ", " + OracleLog.argument(l2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateClob(n2, (Clob)new OracleSerialClob(reader, l2));
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNClob(String string, NClob nClob) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(nClob));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateNClob(this.getColumnIndex(string), nClob);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNClob(String string, Reader reader) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(reader));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateNClob(this.getColumnIndex(string), reader);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNClob(String string, Reader reader, long l2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(reader) + ", " + OracleLog.argument(l2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateNClob(this.getColumnIndex(string), reader, l2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNString(int n2, String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateObject(n2, (Object)string);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNString(String string, String string2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(string2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateNString(this.getColumnIndex(string), string2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRowId(int n2, RowId rowId) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(rowId));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateObject(n2, (Object)rowId);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRowId(String string, RowId rowId) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(rowId));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateRowId(this.getColumnIndex(string), rowId);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSQLXML(int n2, SQLXML sQLXML) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(sQLXML));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateObject(n2, (Object)sQLXML);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(sQLXML));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateSQLXML(this.getColumnIndex(string), sQLXML);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.rowset");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.rowset.OracleCachedRowSet"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

