/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.pool.OracleConnectionCacheManager;
import oracle.ons.Notification;
import oracle.ons.ONSException;
import oracle.ons.Subscriber;
import oracle.ons.SubscriptionException;

class OracleFailoverEventHandlerThread
extends Thread {
    private Notification event = null;
    private OracleConnectionCacheManager cacheManager = OracleConnectionCacheManager.getConnectionCacheManagerInstance();
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Jun_28_00:48:08_PDT_2012";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    OracleFailoverEventHandlerThread() throws SQLException {
    }

    @Override
    public void run() {
        Subscriber subscriber = null;
        while (this.cacheManager.failoverEnabledCacheExists()) {
            try {
                subscriber = (Subscriber)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object run() {
                        try {
                            return new Subscriber("(%\"eventType=database/event/service\")|(%\"eventType=database/event/host\")", "", 30000L);
                        }
                        catch (SubscriptionException subscriptionException) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleFailoverEventHandlerThread.logger().log(Level.WARNING, Integer.toHexString(this.hashCode()).toUpperCase() + " Warning: " + " exception " + subscriptionException.getMessage());
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            return null;
                        }
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                // empty catch block
            }
            if (subscriber != null) {
                try {
                    while (this.cacheManager.failoverEnabledCacheExists()) {
                        this.event = subscriber.receive(true);
                        if (this.event == null) continue;
                        this.handleEvent(this.event);
                    }
                }
                catch (ONSException oNSException) {
                    subscriber.close();
                }
            }
            try {
                Thread.currentThread();
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    void handleEvent(Notification notification) {
        try {
            int n2 = 0;
            if (notification.type().equalsIgnoreCase("database/event/service")) {
                n2 = 256;
            } else if (notification.type().equalsIgnoreCase("database/event/host")) {
                n2 = 512;
            }
            if (n2 != 0) {
                this.cacheManager.verifyAndHandleEvent(n2, notification.body());
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.pool");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.pool.OracleFailoverEventHandlerThread"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

