/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;

class T4CTypeRep {
    static final byte REPUNV = 1;
    static final byte REPBUNV = 1;
    static final byte REPCUNV = 1;
    static final byte REPCASC = 10;
    static final byte REPCEBC = 11;
    static final byte REPIUNV = 1;
    static final byte REPIT11 = 10;
    static final byte REPIT12_OLD = 11;
    static final byte REPIT14_OLD = 12;
    static final byte REPIU11 = 13;
    static final byte REPIU12_OLD = 14;
    static final byte REPIU14_OLD = 15;
    static final byte REPIT21_OLD = 16;
    static final byte REPIT41_OLD = 17;
    static final byte REPIU21_OLD = 18;
    static final byte REPIU41_OLD = 19;
    static final byte REPIT32_OLD = 20;
    static final byte REPIU32_OLD = 21;
    static final byte REPIT12 = 22;
    static final byte REPIT14 = 23;
    static final byte REPIU12 = 24;
    static final byte REPIU14 = 25;
    static final byte REPIT21 = 26;
    static final byte REPIT41 = 27;
    static final byte REPIU21 = 28;
    static final byte REPIU41 = 29;
    static final byte REPIT32 = 30;
    static final byte REPIU32 = 31;
    static final byte REPIT18 = 32;
    static final byte REPIU18 = 33;
    static final byte REPIT81 = 34;
    static final byte REPIU81 = 35;
    static final byte REPAUNV = 1;
    static final byte REPA4Z = 10;
    static final byte REPA2Z = 11;
    static final byte REPA8Z = 12;
    static final byte REPA16Z = 13;
    static final byte REPNV51 = 10;
    static final byte REPDV51 = 10;
    static final byte REPRUNV = 1;
    static final byte NATIVE = 0;
    static final byte UNIVERSAL = 1;
    static final byte LSB = 2;
    static final byte MAXREP = 3;
    static final byte B1 = 0;
    static final byte B2 = 1;
    static final byte B4 = 2;
    static final byte B8 = 3;
    static final byte PTR = 4;
    static final byte MAXTYPE = 4;
    byte[] rep;
    final byte NUMREPS = (byte)5;
    byte conversionFlags = 0;
    boolean serverConversion = false;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Jun_28_00:48:08_PDT_2012";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    T4CTypeRep() {
        this.rep = new byte[5];
        this.rep[0] = 0;
        this.rep[1] = 1;
        this.rep[2] = 1;
        this.rep[3] = 1;
        this.rep[4] = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRep(byte by, byte by2) throws SQLException {
        if (by < 0 || by > 4 || by2 > 3) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTypeRep.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 407);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 407);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.rep[by] = by2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte getRep(byte by) throws SQLException {
        if (by < 0 || by > 4) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTypeRep.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 408);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 408);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.rep[by];
    }

    void setFlags(byte by) {
        this.conversionFlags = by;
    }

    byte getFlags() {
        return this.conversionFlags;
    }

    boolean isConvNeeded() {
        boolean bl = (this.conversionFlags & 2) > 0;
        return bl;
    }

    void setServerConversion(boolean bl) {
        this.serverConversion = bl;
    }

    boolean isServerConversion() {
        return this.serverConversion;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CTypeRep"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

