/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T4CConnection;

class T4CInputStream
extends OracleInputStream {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Jun_28_00:48:08_PDT_2012";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    T4CInputStream(OracleStatement oracleStatement, int n2, Accessor accessor) {
        super(oracleStatement, n2, accessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNull() throws IOException {
        if (!this.statement.connection.useFetchSizeWithLongColumn) {
            return super.isNull();
        }
        boolean bl = false;
        try {
            int n2 = this.statement.currentRow;
            if (n2 < 0) {
                n2 = 0;
            }
            if (n2 >= this.statement.validRows) {
                return true;
            }
            bl = this.accessor.isNull(n2);
        }
        catch (SQLException sQLException) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CInputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + sQLException);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            IOException iOException = DatabaseError.createIOException(sQLException);
            iOException.fillInStackTrace();
            throw iOException;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBytes(int n2) throws IOException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            int n3 = -1;
            try {
                if (this.statement.connection.lifecycle == 1 || this.statement.connection.lifecycle == 2) {
                    n3 = this.accessor.readStream(this.resizableBuffer, this.initialBufferSize);
                }
            }
            catch (SQLException sQLException) {
                throw new IOException(sQLException.getMessage());
            }
            catch (IOException iOException) {
                try {
                    ((T4CConnection)this.statement.connection).handleIOException(iOException);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw iOException;
            }
            return n3;
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CInputStream"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

