/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;

class PlsqlIbtBindInfo {
    Object[] arrayData;
    int maxLen;
    int curLen;
    int element_internal_type;
    int elemMaxLen;
    int ibtByteLength;
    int ibtCharLength;
    int ibtValueIndex;
    int ibtIndicatorIndex;
    int ibtLengthIndex;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Jun_28_00:48:08_PDT_2012";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PlsqlIbtBindInfo(Object[] objectArray, int n2, int n3, int n4, int n5) throws SQLException {
        this.arrayData = objectArray;
        this.maxLen = n2;
        this.curLen = n3;
        this.element_internal_type = n4;
        switch (n4) {
            case 1: 
            case 96: {
                this.elemMaxLen = n5 == 0 ? 2 : n5 + 1;
                this.ibtCharLength = this.elemMaxLen * n2;
                this.element_internal_type = 9;
                break;
            }
            case 6: {
                this.elemMaxLen = 22;
                this.ibtByteLength = this.elemMaxLen * n2;
                break;
            }
            default: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PlsqlIbtBindInfo.logger().log(Level.SEVERE, "         Throwing SQLException: 97");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(null, 97);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.PlsqlIbtBindInfo"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

