/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.driver.BaseResultSet;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleResultSetMetaData;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

class OracleResultSetImpl
extends BaseResultSet {
    PhysicalConnection connection;
    OracleStatement statement;
    boolean explicitly_closed;
    boolean m_emptyRset;
    boolean isServerCursorPeeked = false;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Jun_28_00:48:08_PDT_2012";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    OracleResultSetImpl(PhysicalConnection physicalConnection, OracleStatement oracleStatement) throws SQLException {
        this.connection = physicalConnection;
        this.statement = oracleStatement;
        this.close_statement_on_close = false;
        this.explicitly_closed = false;
        this.m_emptyRset = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCursorName() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 23 + "getCursorName");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23, "getCursorName");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.internal_close(false);
                this.statement.totalRowsVisited = 0;
                if (this.close_statement_on_close) {
                    try {
                        this.statement.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                this.explicitly_closed = true;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean wasNull() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            boolean bl;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.explicitly_closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 10 + "wasNull");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "wasNull");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (this.statement.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9 + "wasNull");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "wasNull");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                boolean bl2 = this.statement.wasNullValue();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bl = bl2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetMetaData oracleResultSetMetaData;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.explicitly_closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 10 + "getMetaData");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getMetaData");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (this.statement.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9 + "getMetaData");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getMetaData");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (!this.statement.isOpen) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 144 + "getMetaData");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 144, "getMetaData");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                OracleResultSetMetaData oracleResultSetMetaData2 = new OracleResultSetMetaData(this.connection, this.statement);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + oracleResultSetMetaData2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                oracleResultSetMetaData = oracleResultSetMetaData2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return oracleResultSetMetaData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statement getStatement() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            oracle.jdbc.internal.OracleStatement oracleStatement;
            try {
                oracle.jdbc.internal.OracleStatement oracleStatement2;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                oracle.jdbc.internal.OracleStatement oracleStatement3 = oracleStatement2 = this.statement.wrapper == null ? this.statement : this.statement.wrapper;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + oracleStatement2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                oracleStatement = oracleStatement2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return oracleStatement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    OracleStatement getOracleStatement() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return this.statement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean next() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = true;
                PhysicalConnection physicalConnection2 = this.statement.connection;
                if (this.explicitly_closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 10 + "next");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "next");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (physicalConnection2 == null || physicalConnection2.lifecycle != 1) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 8 + "next");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "next");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (this.statement.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9 + "next");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "next");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (this.statement.sqlKind.isPlsqlOrCall()) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 166 + "next");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 166, "next");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    boolean bl2 = false;
                    return bl2;
                }
                ++this.statement.currentRow;
                ++this.statement.totalRowsVisited;
                if (this.statement.maxRows != 0 && this.statement.totalRowsVisited > this.statement.maxRows) {
                    this.internal_close(false);
                    --this.statement.currentRow;
                    --this.statement.totalRowsVisited;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    boolean bl3 = false;
                    return bl3;
                }
                if (this.statement.currentRow >= this.statement.validRows) {
                    bl = this.close_or_fetch_from_next(false);
                }
                if (bl && physicalConnection2.useFetchSizeWithLongColumn) {
                    this.statement.reopenStreams();
                }
                if (!bl) {
                    --this.statement.currentRow;
                    --this.statement.totalRowsVisited;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl4 = bl;
                return bl4;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean close_or_fetch_from_next(boolean bl) throws SQLException {
        if (bl) {
            this.internal_close(false);
            return false;
        }
        long l2 = 0L;
        if (this.statement.dmsFetch != null) {
            l2 = this.statement.dmsFetch.start();
        }
        try {
            this.statement.connection.updateSystemContext();
            if (this.statement.gotLastBatch) {
                this.internal_close(false);
                boolean bl2 = false;
                return bl2;
            }
            this.statement.check_row_prefetch_changed();
            PhysicalConnection physicalConnection = this.statement.connection;
            if (physicalConnection.protocolId == 3) {
                this.sqlWarning = null;
            } else {
                if (this.statement.streamList != null) {
                    while (this.statement.nextStream != null) {
                        try {
                            this.statement.nextStream.close();
                        }
                        catch (IOException iOException) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + iOException);
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                            sQLException.fillInStackTrace();
                            throw sQLException;
                        }
                        this.statement.nextStream = this.statement.nextStream.nextStream;
                    }
                }
                this.clearWarnings();
                physicalConnection.registerHeartbeat();
                physicalConnection.needLine();
            }
            PhysicalConnection physicalConnection2 = physicalConnection;
            synchronized (physicalConnection2) {
                try {
                    this.statement.cancelLock.enterExecuting();
                    this.statement.fetch();
                }
                finally {
                    this.statement.cancelLock.exitExecuting();
                }
            }
            if (this.statement.validRows == 0) {
                this.internal_close(false);
                boolean bl3 = false;
                return bl3;
            }
            this.statement.currentRow = 0;
            this.statement.checkValidRowsStatus();
            boolean bl4 = true;
            return bl4;
        }
        finally {
            if (this.statement.dmsFetch != null) {
                this.statement.dmsFetch.stop(l2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBeforeFirst() throws SQLException {
        try {
            boolean bl;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.explicitly_closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 10);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.connection.protocolId == 3 && this.statement.serverCursor) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + "");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createUnsupportedFeatureSqlException();
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            boolean bl2 = bl = !this.isEmptyResultSet() && this.statement.currentRow == -1 && !this.closed;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl3 = bl;
            return bl3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAfterLast() throws SQLException {
        try {
            boolean bl;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.explicitly_closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 10);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            boolean bl2 = bl = !this.isEmptyResultSet() && this.closed;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl3 = bl;
            return bl3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFirst() throws SQLException {
        try {
            boolean bl;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.explicitly_closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 10);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            boolean bl2 = bl = this.getRow() == 1;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl3 = bl;
            return bl3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLast() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.explicitly_closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 10);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 75 + "isLast");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 75, "isLast");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRow() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.explicitly_closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 10);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n2 = this.statement.totalRowsVisited;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n2);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n3 = n2;
            return n3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Array getArray(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            ARRAY aRRAY;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                ARRAY aRRAY2 = this.getARRAY(n2);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + aRRAY2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                aRRAY = aRRAY2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return aRRAY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            BigDecimal bigDecimal;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n3 = this.statement.currentRow;
                if (n3 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.statement.lastIndex = n2;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(n2);
                }
                BigDecimal bigDecimal2 = this.statement.accessors[n2 - 1].getBigDecimal(n3);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bigDecimal2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bigDecimal = bigDecimal2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bigDecimal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            BigDecimal bigDecimal;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(n3));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n4 = this.statement.currentRow;
                if (n4 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.statement.lastIndex = n2;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(n2);
                }
                BigDecimal bigDecimal2 = this.statement.accessors[n2 - 1].getBigDecimal(n4, n3);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bigDecimal2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bigDecimal = bigDecimal2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bigDecimal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob getBlob(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            BLOB bLOB;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                BLOB bLOB2 = this.getBLOB(n2);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bLOB2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bLOB = bLOB2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bLOB;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBoolean(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            boolean bl;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n3 = this.statement.currentRow;
                if (n3 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.statement.lastIndex = n2;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(n2);
                }
                boolean bl2 = this.statement.accessors[n2 - 1].getBoolean(n3);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bl = bl2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte getByte(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            byte by;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n3 = this.statement.currentRow;
                if (n3 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.statement.lastIndex = n2;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(n2);
                }
                byte by2 = this.statement.accessors[n2 - 1].getByte(n3);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + by2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                by = by2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return by;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            byte[] byArray;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n3 = this.statement.currentRow;
                if (n3 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.statement.lastIndex = n2;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(n2);
                }
                byte[] byArray2 = this.statement.accessors[n2 - 1].getBytes(n3);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + byArray2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byArray = byArray2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Clob getClob(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            CLOB cLOB;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                CLOB cLOB2 = this.getCLOB(n2);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + cLOB2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                cLOB = cLOB2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return cLOB;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Date date;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n3 = this.statement.currentRow;
                if (n3 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.statement.lastIndex = n2;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(n2);
                }
                Date date2 = this.statement.accessors[n2 - 1].getDate(n3);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + date2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                date = date2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return date;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(int n2, Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Date date;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(calendar));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n3 = this.statement.currentRow;
                if (n3 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.statement.lastIndex = n2;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(n2);
                }
                Date date2 = this.statement.accessors[n2 - 1].getDate(n3, calendar);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + date2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                date = date2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return date;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getDouble(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            double d2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n3 = this.statement.currentRow;
                if (n3 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.statement.lastIndex = n2;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(n2);
                }
                double d3 = this.statement.accessors[n2 - 1].getDouble(n3);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + d3);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                d2 = d3;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return d2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getFloat(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            float f2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n3 = this.statement.currentRow;
                if (n3 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.statement.lastIndex = n2;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(n2);
                }
                float f3 = this.statement.accessors[n2 - 1].getFloat(n3);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + f3);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                f2 = f3;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return f2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInt(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n3;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n4 = this.statement.currentRow;
                if (n4 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.statement.lastIndex = n2;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(n2);
                }
                int n5 = this.statement.accessors[n2 - 1].getInt(n4);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n5);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                n3 = n5;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLong(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long l2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n3 = this.statement.currentRow;
                if (n3 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.statement.lastIndex = n2;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(n2);
                }
                long l3 = this.statement.accessors[n2 - 1].getLong(n3);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + l3);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                l2 = l3;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NClob getNClob(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            NClob nClob;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n3 = this.statement.currentRow;
                if (n3 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.statement.lastIndex = n2;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(n2);
                }
                NClob nClob2 = this.statement.accessors[n2 - 1].getNClob(n3);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + nClob2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                nClob = nClob2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return nClob;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNString(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            String string;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n3 = this.statement.currentRow;
                if (n3 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.statement.lastIndex = n2;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(n2);
                }
                String string2 = this.statement.accessors[n2 - 1].getNString(n3);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + string2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                string = string2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Object object;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n3 = this.statement.currentRow;
                if (n3 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.statement.lastIndex = n2;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(n2);
                }
                Object object2 = this.statement.accessors[n2 - 1].getObject(n3);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                object = object2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int n2, Map map) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Object object;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(map));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n3 = this.statement.currentRow;
                if (n3 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.statement.lastIndex = n2;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(n2);
                }
                Object object2 = this.statement.accessors[n2 - 1].getObject(n3, map);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                object = object2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Ref getRef(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            REF rEF;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                REF rEF2 = this.getREF(n2);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + rEF2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                rEF = rEF2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return rEF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowId getRowId(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            ROWID rOWID;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                ROWID rOWID2 = this.getROWID(n2);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + rOWID2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                rOWID = rOWID2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return rOWID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getShort(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            short s2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n3 = this.statement.currentRow;
                if (n3 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.statement.lastIndex = n2;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(n2);
                }
                short s3 = this.statement.accessors[n2 - 1].getShort(n3);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + s3);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                s2 = s3;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return s2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLXML getSQLXML(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            SQLXML sQLXML;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n3 = this.statement.currentRow;
                if (n3 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.statement.lastIndex = n2;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(n2);
                }
                SQLXML sQLXML2 = this.statement.accessors[n2 - 1].getSQLXML(n3);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + sQLXML2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                sQLXML = sQLXML2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return sQLXML;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getString(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            String string;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n3 = this.statement.currentRow;
                if (n3 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.statement.lastIndex = n2;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(n2);
                }
                String string2 = this.statement.accessors[n2 - 1].getString(n3);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + string2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                string = string2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Time time;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n3 = this.statement.currentRow;
                if (n3 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.statement.lastIndex = n2;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(n2);
                }
                Time time2 = this.statement.accessors[n2 - 1].getTime(n3);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + time2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                time = time2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(int n2, Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Time time;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(calendar));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n3 = this.statement.currentRow;
                if (n3 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.statement.lastIndex = n2;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(n2);
                }
                Time time2 = this.statement.accessors[n2 - 1].getTime(n3, calendar);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + time2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                time = time2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Timestamp timestamp;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n3 = this.statement.currentRow;
                if (n3 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.statement.lastIndex = n2;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(n2);
                }
                Timestamp timestamp2 = this.statement.accessors[n2 - 1].getTimestamp(n3);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + timestamp2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                timestamp = timestamp2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return timestamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Timestamp timestamp;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(calendar));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n3 = this.statement.currentRow;
                if (n3 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.statement.lastIndex = n2;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(n2);
                }
                Timestamp timestamp2 = this.statement.accessors[n2 - 1].getTimestamp(n3, calendar);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + timestamp2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                timestamp = timestamp2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return timestamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getURL(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            URL uRL;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n3 = this.statement.currentRow;
                if (n3 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.statement.lastIndex = n2;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(n2);
                }
                URL uRL2 = this.statement.accessors[n2 - 1].getURL(n3);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + uRL2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                uRL = uRL2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return uRL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ARRAY getARRAY(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            ARRAY aRRAY;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n3 = this.statement.currentRow;
                if (n3 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.statement.lastIndex = n2;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(n2);
                }
                ARRAY aRRAY2 = this.statement.accessors[n2 - 1].getARRAY(n3);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + aRRAY2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                aRRAY = aRRAY2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return aRRAY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BFILE getBFILE(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            BFILE bFILE;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n3 = this.statement.currentRow;
                if (n3 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.statement.lastIndex = n2;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(n2);
                }
                BFILE bFILE2 = this.statement.accessors[n2 - 1].getBFILE(n3);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bFILE2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bFILE = bFILE2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bFILE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BFILE getBfile(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            BFILE bFILE;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                BFILE bFILE2 = this.getBFILE(n2);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bFILE2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bFILE = bFILE2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bFILE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BLOB getBLOB(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            BLOB bLOB;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n3 = this.statement.currentRow;
                if (n3 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.statement.lastIndex = n2;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(n2);
                }
                BLOB bLOB2 = this.statement.accessors[n2 - 1].getBLOB(n3);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bLOB2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bLOB = bLOB2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bLOB;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CHAR getCHAR(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            CHAR cHAR;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n3 = this.statement.currentRow;
                if (n3 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.statement.lastIndex = n2;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(n2);
                }
                CHAR cHAR2 = this.statement.accessors[n2 - 1].getCHAR(n3);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + cHAR2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                cHAR = cHAR2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return cHAR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CLOB getCLOB(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            CLOB cLOB;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n3 = this.statement.currentRow;
                if (n3 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.statement.lastIndex = n2;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(n2);
                }
                CLOB cLOB2 = this.statement.accessors[n2 - 1].getCLOB(n3);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + cLOB2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                cLOB = cLOB2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return cLOB;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getCursor(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            ResultSet resultSet;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n3 = this.statement.currentRow;
                if (n3 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.statement.lastIndex = n2;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(n2);
                }
                ResultSet resultSet2 = this.statement.accessors[n2 - 1].getCursor(n3);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + resultSet2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                resultSet = resultSet2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return resultSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CustomDatum getCustomDatum(int n2, CustomDatumFactory customDatumFactory) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            CustomDatum customDatum;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(customDatumFactory));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n3 = this.statement.currentRow;
                if (n3 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.statement.lastIndex = n2;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(n2);
                }
                CustomDatum customDatum2 = this.statement.accessors[n2 - 1].getCustomDatum(n3, customDatumFactory);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + customDatum2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                customDatum = customDatum2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return customDatum;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DATE getDATE(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            DATE dATE;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n3 = this.statement.currentRow;
                if (n3 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.statement.lastIndex = n2;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(n2);
                }
                DATE dATE2 = this.statement.accessors[n2 - 1].getDATE(n3);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + dATE2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                dATE = dATE2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return dATE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public INTERVALDS getINTERVALDS(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            INTERVALDS iNTERVALDS;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n3 = this.statement.currentRow;
                if (n3 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.statement.lastIndex = n2;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(n2);
                }
                INTERVALDS iNTERVALDS2 = this.statement.accessors[n2 - 1].getINTERVALDS(n3);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + iNTERVALDS2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                iNTERVALDS = iNTERVALDS2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return iNTERVALDS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public INTERVALYM getINTERVALYM(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            INTERVALYM iNTERVALYM;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n3 = this.statement.currentRow;
                if (n3 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.statement.lastIndex = n2;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(n2);
                }
                INTERVALYM iNTERVALYM2 = this.statement.accessors[n2 - 1].getINTERVALYM(n3);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + iNTERVALYM2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                iNTERVALYM = iNTERVALYM2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return iNTERVALYM;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NUMBER getNUMBER(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            NUMBER nUMBER;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n3 = this.statement.currentRow;
                if (n3 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.statement.lastIndex = n2;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(n2);
                }
                NUMBER nUMBER2 = this.statement.accessors[n2 - 1].getNUMBER(n3);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + nUMBER2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                nUMBER = nUMBER2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return nUMBER;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPAQUE getOPAQUE(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OPAQUE oPAQUE;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n3 = this.statement.currentRow;
                if (n3 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.statement.lastIndex = n2;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(n2);
                }
                OPAQUE oPAQUE2 = this.statement.accessors[n2 - 1].getOPAQUE(n3);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + oPAQUE2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                oPAQUE = oPAQUE2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return oPAQUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Datum getOracleObject(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n3 = this.statement.currentRow;
                if (n3 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.statement.lastIndex = n2;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(n2);
                }
                Datum datum2 = this.statement.accessors[n2 - 1].getOracleObject(n3);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + datum2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                datum = datum2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return datum;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ORAData getORAData(int n2, ORADataFactory oRADataFactory) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            ORAData oRAData;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(oRADataFactory));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n3 = this.statement.currentRow;
                if (n3 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.statement.lastIndex = n2;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(n2);
                }
                ORAData oRAData2 = this.statement.accessors[n2 - 1].getORAData(n3, oRADataFactory);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + oRAData2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                oRAData = oRAData2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return oRAData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int n2, OracleDataFactory oracleDataFactory) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Object object;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(oracleDataFactory));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n3 = this.statement.currentRow;
                if (n3 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.statement.lastIndex = n2;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(n2);
                }
                Object object2 = this.statement.accessors[n2 - 1].getObject(n3, oracleDataFactory);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                object = object2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RAW getRAW(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            RAW rAW;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n3 = this.statement.currentRow;
                if (n3 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.statement.lastIndex = n2;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(n2);
                }
                RAW rAW2 = this.statement.accessors[n2 - 1].getRAW(n3);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + rAW2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                rAW = rAW2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return rAW;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public REF getREF(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            REF rEF;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n3 = this.statement.currentRow;
                if (n3 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.statement.lastIndex = n2;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(n2);
                }
                REF rEF2 = this.statement.accessors[n2 - 1].getREF(n3);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + rEF2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                rEF = rEF2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return rEF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ROWID getROWID(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            ROWID rOWID;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n3 = this.statement.currentRow;
                if (n3 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.statement.lastIndex = n2;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(n2);
                }
                ROWID rOWID2 = this.statement.accessors[n2 - 1].getROWID(n3);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + rOWID2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                rOWID = rOWID2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return rOWID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public STRUCT getSTRUCT(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            STRUCT sTRUCT;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n3 = this.statement.currentRow;
                if (n3 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.statement.lastIndex = n2;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(n2);
                }
                STRUCT sTRUCT2 = this.statement.accessors[n2 - 1].getSTRUCT(n3);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + sTRUCT2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                sTRUCT = sTRUCT2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return sTRUCT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPLTZ getTIMESTAMPLTZ(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            TIMESTAMPLTZ tIMESTAMPLTZ;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n3 = this.statement.currentRow;
                if (n3 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.statement.lastIndex = n2;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(n2);
                }
                TIMESTAMPLTZ tIMESTAMPLTZ2 = this.statement.accessors[n2 - 1].getTIMESTAMPLTZ(n3);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + tIMESTAMPLTZ2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                tIMESTAMPLTZ = tIMESTAMPLTZ2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return tIMESTAMPLTZ;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPTZ getTIMESTAMPTZ(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            TIMESTAMPTZ tIMESTAMPTZ;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n3 = this.statement.currentRow;
                if (n3 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.statement.lastIndex = n2;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(n2);
                }
                TIMESTAMPTZ tIMESTAMPTZ2 = this.statement.accessors[n2 - 1].getTIMESTAMPTZ(n3);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + tIMESTAMPTZ2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                tIMESTAMPTZ = tIMESTAMPTZ2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return tIMESTAMPTZ;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMP getTIMESTAMP(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            TIMESTAMP tIMESTAMP;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n3 = this.statement.currentRow;
                if (n3 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.statement.lastIndex = n2;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(n2);
                }
                TIMESTAMP tIMESTAMP2 = this.statement.accessors[n2 - 1].getTIMESTAMP(n3);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + tIMESTAMP2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                tIMESTAMP = tIMESTAMP2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return tIMESTAMP;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getAsciiStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            InputStream inputStream;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n3 = this.statement.currentRow;
                if (n3 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.statement.lastIndex = n2;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(n2);
                }
                InputStream inputStream2 = this.statement.accessors[n2 - 1].getAsciiStream(n3);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + inputStream2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                inputStream = inputStream2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return inputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getBinaryStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            InputStream inputStream;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n3 = this.statement.currentRow;
                if (n3 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.statement.lastIndex = n2;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(n2);
                }
                InputStream inputStream2 = this.statement.accessors[n2 - 1].getBinaryStream(n3);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + inputStream2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                inputStream = inputStream2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return inputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getCharacterStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Reader reader;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n3 = this.statement.currentRow;
                if (n3 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.statement.lastIndex = n2;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(n2);
                }
                Reader reader2 = this.statement.accessors[n2 - 1].getCharacterStream(n3);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + reader2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                reader = reader2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return reader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getNCharacterStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Reader reader;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n3 = this.statement.currentRow;
                if (n3 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.statement.lastIndex = n2;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(n2);
                }
                Reader reader2 = this.statement.accessors[n2 - 1].getNCharacterStream(n3);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + reader2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                reader = reader2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return reader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getUnicodeStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            InputStream inputStream;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n3 = this.statement.currentRow;
                if (n3 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.statement.lastIndex = n2;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(n2);
                }
                InputStream inputStream2 = this.statement.accessors[n2 - 1].getUnicodeStream(n3);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + inputStream2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                inputStream = inputStream2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return inputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OracleResultSet.AuthorizationIndicator getAuthorizationIndicator(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSet.AuthorizationIndicator authorizationIndicator;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n3 = this.statement.currentRow;
                if (n3 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.statement.lastIndex = n2;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(n2);
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (Object)((Object)this.statement.accessors[n2 - 1].getAuthorizationIndicator(n3)));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                authorizationIndicator = this.statement.accessors[n2 - 1].getAuthorizationIndicator(n3);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return authorizationIndicator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] privateGetBytes(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = this.statement.currentRow;
            if (n3 < 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.statement.lastIndex = n2;
            if (this.statement.streamList != null) {
                this.statement.closeUsedStreams(n2);
            }
            return this.statement.accessors[n2 - 1].privateGetBytes(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFetchSize(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.statement.setPrefetchInternal(n2, false, false);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFetchSize() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.statement.getPrefetchInternal(false);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n2);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n3 = n2;
            return n3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internal_close(boolean bl) throws SQLException {
        if (this.closed) {
            return;
        }
        super.close();
        if (this.statement.gotLastBatch && this.statement.validRows == 0) {
            this.m_emptyRset = true;
        }
        PhysicalConnection physicalConnection = this.statement.connection;
        try {
            physicalConnection.registerHeartbeat();
            physicalConnection.needLine();
            PhysicalConnection physicalConnection2 = physicalConnection;
            synchronized (physicalConnection2) {
                this.statement.closeQuery();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.statement.endOfResultSet(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int findColumn(String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int n3 = this.statement.getColumnIndex(string);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n3);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                n2 = n3;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return n2;
        }
    }

    boolean isEmptyResultSet() throws SQLException {
        if (this.statement != null && !this.statement.closed && this.statement.serverCursor && this.statement.connection.protocolId != 3 && !this.isServerCursorPeeked && !this.closed) {
            this.close_or_fetch_from_next(false);
            if (this.statement.validRows > 0) {
                this.statement.currentRow = -1;
            } else {
                this.m_emptyRset = true;
            }
            this.isServerCursorPeeked = true;
        }
        return this.m_emptyRset || !this.m_emptyRset && this.statement.gotLastBatch && this.statement.validRows == 0;
    }

    int getValidRows() {
        return this.statement.validRows;
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OracleResultSetImpl"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

