/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.CLOB;

class OracleClobWriter
extends Writer {
    DBConversion dbConversion;
    CLOB clob;
    long lobOffset;
    char[] charBuf;
    byte[] nativeBuf;
    int pos;
    int count;
    int chunkSize;
    boolean isClosed;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Jun_28_00:48:08_PDT_2012";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    public OracleClobWriter(CLOB cLOB, int n2) throws SQLException {
        this(cLOB, n2, 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleClobWriter(CLOB cLOB, int n2, long l2) throws SQLException {
        if (cLOB == null || n2 <= 0 || cLOB.getJavaSqlConnection() == null || l2 < 1L) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobWriter.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IllegalArgumentException: " + "");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw new IllegalArgumentException();
        }
        this.dbConversion = ((PhysicalConnection)cLOB.getInternalConnection()).conversion;
        this.clob = cLOB;
        this.lobOffset = l2;
        this.charBuf = new char[n2];
        this.nativeBuf = new byte[n2 * 3];
        this.count = 0;
        this.pos = 0;
        this.chunkSize = n2;
        this.isClosed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cArray, int n2, int n3) throws IOException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleClobWriter.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(cArray) + ", " + OracleLog.argument(n2) + ", " + OracleLog.argument(n3));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object object = this.lock;
            synchronized (object) {
                int n4;
                int n5;
                block30: {
                    this.ensureOpen();
                    n5 = n2;
                    n4 = Math.min(n3, cArray.length - n2);
                    if (n4 < 2 * this.chunkSize) break block30;
                    if (this.count > 0) {
                        this.flushBuffer();
                    }
                    try {
                        this.lobOffset += (long)this.clob.putChars(this.lobOffset, cArray, n2, n4);
                    }
                    catch (SQLException sQLException) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleClobWriter.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + sQLException);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        IOException iOException = DatabaseError.createIOException(sQLException);
                        iOException.fillInStackTrace();
                        throw iOException;
                    }
                    return;
                }
                int n6 = n5 + n4;
                while (n5 < n6) {
                    int n7 = Math.min(this.chunkSize - this.count, n6 - n5);
                    System.arraycopy(cArray, n5, this.charBuf, this.count, n7);
                    n5 += n7;
                    this.count += n7;
                    if (this.count < this.chunkSize) continue;
                    this.flushBuffer();
                }
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobWriter.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleClobWriter.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                this.flushBuffer();
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobWriter.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleClobWriter.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object object = this.lock;
            synchronized (object) {
                this.flushBuffer();
                this.isClosed = true;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobWriter.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushBuffer() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.count > 0) {
                    this.lobOffset += (long)this.clob.putChars(this.lobOffset, this.charBuf, 0, this.count);
                    this.count = 0;
                }
            }
            catch (SQLException sQLException) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleClobWriter.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + sQLException);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                IOException iOException = DatabaseError.createIOException(sQLException);
                iOException.fillInStackTrace();
                throw iOException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureOpen() throws IOException {
        block10: {
            try {
                if (!this.isClosed) break block10;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleClobWriter.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 57 + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 57, null);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            catch (SQLException sQLException) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleClobWriter.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + sQLException);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                IOException iOException = DatabaseError.createIOException(sQLException);
                iOException.fillInStackTrace();
                throw iOException;
            }
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            return this.clob.getInternalConnection();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OracleClobWriter"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

