/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.dcn.RowChangeDescription;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.ROWID;

class NTFDCNRowChanges
implements RowChangeDescription {
    RowChangeDescription.RowOperation opcode;
    int rowidLength;
    byte[] rowid;
    ROWID rowidObj;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Jun_28_00:48:08_PDT_2012";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    NTFDCNRowChanges(RowChangeDescription.RowOperation rowOperation, int n2, byte[] byArray) {
        this.opcode = rowOperation;
        this.rowidLength = n2;
        this.rowid = byArray;
        this.rowidObj = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ROWID getRowid() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        NTFDCNRowChanges.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowidObj == null) {
                this.rowidObj = new ROWID(this.rowid);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        NTFDCNRowChanges.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.rowidObj);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ROWID rOWID = this.rowidObj;
            return rOWID;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNRowChanges.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    @Override
    public RowChangeDescription.RowOperation getRowOperation() {
        return this.opcode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        NTFDCNRowChanges.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("      ROW:  operation=" + (Object)((Object)this.getRowOperation()) + ", ROWID=" + new String(this.rowid) + "\n");
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        NTFDCNRowChanges.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + stringBuffer.toString());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = stringBuffer.toString();
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNRowChanges.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver.ntf");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.NTFDCNRowChanges"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

