/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OraclePreparedStatementWrapper;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;

class ArrayLocatorResultSet
extends OracleResultSetImpl {
    static int COUNT_UNLIMITED = -1;
    Map map;
    long beginIndex;
    int count;
    long currentIndex;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Jun_28_00:48:08_PDT_2012";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    public ArrayLocatorResultSet(OracleConnection oracleConnection, ArrayDescriptor arrayDescriptor, byte[] byArray, Map map) throws SQLException {
        this(oracleConnection, arrayDescriptor, byArray, 0L, COUNT_UNLIMITED, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayLocatorResultSet(OracleConnection oracleConnection, ArrayDescriptor arrayDescriptor, byte[] byArray, long l2, int n2, Map map) throws SQLException {
        super((PhysicalConnection)oracleConnection, null);
        if (arrayDescriptor == null || oracleConnection == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayLocatorResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1 + "Invalid arguments");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Invalid arguments");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.close_statement_on_close = true;
        this.count = n2;
        this.currentIndex = 0L;
        this.beginIndex = l2;
        this.map = map;
        OraclePreparedStatement oraclePreparedStatement = null;
        ARRAY aRRAY = new ARRAY(arrayDescriptor, oracleConnection, (Object)null);
        aRRAY.setLocator(byArray);
        oraclePreparedStatement = arrayDescriptor.getBaseType() == 2002 || arrayDescriptor.getBaseType() == 2008 ? (OraclePreparedStatement)((OraclePreparedStatementWrapper)oracleConnection.prepareStatement((String)new StringBuilder().append((String)"SELECT ROWNUM, SYS_NC_ROWINFO$ FROM TABLE( CAST(:1 AS ").append((String)arrayDescriptor.getName()).append((String)") )").toString())).preparedStatement : (OraclePreparedStatement)((OraclePreparedStatementWrapper)oracleConnection.prepareStatement((String)new StringBuilder().append((String)"SELECT ROWNUM, COLUMN_VALUE FROM TABLE( CAST(:1 AS ").append((String)arrayDescriptor.getName()).append((String)") )").toString())).preparedStatement;
        oraclePreparedStatement.setArray(1, aRRAY);
        oraclePreparedStatement.executeQuery();
        this.statement = oraclePreparedStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean next() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayLocatorResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.currentIndex < this.beginIndex) {
                    while (this.currentIndex < this.beginIndex) {
                        ++this.currentIndex;
                        if (super.next()) continue;
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                if (OracleLog.isPublic()) {
                                    ArrayLocatorResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                                }
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        boolean bl = false;
                        return bl;
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                ArrayLocatorResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    boolean bl = true;
                    return bl;
                }
                if (this.count == COUNT_UNLIMITED) {
                    boolean bl = super.next();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                ArrayLocatorResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    boolean bl2 = bl;
                    return bl2;
                }
                if (this.currentIndex < this.beginIndex + (long)this.count - 1L) {
                    ++this.currentIndex;
                    boolean bl = super.next();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                ArrayLocatorResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    boolean bl3 = bl;
                    return bl3;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ArrayLocatorResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = false;
                return bl;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayLocatorResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Object object;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayLocatorResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Object object2 = this.getObject(n2, this.map);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ArrayLocatorResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                object = object2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayLocatorResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayLocatorResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int findColumn(String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayLocatorResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (string.equalsIgnoreCase("index")) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                ArrayLocatorResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 1);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    int n2 = 1;
                    return n2;
                }
                if (string.equalsIgnoreCase("value")) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                ArrayLocatorResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 2);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    int n3 = 2;
                    return n3;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayLocatorResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6 + "get_column_index");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6, "get_column_index");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayLocatorResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.ArrayLocatorResultSet"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

