/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.connector;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.EISSystemException;
import javax.resource.spi.ManagedConnectionMetaData;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleDatabaseMetaData;
import oracle.jdbc.connector.OracleManagedConnection;
import oracle.jdbc.driver.OracleLog;

public class OracleManagedConnectionMetaData
implements ManagedConnectionMetaData {
    private OracleManagedConnection managedConnection = null;
    private OracleDatabaseMetaData databaseMetaData = null;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Jun_28_00:48:08_PDT_2012";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    OracleManagedConnectionMetaData(OracleManagedConnection oracleManagedConnection) throws ResourceException {
        try {
            this.managedConnection = oracleManagedConnection;
            OracleConnection oracleConnection = (OracleConnection)oracleManagedConnection.getPhysicalConnection();
            this.databaseMetaData = (OracleDatabaseMetaData)oracleConnection.getMetaData();
        }
        catch (Exception exception) {
            EISSystemException eISSystemException = new EISSystemException("Exception: " + exception.getMessage());
            eISSystemException.setLinkedException(exception);
            throw eISSystemException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEISProductName() throws ResourceException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleManagedConnectionMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            try {
                String string = this.databaseMetaData.getDatabaseProductName();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleManagedConnectionMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + string);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string2 = string;
                return string2;
            }
            catch (SQLException sQLException) {
                EISSystemException eISSystemException = new EISSystemException("SQLException: " + sQLException.getMessage());
                eISSystemException.setLinkedException((Exception)sQLException);
                throw eISSystemException;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleManagedConnectionMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEISProductVersion() throws ResourceException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleManagedConnectionMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            try {
                String string = this.databaseMetaData.getDatabaseProductVersion();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleManagedConnectionMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + string);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string2 = string;
                return string2;
            }
            catch (Exception exception) {
                EISSystemException eISSystemException = new EISSystemException("Exception: " + exception.getMessage());
                eISSystemException.setLinkedException(exception);
                throw eISSystemException;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleManagedConnectionMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxConnections() throws ResourceException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleManagedConnectionMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            try {
                int n2 = this.databaseMetaData.getMaxConnections();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleManagedConnectionMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int n3 = n2;
                return n3;
            }
            catch (SQLException sQLException) {
                EISSystemException eISSystemException = new EISSystemException("SQLException: " + sQLException.getMessage());
                eISSystemException.setLinkedException((Exception)sQLException);
                throw eISSystemException;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleManagedConnectionMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserName() throws ResourceException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleManagedConnectionMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            try {
                String string = this.databaseMetaData.getUserName();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleManagedConnectionMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + string);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string2 = string;
                return string2;
            }
            catch (SQLException sQLException) {
                EISSystemException eISSystemException = new EISSystemException("SQLException: " + sQLException.getMessage());
                eISSystemException.setLinkedException((Exception)sQLException);
                throw eISSystemException;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleManagedConnectionMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.connector");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.connector.OracleManagedConnectionMetaData"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

