/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.connector;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.EISSystemException;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.LocalTransactionException;
import oracle.jdbc.connector.OracleManagedConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;

public class OracleLocalTransaction
implements LocalTransaction {
    private OracleManagedConnection managedConnection = null;
    private Connection connection = null;
    boolean isBeginCalled = false;
    private static final String RAERR_LTXN_COMMIT = "commit without begin";
    private static final String RAERR_LTXN_ROLLBACK = "rollback without begin";
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Jun_28_00:48:08_PDT_2012";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    OracleLocalTransaction(OracleManagedConnection oracleManagedConnection) throws ResourceException {
        this.managedConnection = oracleManagedConnection;
        this.connection = oracleManagedConnection.getPhysicalConnection();
        this.isBeginCalled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin() throws ResourceException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleLocalTransaction.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            try {
                if (((OracleConnection)this.connection).getTxnMode() == 1) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleLocalTransaction.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IllegalStateException: " + "Could not start a new transaction inside an active transaction");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw new IllegalStateException("Could not start a new transaction inside an active transaction");
                }
                if (this.connection.getAutoCommit()) {
                    this.connection.setAutoCommit(false);
                }
                this.isBeginCalled = true;
            }
            catch (SQLException sQLException) {
                EISSystemException eISSystemException = new EISSystemException("SQLException: " + sQLException.getMessage());
                eISSystemException.setLinkedException((Exception)sQLException);
                throw eISSystemException;
            }
            this.managedConnection.eventOccurred(2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleLocalTransaction.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws ResourceException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleLocalTransaction.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.isBeginCalled) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleLocalTransaction.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing LocalTransactionException: " + "begin() must be called before commit()" + RAERR_LTXN_COMMIT);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new LocalTransactionException("begin() must be called before commit()", RAERR_LTXN_COMMIT);
            }
            try {
                this.connection.commit();
            }
            catch (SQLException sQLException) {
                EISSystemException eISSystemException = new EISSystemException("SQLException: " + sQLException.getMessage());
                eISSystemException.setLinkedException((Exception)sQLException);
                throw eISSystemException;
            }
            this.isBeginCalled = false;
            this.managedConnection.eventOccurred(3);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleLocalTransaction.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws ResourceException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleLocalTransaction.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.isBeginCalled) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleLocalTransaction.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing LocalTransactionException: " + "begin() must be called before rollback()" + RAERR_LTXN_ROLLBACK);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new LocalTransactionException("begin() must be called before rollback()", RAERR_LTXN_ROLLBACK);
            }
            try {
                this.connection.rollback();
            }
            catch (SQLException sQLException) {
                EISSystemException eISSystemException = new EISSystemException("SQLException: " + sQLException.getMessage());
                eISSystemException.setLinkedException((Exception)sQLException);
                throw eISSystemException;
            }
            this.isBeginCalled = false;
            this.managedConnection.eventOccurred(4);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleLocalTransaction.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.connector");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.connector.OracleLocalTransaction"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

