/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.sqlhistory;

import java.text.DateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.parser.plsql.SqlHistory;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.ISchedulingRule;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.worksheet.sqlhistory.SqlEditorHistory;
import oracle.dbtools.worksheet.sqlhistory.db.HistoryDB;
import oracle.dbtools.worksheet.sqlhistory.db.HistoryDBTableModel;

public class SqlHistoryTask
extends RaptorTask<Object> {
    private String _sql = null;
    private String _conn = null;
    private String _historyType = null;
    private float _execTime = 0.0f;
    private static final ISchedulingRule _rule = new ISchedulingRule(){

        public boolean isConflicting(ISchedulingRule iSchedulingRule) {
            return this == iSchedulingRule;
        }
    };

    public SqlHistoryTask(String string, String string2, String string3, float f) {
        super("Saving Sql History", true, IRaptorTaskRunMode.NO_GUI);
        this._sql = string;
        this._conn = string2;
        this._historyType = string3;
        this._execTime = f;
    }

    protected Object doWork() throws TaskException {
        try {
            SqlEditorHistory.getInstance();
            if (!SqlHistoryTask.hasPassword(this._sql)) {
                Date date = new Date();
                DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
                String string = dateFormat.format(date);
                HistoryDB.getInstance().addItemFor(this._conn, this._sql, this._historyType, string, this._execTime);
                SqlHistory.generateTemplate((String)this._sql, (String)string);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        HistoryDBTableModel.getInstance().fireTableDataChanged();
                    }
                });
            }
        }
        catch (Throwable throwable) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, throwable.getStackTrace()[0].toString(), throwable);
        }
        return null;
    }

    public ISchedulingRule getSchedulingRule() {
        return _rule;
    }

    private static boolean hasPassword(String string) {
        return SqlHistoryTask.hasTokens(string);
    }

    private static boolean hasTokens(String string) {
        String[] stringArray = string.trim().split("[ \t\n\r]");
        if (stringArray != null && stringArray.length > 2) {
            if (stringArray[0].equalsIgnoreCase("create") && stringArray[1].equalsIgnoreCase("database") && stringArray[2].equalsIgnoreCase("link") || stringArray[0].equalsIgnoreCase("connect") || stringArray[0].equalsIgnoreCase("alter") && stringArray[1].equalsIgnoreCase("user")) {
                return true;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (i <= 1 || !stringArray[i - 1].equalsIgnoreCase("identified") || !stringArray[i].equalsIgnoreCase("by")) continue;
                return true;
            }
        }
        return false;
    }
}

