/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.sqlhistory;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Connection;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.editors.DbEditor;
import oracle.dbtools.raptor.nls.OraTIMESTAMPFormat;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.NLSUtils;
import oracle.dbtools.raptor.utils.TableSorter;
import oracle.dbtools.worksheet.Messages;
import oracle.dbtools.worksheet.editor.Worksheet;
import oracle.dbtools.worksheet.sqlhistory.SQLHistoryController;
import oracle.dbtools.worksheet.sqlhistory.SqlEditorHistory;
import oracle.dbtools.worksheet.sqlhistory.SqlHistoryFilterModel;
import oracle.dbtools.worksheet.sqlhistory.db.HistoryDBTableModel;
import oracle.i18n.util.OraLocaleInfo;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.view.View;
import oracle.javatools.db.DBException;
import oracle.sql.TIMESTAMP;

public class SqlHistoryPanel
extends JPanel
implements DragGestureListener,
DragSourceListener {
    private static final long serialVersionUID = 1L;
    private JTable m_table = null;
    private AbstractTableModel m_model;
    private SqlHistoryFilterModel m_sqlHistoryFilterModel;
    private TableSorter m_sorter;
    private Worksheet m_editor;
    private JTextField m_filterText;
    private JButton m_filterButton;
    private String m_currentConnectionName;
    private Toolbar m_toolbar;
    private DragSource m_dragSource;
    private static SqlHistoryPanel INSTANCE = null;

    private SqlHistoryPanel(AbstractTableModel abstractTableModel) {
        super(new GridBagLayout());
        this.m_model = abstractTableModel;
    }

    public static SqlHistoryPanel getInstance() {
        return SqlHistoryPanel.getInstance(true);
    }

    public static SqlHistoryPanel getInstance(boolean bl) {
        if (INSTANCE == null && bl) {
            INSTANCE = new SqlHistoryPanel(HistoryDBTableModel.getInstance());
            SQLHistoryController.getInstance();
        }
        if (INSTANCE != null && SqlHistoryPanel.INSTANCE.m_table == null && bl) {
            INSTANCE.createGUI();
        }
        return INSTANCE;
    }

    public void init() {
        if (this.m_sqlHistoryFilterModel == null) {
            this.m_sqlHistoryFilterModel = new SqlHistoryFilterModel(this.m_model){

                @Override
                public Class<?> getColumnClass(int n) {
                    if (Messages.getString("SqlHistoryPanel.0").equals(this.getColumnName(n))) {
                        return Timestamp.class;
                    }
                    return super.getColumnClass(n);
                }
            };
            this.m_sorter = new TableSorter((TableModel)this.m_sqlHistoryFilterModel);
        }
        this.addSqlEditorListener();
        UIUtils.addIdeKeyBindings((JComponent)this, (int)1, (String)"/oracle/dbtools/worksheet/editor/accelerators.xml");
    }

    protected void createGUI() {
        this.init();
        this.installToolbar();
        this.createTable();
        this.m_sqlHistoryFilterModel.setFilter(this.m_filterText.getText());
        this.m_filterText.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                SqlHistoryPanel.this.m_table.clearSelection();
            }
        });
        this.m_filterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SqlHistoryPanel.this.m_sqlHistoryFilterModel.setFilter(SqlHistoryPanel.this.m_filterText.getText());
            }
        });
        this.m_filterText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                SqlHistoryPanel.this.m_sqlHistoryFilterModel.setFilter(SqlHistoryPanel.this.m_filterText.getText());
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.m_table, 22, 32);
        jScrollPane.setSize(this.m_table.getPreferredSize());
        this.add((Component)this.m_toolbar, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setBackground(UIManager.getColor("EWTDialog.background"));
        this.setPreferredSize(jScrollPane.getPreferredSize());
        int n = this.m_table.getPreferredSize().width;
        this.m_table.getColumn(this.m_table.getColumnName(0)).setMinWidth((int)(0.8 * (double)n));
        this.m_table.getColumn(this.m_table.getColumnName(0)).setPreferredWidth((int)(0.8 * (double)n));
        this.m_table.addMouseListener(SQLHistoryController.getMouseListener());
        this.m_table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                View.updateToolbarActions((Toolbar)SqlHistoryPanel.this.m_toolbar);
            }
        });
        UIUtils.addIdeKeyBindings((JComponent)this.m_table, (int)0, (String)"/oracle/dbtools/worksheet/editor/accelerators.xml");
        this.m_dragSource = new DragSource();
        this.m_dragSource.createDefaultDragGestureRecognizer(this.m_table, 1, this);
    }

    public void installToolbar() {
        this.m_toolbar = new Toolbar();
        this.m_toolbar.add((ToggleAction)SQLHistoryController.getAppendAction());
        this.m_toolbar.add((ToggleAction)SQLHistoryController.getReplaceAction());
        this.m_toolbar.add((ToggleAction)SQLHistoryController.getClearAction());
        ToolButton toolButton = this.m_toolbar.add((ToggleAction)IdeAction.get((int)SQLHistoryController.APPEND_NEXT_FROM_HISTORY_ACTION_CMD_ID));
        if (toolButton != null) {
            toolButton.setVisible(false);
        }
        if ((toolButton = this.m_toolbar.add((ToggleAction)IdeAction.get((int)SQLHistoryController.APPEND_PREVIOUS_FROM_HISTORY_ACTION_CMD_ID))) != null) {
            toolButton.setVisible(false);
        }
        if ((toolButton = this.m_toolbar.add((ToggleAction)IdeAction.get((int)SQLHistoryController.REPLACE_NEXT_FROM_HISTORY_ACTION_CMD_ID))) != null) {
            toolButton.setVisible(false);
        }
        if ((toolButton = this.m_toolbar.add((ToggleAction)IdeAction.get((int)SQLHistoryController.REPLACE_PREVIOUS_FROM_HISTORY_ACTION_CMD_ID))) != null) {
            toolButton.setVisible(false);
        }
        this.m_toolbar.addSeparator();
        this.m_filterText = new JTextField("");
        this.m_toolbar.add((Component)this.m_filterText);
        this.m_filterButton = new JButton(Messages.getString("SqlHistoryPanel.7"));
        this.m_toolbar.add((Component)this.m_filterButton);
    }

    protected void createTable() {
        this.m_table = new JTable((TableModel)this.m_sorter){
            private static final long serialVersionUID = 1L;

            @Override
            protected void processKeyEvent(KeyEvent keyEvent) {
                super.processKeyEvent(keyEvent);
            }

            @Override
            public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
                Object object = this.getValueAt(n, n2);
                TableCellEditor tableCellEditor2 = this.getDefaultEditor(object.getClass());
                Component component = tableCellEditor2.getTableCellEditorComponent(this, object, this.isCellSelected(n, n2), n, n2);
                if (component instanceof JTextComponent) {
                    ((JTextComponent)component).setEditable(false);
                }
                return component;
            }

            @Override
            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                if (component instanceof JComponent) {
                    JComponent jComponent = (JComponent)component;
                    Object object = this.getValueAt(n, n2);
                    if (object instanceof Integer) {
                        jComponent.setToolTipText("<html>" + ((Integer)object).toString().replaceAll("\n", "<br>").replaceAll("<", "&lt;").replaceAll(">", "&gt;") + "</html>");
                    } else if (object != null) {
                        String string = object.toString();
                        if (string.length() > 200) {
                            string = string.substring(0, 200) + "\n...";
                        }
                        jComponent.setToolTipText("<html>" + string.replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\n", "<br>") + "</html>");
                    }
                }
                return component;
            }
        };
        this.m_sorter.setTableHeader(this.m_table.getTableHeader());
        this.m_sorter.setSortingStatus(2, -1);
        this.m_table.setCellSelectionEnabled(false);
        this.m_table.setRowSelectionAllowed(true);
        this.m_table.setAutoResizeMode(0);
        this.m_table.getColumn(Messages.getString("SqlEditorHistory.2")).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public String getText() {
                String string = super.getText();
                try {
                    TIMESTAMP tIMESTAMP;
                    Object object;
                    Map map = DBConfig.getInstance().getNLSMap();
                    String string2 = (String)map.get("NLS_TS_FORM");
                    if (SqlHistoryPanel.this.m_currentConnectionName != null) {
                        object = null;
                        object = Connections.getInstance().getConnection(SqlHistoryPanel.this.m_currentConnectionName, false);
                        if (object != null) {
                            string2 = NLSUtils.getTimeStampFormat((Connection)object);
                        } else {
                            return string;
                        }
                    }
                    object = DateFormat.getDateTimeInstance(3, 3);
                    Date date = ((DateFormat)object).parse(string);
                    if (string2 == null || string2.length() == 0) {
                        return string;
                    }
                    string2 = string2.replaceAll("[FS]", "");
                    OraTIMESTAMPFormat oraTIMESTAMPFormat = new OraTIMESTAMPFormat(string2 = string2.replaceAll("[\\p{Punct}]++X++", ""), OraLocaleInfo.getInstance((String)((String)map.get("NLS_LANGUAGE")), (String)((String)map.get("NLS_TERRITORY"))));
                    String string3 = oraTIMESTAMPFormat.format(tIMESTAMP = new TIMESTAMP(new Timestamp(date.getTime())));
                    if (string3 != null && string3.length() > 0) {
                        string = string3;
                    }
                }
                catch (ParseException parseException) {
                    return string;
                }
                catch (DBException dBException) {
                    // empty catch block
                }
                return string;
            }
        });
        this.m_table.getColumn(Messages.getString("SqlEditorHistory.5")).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public String getText() {
                String string = super.getText();
                return string.equals("-1.0") ? "" : string;
            }
        });
        this.m_sorter.setColumnComparator(Timestamp.class, (Comparator)new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                if (string == null) {
                    if (string2 == null) {
                        return 0;
                    }
                    return -1;
                }
                if (string2 == null) {
                    return 1;
                }
                if (string.equals(string2)) {
                    return 0;
                }
                DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
                try {
                    Date date = dateFormat.parse(string);
                    Date date2 = dateFormat.parse(string2);
                    return date.compareTo(date2);
                }
                catch (ParseException parseException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, parseException.getStackTrace()[0].toString(), parseException);
                    return 0;
                }
            }
        });
    }

    protected void addSqlEditorListener() {
        EditorManager.getEditorManager().addEditorListener(new EditorListener(){

            public void editorActivated(Editor editor) {
                if (editor instanceof Worksheet) {
                    SqlHistoryPanel.this.m_currentConnectionName = ((Worksheet)editor).getConnectionName();
                    SqlHistoryPanel.this.m_editor = (Worksheet)editor;
                } else {
                    SqlHistoryPanel.this.m_currentConnectionName = null;
                    SqlHistoryPanel.this.m_editor = null;
                }
            }

            public void editorClosed(Editor editor) {
                SqlHistoryPanel.this.m_currentConnectionName = null;
                SqlHistoryPanel.this.m_editor = null;
            }

            public void editorDeactivated(Editor editor) {
            }

            public void editorOpened(Editor editor) {
                if (editor instanceof Worksheet) {
                    SqlHistoryPanel.this.m_currentConnectionName = ((DbEditor)editor).getConnectionName();
                    SqlHistoryPanel.this.m_editor = (Worksheet)editor;
                } else {
                    SqlHistoryPanel.this.m_currentConnectionName = null;
                    SqlHistoryPanel.this.m_editor = null;
                }
            }
        });
    }

    public Toolbar getToolbar() {
        if (this.m_toolbar == null) {
            this.installToolbar();
        }
        return this.m_toolbar;
    }

    public JTable getTable() {
        return this.m_table;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int n : this.m_table.getSelectedRows()) {
            stringBuffer.append(SqlEditorHistory.getInstance().getSqlAt(n));
        }
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        this.m_dragSource.startDrag(dragGestureEvent, DragSource.DefaultCopyDrop, stringSelection, this);
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    public String getSQLAt(int n) {
        return this.m_sorter.getValueAt(n, 0).toString().trim();
    }

    public String getSQLTypeAt(int n) {
        return this.m_sorter.getValueAt(n, 4).toString().trim();
    }
}

