/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.sqltuningadvisor;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.worksheet.commands.sqltuningadvisor.SqlTuningAdvisor;
import oracle.dbtools.worksheet.commands.sqltuningadvisor.SqlTuningCommon;
import oracle.jdbc.OracleCallableStatement;

public class SqlTuningTask {
    private SqlTuningCommon m_STCommon = null;
    private SqlTuningAdvisor m_STAdvisor = null;

    public SqlTuningTask(SqlTuningAdvisor sqlTuningAdvisor) {
        this.setSqlTuningAdvisor(sqlTuningAdvisor);
        this.setSqlTuningCommon(sqlTuningAdvisor.getSqlTuningCommon());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkOwnerPrivileges() {
        boolean bl;
        block15: {
            String string = this.getSqlTuningCommon().getQuery(this.getSqlTuningCommon().getConnection(), this.getSqlTuningCommon().getQueryKey("privilege_sql"));
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String string2 = null;
            bl = false;
            hashMap.clear();
            hashMap.put("OWNER", this.getSqlTuningCommon().getOwnerName());
            ResultSetWrapper resultSetWrapper = null;
            ResultSet resultSet = null;
            if (Connections.getInstance().lock(this.getSqlTuningCommon().getConnection())) {
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)this.getSqlTuningCommon().getConnection());
                    dBUtil.setRaiseError(false);
                    resultSetWrapper = dBUtil.executeQuery(string, hashMap);
                    if (resultSetWrapper == null) break block15;
                    resultSet = resultSetWrapper.getResultSet();
                    while (resultSet.next()) {
                        string2 = resultSet.getString(1);
                        if (!string2.equalsIgnoreCase("ADVISOR")) continue;
                        bl = true;
                        break;
                    }
                }
                catch (SQLException sQLException) {
                    ExceptionHandler.handleException((Throwable)sQLException);
                }
                finally {
                    if (resultSetWrapper != null) {
                        resultSetWrapper.close();
                    }
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Exception exception) {
                            ExceptionHandler.handleException((Throwable)exception);
                        }
                    }
                    Connections.getInstance().unlock(this.getSqlTuningCommon().getConnection());
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> getAllTuningTaskNames() {
        String string = this.getSqlTuningCommon().getQuery(this.getSqlTuningCommon().getConnection(), this.getSqlTuningCommon().getQueryKey("taskName_sql"));
        Statement statement = null;
        ResultSet resultSet = null;
        String string2 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (Connections.getInstance().lock(this.getSqlTuningCommon().getConnection())) {
            try {
                statement = this.getSqlTuningCommon().getConnection().createStatement();
                resultSet = statement.executeQuery(string);
                while (resultSet.next()) {
                    string2 = resultSet.getString(1);
                    arrayList.add(string2);
                }
            }
            catch (SQLException sQLException) {
                ExceptionHandler.handleException((Throwable)sQLException);
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {
                        ExceptionHandler.handleException((Throwable)exception);
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {
                        ExceptionHandler.handleException((Throwable)exception);
                    }
                }
                Connections.getInstance().unlock(this.getSqlTuningCommon().getConnection());
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> getAllSqlSetNames() {
        String string = this.getSqlTuningCommon().getQuery(this.getSqlTuningCommon().getConnection(), this.getSqlTuningCommon().getQueryKey("sqlSetName_sql"));
        Statement statement = null;
        ResultSet resultSet = null;
        String string2 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (Connections.getInstance().lock(this.getSqlTuningCommon().getConnection())) {
            try {
                statement = this.getSqlTuningCommon().getConnection().createStatement();
                resultSet = statement.executeQuery(string);
                while (resultSet.next()) {
                    string2 = resultSet.getString(1);
                    arrayList.add(string2);
                }
            }
            catch (SQLException sQLException) {
                ExceptionHandler.handleException((Throwable)sQLException);
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {
                        ExceptionHandler.handleException((Throwable)exception);
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {
                        ExceptionHandler.handleException((Throwable)exception);
                    }
                }
                Connections.getInstance().unlock(this.getSqlTuningCommon().getConnection());
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createSqlTuningTaskOld() {
        String string = this.getSqlTuningCommon().getQuery(this.getSqlTuningCommon().getConnection(), this.getSqlTuningCommon().getQueryKey("createSST_sql"));
        StringBuilder stringBuilder = new StringBuilder();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.clear();
        hashMap.put("SQL_TEXT", this.getSqlTuningCommon().getSelectedSQLScript());
        hashMap.put("OWNER", this.getSqlTuningCommon().getOwnerName());
        hashMap.put("BIND_VARIABLES", this.getSqlTuningCommon().getBindVariablesString());
        hashMap.put("SQLTUNINGTASK_NAME", this.getSqlTuningCommon().getSQLTuningTaskName());
        ResultSetWrapper resultSetWrapper = null;
        ResultSet resultSet = null;
        if (Connections.getInstance().lock(this.getSqlTuningCommon().getConnection())) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)this.getSqlTuningCommon().getConnection());
                dBUtil.setRaiseError(false);
                resultSetWrapper = dBUtil.executeQuery(string, hashMap);
                if (resultSetWrapper != null) {
                    resultSet = resultSetWrapper.getResultSet();
                }
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {
                        ExceptionHandler.handleException((Throwable)exception);
                    }
                }
                Connections.getInstance().unlock(this.getSqlTuningCommon().getConnection());
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createSqlTuningTask() {
        String string = this.getSqlTuningCommon().getQuery(this.getSqlTuningCommon().getConnection(), this.getSqlTuningCommon().getQueryKey("createSST_sql"));
        OracleCallableStatement oracleCallableStatement = null;
        String string2 = "'" + this.getSqlTuningCommon().getSelectedSQLScript().trim().replaceAll("'", "''") + "'";
        String string3 = "'" + this.getSqlTuningCommon().getOwnerName().trim() + "'";
        String string4 = this.getSqlTuningCommon().getBindVariablesString().trim();
        String string5 = "'" + this.getSqlTuningCommon().getSQLTuningTaskName().trim() + "'";
        string = string.replace(":SQL_TEXT", string2);
        string = string.replace(":OWNER", string3);
        string = string.replace(":BIND_VARIABLES", string4);
        string = string.replace(":SQLTUNINGTASK_NAME", string5);
        if (Connections.getInstance().lock(this.getSqlTuningCommon().getConnection())) {
            try {
                oracleCallableStatement = (OracleCallableStatement)this.getSqlTuningCommon().getConnection().prepareCall(string);
                oracleCallableStatement.execute();
                oracleCallableStatement.close();
            }
            catch (SQLException sQLException) {
                ExceptionHandler.handleException((Throwable)sQLException);
            }
            finally {
                if (oracleCallableStatement != null) {
                    try {
                        oracleCallableStatement.close();
                    }
                    catch (Exception exception) {
                        ExceptionHandler.handleException((Throwable)exception);
                    }
                }
                Connections.getInstance().unlock(this.getSqlTuningCommon().getConnection());
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeSQLTuningTask() {
        String string = this.getSqlTuningCommon().getQuery(this.getSqlTuningCommon().getConnection(), this.getSqlTuningCommon().getQueryKey("executeSTT_sql"));
        StringBuilder stringBuilder = new StringBuilder();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.clear();
        hashMap.put("SQLTUNINGTASK_NAME", this.getSqlTuningCommon().getSQLTuningTaskName());
        ResultSetWrapper resultSetWrapper = null;
        ResultSet resultSet = null;
        if (Connections.getInstance().lock(this.getSqlTuningCommon().getConnection())) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)this.getSqlTuningCommon().getConnection());
                dBUtil.setRaiseError(false);
                resultSetWrapper = dBUtil.executeQuery(string, hashMap);
                if (resultSetWrapper != null) {
                    resultSet = resultSetWrapper.getResultSet();
                }
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {
                        ExceptionHandler.handleException((Throwable)exception);
                    }
                }
                Connections.getInstance().unlock(this.getSqlTuningCommon().getConnection());
            }
        }
        return true;
    }

    public boolean checkForTaskCompletion() {
        String string = this.getSqlTuningCommon().getQuery(this.getSqlTuningCommon().getConnection(), this.getSqlTuningCommon().getQueryKey("statusCheck_sql"));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.clear();
        hashMap.put("SQLTUNINGTASK_NAME", this.getSqlTuningCommon().getSQLTuningTaskName());
        return this.executeSQLStatement(string, hashMap);
    }

    public boolean dropSQLTuningTask() {
        String string = this.getSqlTuningCommon().getQuery(this.getSqlTuningCommon().getConnection(), this.getSqlTuningCommon().getQueryKey("dropSTT_sql"));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.clear();
        hashMap.put("SQLTUNINGTASK_NAME", this.getSqlTuningCommon().getSQLTuningTaskName());
        return this.executeSQLStatement(string, hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeSQLStatement(String string, Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        ResultSetWrapper resultSetWrapper = null;
        ResultSet resultSet = null;
        if (Connections.getInstance().lock(this.getSqlTuningCommon().getConnection())) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)this.getSqlTuningCommon().getConnection());
                dBUtil.setRaiseError(false);
                resultSetWrapper = dBUtil.executeQuery(string, map);
                if (resultSetWrapper != null) {
                    resultSet = resultSetWrapper.getResultSet();
                    while (resultSet.next()) {
                        stringBuilder.append(resultSet.getString(1));
                    }
                }
            }
            catch (SQLException sQLException) {
                ExceptionHandler.handleException((Throwable)sQLException);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {
                        ExceptionHandler.handleException((Throwable)exception);
                    }
                }
                Connections.getInstance().unlock(this.getSqlTuningCommon().getConnection());
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createSQLTuningSet() {
        String string = this.getSqlTuningCommon().getQuery(this.getSqlTuningCommon().getConnection(), this.getSqlTuningCommon().getQueryKey("createSqlSet_sql"));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.clear();
        hashMap.put("SQLSET_NAME", this.getSqlTuningCommon().getSQLTuningSetName());
        ResultSetWrapper resultSetWrapper = null;
        ResultSet resultSet = null;
        if (Connections.getInstance().lock(this.getSqlTuningCommon().getConnection())) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)this.getSqlTuningCommon().getConnection());
                dBUtil.setRaiseError(false);
                resultSetWrapper = dBUtil.executeQuery(string, hashMap);
                if (resultSetWrapper != null) {
                    resultSet = resultSetWrapper.getResultSet();
                }
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {
                        ExceptionHandler.handleException((Throwable)exception);
                    }
                }
                Connections.getInstance().unlock(this.getSqlTuningCommon().getConnection());
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadSQLTuningSet() {
        String string = this.getSqlTuningCommon().getQuery(this.getSqlTuningCommon().getConnection(), this.getSqlTuningCommon().getQueryKey("loadSqlSet_sql"));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.clear();
        string = string.replaceFirst(":SQLSET_ROWS", this.getSqlTuningCommon().getSQLTuningSetRows());
        hashMap.put("SQLSET_NAME", this.getSqlTuningCommon().getSQLTuningSetName());
        ResultSetWrapper resultSetWrapper = null;
        ResultSet resultSet = null;
        if (Connections.getInstance().lock(this.getSqlTuningCommon().getConnection())) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)this.getSqlTuningCommon().getConnection());
                dBUtil.setRaiseError(false);
                resultSetWrapper = dBUtil.executeQuery(string, hashMap);
                if (resultSetWrapper != null) {
                    resultSet = resultSetWrapper.getResultSet();
                }
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {
                        ExceptionHandler.handleException((Throwable)exception);
                    }
                }
                Connections.getInstance().unlock(this.getSqlTuningCommon().getConnection());
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createSqlSetTuningTask() {
        String string = this.getSqlTuningCommon().getQuery(this.getSqlTuningCommon().getConnection(), this.getSqlTuningCommon().getQueryKey("createSqlSetTask_sql"));
        StringBuilder stringBuilder = new StringBuilder();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.clear();
        hashMap.put("SQLSET_NAME", this.getSqlTuningCommon().getSQLTuningSetName());
        hashMap.put("OWNER", this.getSqlTuningCommon().getOwnerName());
        hashMap.put("SQLTUNINGTASK_NAME", this.getSqlTuningCommon().getSQLTuningTaskName());
        ResultSetWrapper resultSetWrapper = null;
        ResultSet resultSet = null;
        if (Connections.getInstance().lock(this.getSqlTuningCommon().getConnection())) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)this.getSqlTuningCommon().getConnection());
                dBUtil.setRaiseError(false);
                resultSetWrapper = dBUtil.executeQuery(string, hashMap);
                if (resultSetWrapper != null) {
                    resultSet = resultSetWrapper.getResultSet();
                }
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {
                        ExceptionHandler.handleException((Throwable)exception);
                    }
                }
                Connections.getInstance().unlock(this.getSqlTuningCommon().getConnection());
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeMultipleSqlStatments() {
        String[] stringArray = this.getSqlTuningCommon().getSelectedSQLScriptsForSqlSets();
        for (int i = 0; i < stringArray.length; ++i) {
            Statement statement = null;
            ResultSet resultSet = null;
            if (!Connections.getInstance().lock(this.getSqlTuningCommon().getConnection())) continue;
            try {
                statement = this.getSqlTuningCommon().getConnection().createStatement();
                resultSet = statement.executeQuery(stringArray[i]);
                continue;
            }
            catch (SQLException sQLException) {
                ExceptionHandler.handleException((Throwable)sQLException);
                continue;
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {
                        ExceptionHandler.handleException((Throwable)exception);
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {
                        ExceptionHandler.handleException((Throwable)exception);
                    }
                }
                Connections.getInstance().unlock(this.getSqlTuningCommon().getConnection());
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable<String, String> getSqlIdForEachSqlStatement() {
        String[] stringArray = this.getSqlTuningCommon().getSelectedSQLScriptsForSqlSets();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (int i = 0; i < stringArray.length; ++i) {
            Statement statement = null;
            ResultSet resultSet = null;
            String string = "select sql_id from v$sql where sql_text = '" + stringArray[i].replaceAll("'", "''") + "'";
            if (!Connections.getInstance().lock(this.getSqlTuningCommon().getConnection())) continue;
            try {
                statement = this.getSqlTuningCommon().getConnection().createStatement();
                resultSet = statement.executeQuery(string);
                String string2 = null;
                while (resultSet.next()) {
                    string2 = resultSet.getString(1);
                }
                hashtable.put(string2, stringArray[i]);
                continue;
            }
            catch (SQLException sQLException) {
                ExceptionHandler.handleException((Throwable)sQLException);
                continue;
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {
                        ExceptionHandler.handleException((Throwable)exception);
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {
                        ExceptionHandler.handleException((Throwable)exception);
                    }
                }
                Connections.getInstance().unlock(this.getSqlTuningCommon().getConnection());
            }
        }
        return hashtable;
    }

    public void executeSQLSqlScriptsForSqlId() {
        this.executeMultipleSqlStatments();
        this.getSqlTuningCommon().setSqlIdAndSqlScript(this.getSqlIdForEachSqlStatement());
    }

    public SqlTuningCommon getSqlTuningCommon() {
        return this.m_STCommon;
    }

    public void setSqlTuningCommon(SqlTuningCommon sqlTuningCommon) {
        this.m_STCommon = sqlTuningCommon;
    }

    public SqlTuningAdvisor getSqlTuningAdvisor() {
        return this.m_STAdvisor;
    }

    public void setSqlTuningAdvisor(SqlTuningAdvisor sqlTuningAdvisor) {
        this.m_STAdvisor = sqlTuningAdvisor;
    }
}

