/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.scriptrunner.task;

import java.util.Map;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.dialogs.BindDialog;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.worksheet.AbstractWorksheetTaskResultPanel;
import oracle.dbtools.worksheet.ActionProvider;
import oracle.dbtools.worksheet.Messages;
import oracle.dbtools.worksheet.StatementRunnerResultsPanel;
import oracle.dbtools.worksheet.WorksheetContext;
import oracle.dbtools.worksheet.WorksheetTaskWrapper;
import oracle.dbtools.worksheet.commands.scriptrunner.ConsumerManager;
import oracle.dbtools.worksheet.commands.scriptrunner.ScriptRunnerProvider;
import oracle.dbtools.worksheet.commands.scriptrunner.api.IScriptConsumer;
import oracle.dbtools.worksheet.commands.scriptrunner.task.CommandRunnerScope;
import oracle.dbtools.worksheet.commands.scriptrunner.task.DBCommandRunnerTask;
import oracle.dbtools.worksheet.commands.scriptrunner.task.ScriptRunnerTask;

public class StatementRunnerTask
extends DBCommandRunnerTask {
    public static final String STATEMENTRUNNER_TASKNAME = Messages.getString("ScriptRunnerTask.2");
    public static final String STATEMENTSCRIPTRUNNER_TASKNAME = Messages.getString("StatementRunnerTask.StatementScriptRunnerTask");
    public static final String STATEMENTSCRIPTRUNNER_TABNAME = Messages.getString("StatementRunnerTask.StatementScriptRunnerTabName");
    private ScriptRunnerTask m_scriptRunnerTask = null;

    public StatementRunnerTask(WorksheetContext worksheetContext, ConsumerManager consumerManager, String string, IRaptorTaskRunMode iRaptorTaskRunMode) {
        super(worksheetContext, consumerManager, string, iRaptorTaskRunMode, StatementRunnerTask.getTaskName());
    }

    protected static String getTaskName() {
        return STATEMENTRUNNER_TASKNAME;
    }

    @Override
    protected void handleNoSelection(CommandRunnerScope commandRunnerScope) {
        int n = commandRunnerScope.getCursorLinePosition();
        ISQLCommand iSQLCommand = this.getParser().getCommandAtCursorPos(n);
        this.runCommand(iSQLCommand, false, false, 1);
        this.afterLoopProcessing();
    }

    @Override
    protected void tailoredRunCommand(ISQLCommand iSQLCommand, boolean bl, boolean bl2, int n) {
        boolean bl3 = DBConfig.getInstance().getBoolean("AUTOPIN_RESULTS_TABS");
        if (bl && (n > 1 || bl2)) {
            bl3 = true;
        }
        if (iSQLCommand.getResultsType() == SQLCommand.StmtResultType.G_R_QUERY || iSQLCommand.getResultsType() == SQLCommand.StmtResultType.G_R_SCRIPTEDQUERY) {
            if (iSQLCommand.getResultsType() == SQLCommand.StmtResultType.G_R_SCRIPTEDQUERY && !iSQLCommand.getSql().startsWith("/*SQLDEV:SCRIPTTABLE*/") && !iSQLCommand.getSQLOrig().startsWith("/*SQLDEV:SCRIPTTABLE*/")) {
                iSQLCommand.setSql("/*SQLDEV:SCRIPTTABLE*/" + iSQLCommand.getSql());
                iSQLCommand.setSQLOrig("/*SQLDEV:SCRIPTTABLE*/" + iSQLCommand.getSQLOrig());
            }
            StatementRunnerTask.openStmtRunnerResultsPanel(bl3, iSQLCommand, this.getWorksheetContext(), this.getDescriptor());
        } else if (SQLCommand.StmtSubType.G_S_COMMENT_PLUS != iSQLCommand.getStmtSubType()) {
            this.resetCursor(this.m_commandRunnerScope);
            this.getScriptRunnerContext().setScriptText(0, 0);
            this.getScriptRunnerContext().getExecutedCommandList().clear();
            Map<String, ActionProvider<?>> map = this.getWorksheetContext().getProviders();
            ScriptRunnerProvider scriptRunnerProvider = (ScriptRunnerProvider)map.get("Worksheet.RunScript");
            WorksheetContext worksheetContext = this.getWorksheetContext();
            if (iSQLCommand.getStmtType() != SQLCommand.StmtType.G_C_SQLPLUS) {
                this.handleBinds(iSQLCommand, worksheetContext);
            }
            worksheetContext.setStatementRunner(true);
            worksheetContext.setStartCommand(iSQLCommand);
            WorksheetTaskWrapper<Void> worksheetTaskWrapper = scriptRunnerProvider.doAction("Worksheet.RunScript", worksheetContext);
            if (worksheetTaskWrapper != null) {
                RaptorTaskManager.getInstance().addTask(worksheetTaskWrapper);
            }
            this.isExecutionHandedOver = true;
            if (bl2) {
                this.m_isCanceled = true;
            }
        }
    }

    private void handleBinds(ISQLCommand iSQLCommand, WorksheetContext worksheetContext) {
        Map map = BindDialog.getBindValues((String)iSQLCommand.getSql());
        Map map2 = this.getScriptRunnerContext().getVarMap();
        for (Map.Entry entry : map.entrySet()) {
            Bind bind = new Bind();
            bind.setName((String)entry.getKey());
            bind.setPrompt((String)entry.getKey());
            if (entry.getValue().equals(DBUtil.NULL_VALUE)) {
                bind.setValue(null);
            } else {
                bind.setValue((String)entry.getValue());
            }
            if (entry.getValue() != null && !entry.getValue().equals(DBUtil.NULL_VALUE)) {
                String string = (String)entry.getValue();
                if (string.equals("")) {
                    bind.setType("CHAR");
                } else if (string.matches("^[-+]?\\d+(\\.\\d+)?$")) {
                    bind.setType("NUMBER");
                } else {
                    bind.setType("CHAR");
                }
            } else {
                bind.setType("CHAR");
            }
            map2.put(((String)entry.getKey()).toUpperCase(), bind);
        }
        worksheetContext.getScriptRunnerContext().setVarMap(map2);
    }

    public boolean cancel() {
        if (this.m_scriptRunnerTask != null) {
            return this.m_scriptRunnerTask.cancel();
        }
        return true;
    }

    public static AbstractWorksheetTaskResultPanel openStmtRunnerResultsPanel(boolean bl, ISQLCommand iSQLCommand, WorksheetContext worksheetContext, RaptorTaskDescriptor raptorTaskDescriptor) {
        StatementRunnerResultsPanel statementRunnerResultsPanel = new StatementRunnerResultsPanel("Worksheet.Run", worksheetContext, iSQLCommand);
        statementRunnerResultsPanel.setPinned(bl);
        worksheetContext.getCallback().showResultPanel(statementRunnerResultsPanel);
        statementRunnerResultsPanel.open();
        raptorTaskDescriptor.setMessage(Messages.getString("ResultsPaneOpenerTask.2"));
        return statementRunnerResultsPanel;
    }

    @Override
    protected void afterLoopProcessing() {
        if (this.m_scriptRunnerTask != null) {
            this.m_scriptRunnerTask.afterLoopProcessing();
        }
    }

    @Override
    protected void beforeLoopProcessing() {
    }

    @Override
    protected void cleanup() {
        if (this.m_scriptRunnerTask != null) {
            this.m_scriptRunnerTask.cleanup();
        }
        this.getWorksheetContext().setStatementRunner(false);
        this.getWorksheetContext().setStartCommand(null);
    }

    @Override
    protected IScriptConsumer getInitialConsumer() {
        return null;
    }
}

