/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.scriptrunner.extension;

import java.io.BufferedOutputStream;
import java.io.Reader;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.worksheet.commands.scriptrunner.api.AStatementRunnerTask;
import oracle.dbtools.worksheet.commands.scriptrunner.api.IScriptConsumer;
import oracle.dbtools.worksheet.commands.scriptrunner.api.IScriptRunnerProvider;
import oracle.dbtools.worksheet.commands.scriptrunner.task.executor.DefaultStatementExecutorTask;
import oracle.dbtools.worksheet.scriptparser.api.IScriptParser;
import oracle.dbtools.worksheet.scriptparser.sqlplus.SQLPlusScriptParser;
import oracle.javatools.util.ModelUtil;

public class ScriptRunnerHook
extends ExtensionHook {
    private static Logger m_logger = Logger.getLogger(ScriptRunnerHook.class.getName());
    private static final String NS = "http://xmlns.oracle.com/sqldeveloper/sqldev-scriptrunner-hook";
    public static final ElementName ELEMENT_NAME = new ElementName("http://xmlns.oracle.com/sqldeveloper/sqldev-scriptrunner-hook", "sqldev-scriptrunner-hook");
    private static List<String> s_provClassNames = new ArrayList<String>();
    private static List<Class<? extends IScriptRunnerProvider>> s_providers;
    private static List<IScriptConsumer> m_consumers;

    private static Iterator<Class<? extends IScriptRunnerProvider>> getProviders() {
        if (s_providers == null) {
            s_providers = new ArrayList<Class<? extends IScriptRunnerProvider>>();
            for (String string : s_provClassNames) {
                try {
                    s_providers.add(Class.forName(string));
                }
                catch (Exception exception) {
                    m_logger.log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
                }
            }
        }
        return s_providers.iterator();
    }

    public static List<IScriptConsumer> getConsumers() {
        if (m_consumers == null) {
            m_consumers = new ArrayList<IScriptConsumer>();
            for (IScriptRunnerProvider iScriptRunnerProvider : ScriptRunnerHook.getInstantiatedProviders()) {
                IScriptConsumer iScriptConsumer = iScriptRunnerProvider.getConsumer();
                if (iScriptConsumer == null) continue;
                m_consumers.add(iScriptConsumer);
            }
        }
        return m_consumers;
    }

    public static boolean isExecutor(ScriptRunnerContext scriptRunnerContext) {
        for (IScriptRunnerProvider iScriptRunnerProvider : ScriptRunnerHook.getInstantiatedProviders()) {
            if (!iScriptRunnerProvider.isExecutable(scriptRunnerContext)) continue;
            return true;
        }
        return false;
    }

    public static AStatementRunnerTask getStatementExecutorTask(ISQLCommand iSQLCommand, BufferedOutputStream bufferedOutputStream, ScriptRunnerContext scriptRunnerContext, Connection connection) {
        AStatementRunnerTask aStatementRunnerTask = null;
        for (IScriptRunnerProvider iScriptRunnerProvider : ScriptRunnerHook.getInstantiatedProviders()) {
            if (!iScriptRunnerProvider.isExecutable(scriptRunnerContext)) continue;
            aStatementRunnerTask = iScriptRunnerProvider.getStatementExecutor(iSQLCommand, bufferedOutputStream, scriptRunnerContext, connection);
            break;
        }
        if (aStatementRunnerTask == null) {
            aStatementRunnerTask = new DefaultStatementExecutorTask(iSQLCommand, bufferedOutputStream, scriptRunnerContext, connection);
        }
        return aStatementRunnerTask;
    }

    public static IScriptParser getScriptParser(ScriptRunnerContext scriptRunnerContext, Reader reader) {
        IScriptParser iScriptParser = null;
        for (IScriptRunnerProvider iScriptRunnerProvider : ScriptRunnerHook.getInstantiatedProviders()) {
            if (!iScriptRunnerProvider.isParsable(scriptRunnerContext)) continue;
            iScriptParser = iScriptRunnerProvider.getParser(reader);
            break;
        }
        if (iScriptParser == null) {
            iScriptParser = new SQLPlusScriptParser(reader);
        }
        return iScriptParser;
    }

    public void start(ElementStartContext elementStartContext) {
        elementStartContext.registerChildVisitor(new ElementName(NS, "provider"), (ElementVisitor)new ProviderChildVisitor());
    }

    private static List<IScriptRunnerProvider> getInstantiatedProviders() {
        ArrayList<IScriptRunnerProvider> arrayList = new ArrayList<IScriptRunnerProvider>();
        Iterator<Class<? extends IScriptRunnerProvider>> iterator = ScriptRunnerHook.getProviders();
        while (iterator.hasNext()) {
            try {
                IScriptRunnerProvider iScriptRunnerProvider = iterator.next().newInstance();
                arrayList.add(iScriptRunnerProvider);
            }
            catch (IllegalAccessException illegalAccessException) {
                m_logger.log(Level.SEVERE, illegalAccessException.getStackTrace()[0].toString(), illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                m_logger.log(Level.SEVERE, instantiationException.getStackTrace()[0].toString(), instantiationException);
            }
        }
        return arrayList;
    }

    static {
        m_consumers = null;
    }

    private static class ProviderChildVisitor
    extends ElementVisitor {
        private ProviderChildVisitor() {
        }

        public void end(ElementEndContext elementEndContext) {
            String string = elementEndContext.getText();
            if (string != null) {
                string = string.trim();
            }
            if (ModelUtil.hasLength((String)string)) {
                s_provClassNames.add(string);
            }
        }
    }
}

