/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.autotrace;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.worksheet.ActionProvider;
import oracle.dbtools.worksheet.WorksheetAction;
import oracle.dbtools.worksheet.WorksheetContext;
import oracle.dbtools.worksheet.WorksheetFeatures;
import oracle.dbtools.worksheet.WorksheetResultPanel;
import oracle.dbtools.worksheet.WorksheetTaskWrapper;
import oracle.dbtools.worksheet.commands.autotrace.AbstractPanel;
import oracle.dbtools.worksheet.commands.autotrace.AnalyzeAction;
import oracle.dbtools.worksheet.commands.autotrace.AutotraceAction;
import oracle.dbtools.worksheet.commands.autotrace.AutotracePanel;
import oracle.dbtools.worksheet.commands.autotrace.ExplainPlanAction;
import oracle.javatools.db.DBException;
import oracle.javatools.editor.BasicDocument;

public class AutotraceActionProvider
implements ActionProvider<Void> {
    static final String oracleDriver = "oracle.jdbc.OracleDriver";
    public static final String AUTOTRACE_CMD_ID = "Worksheet.Autotrace";
    public static final String EXPLAINPLAN_CMD_ID = "Worksheet.Explainplan";
    private WorksheetAction autotraceAction = WorksheetAction.createWorksheetAction("Worksheet.Autotrace", WorksheetAction.ActionType.BOTH, 0, -10.0);
    private WorksheetAction explainAction = WorksheetAction.createWorksheetAction("Worksheet.Explainplan", WorksheetAction.ActionType.BOTH, 0, -10.0);

    public static boolean canExplainAutotrace(String string, String string2) throws DBException, SQLException {
        if (AUTOTRACE_CMD_ID.equals(string) && !AutotraceActionProvider.isOracle(string2)) {
            return false;
        }
        return AutotraceActionProvider.isRegistered(string2);
    }

    private static boolean isRegistered(String string) {
        Properties properties = Connections.getInstance().getConnectionInfo(string);
        if (properties == null) {
            return false;
        }
        String string2 = properties.getProperty("driver");
        if (string2 != null) {
            WorksheetFeatures worksheetFeatures = WorksheetFeatures.getFeatures(string2);
            return worksheetFeatures.getAutotraceModelConstructor() != null;
        }
        return false;
    }

    private static boolean isOracle(String string) {
        Properties properties = Connections.getInstance().getConnectionInfo(string);
        if (properties == null) {
            return false;
        }
        String string2 = properties.getProperty("driver");
        return oracleDriver.equals(string2);
    }

    @Override
    public boolean checkActionEnabled(String string, WorksheetContext worksheetContext) {
        boolean bl = false;
        try {
            bl = AutotraceActionProvider.canExplainAutotrace(string, worksheetContext.getConnectionName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        BasicDocument basicDocument = (BasicDocument)worksheetContext.getEditor().getDocument();
        return basicDocument.getLength() > 0 && bl;
    }

    @Override
    public WorksheetTaskWrapper<Void> doAction(String string, WorksheetContext worksheetContext) {
        AnalyzeAction analyzeAction = null;
        if (AUTOTRACE_CMD_ID.equals(string)) {
            analyzeAction = new AutotraceAction(string, worksheetContext);
        } else if (EXPLAINPLAN_CMD_ID.equals(string)) {
            analyzeAction = new ExplainPlanAction(string, worksheetContext);
        } else {
            return null;
        }
        AutotracePanel autotracePanel = new AutotracePanel(string, EXPLAINPLAN_CMD_ID.equals(string), worksheetContext);
        analyzeAction.setAutoTracePanel(autotracePanel);
        ArrayList<IRaptorTaskListener> arrayList = new ArrayList<IRaptorTaskListener>();
        arrayList.add((IRaptorTaskListener)autotracePanel.new AbstractPanel.ResultsPanelTaskListener());
        for (IRaptorTaskListener iRaptorTaskListener : arrayList) {
            analyzeAction.getDescriptor().addListener(iRaptorTaskListener);
        }
        return analyzeAction != null ? new WorksheetTaskWrapper<Void>(analyzeAction, arrayList, Collections.EMPTY_LIST, worksheetContext) : null;
    }

    @Override
    public WorksheetAction getActionAt(int n) {
        if (n == 0) {
            return this.explainAction;
        }
        return this.autotraceAction;
    }

    @Override
    public int getActionsCount() {
        return 2;
    }

    @Override
    public WorksheetResultPanel getPanelAt(int n) {
        return null;
    }

    @Override
    public int getPanelCount() {
        return 0;
    }
}

