/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands;

import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dbtools.raptor.images.RaptorImage;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.worksheet.ActionProvider;
import oracle.dbtools.worksheet.WorksheetAction;
import oracle.dbtools.worksheet.WorksheetCallback;
import oracle.dbtools.worksheet.WorksheetContext;
import oracle.dbtools.worksheet.WorksheetResultPanel;
import oracle.dbtools.worksheet.WorksheetTaskWrapper;
import oracle.dbtools.worksheet.commands.TestAction;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.javatools.db.DBException;

public class TestActionProvider
implements ActionProvider<Void> {
    public static final String TEST_CMD = "Worksheet.Sample";

    @Override
    public WorksheetTaskWrapper<Void> doAction(String string, WorksheetContext worksheetContext) {
        if (TEST_CMD.equals(string)) {
            String string2 = worksheetContext.getConnectionName();
            WorksheetCallback worksheetCallback = worksheetContext.getCallback();
            try {
                Connection connection = Connections.getInstance().getConnection(string2);
                if (connection != null) {
                    return new WorksheetTaskWrapper<Void>(new TestAction(connection, "SELECT USER FROM DUAL"), null, null, worksheetContext);
                }
            }
            catch (DBException dBException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
            }
        }
        return null;
    }

    @Override
    public WorksheetAction getActionAt(int n) {
        if (n != 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        IdeAction ideAction = IdeAction.get((int)Ide.findOrCreateCmdID((String)TEST_CMD), null, (String)"Test", null, (Integer)84, (Icon)RaptorImage.getIcon((String)RaptorImagesArb.getString((String)"RUN")), null, (boolean)true);
        return WorksheetAction.createWorksheetAction(TEST_CMD, WorksheetAction.ActionType.BOTH, 0, 0.0);
    }

    @Override
    public int getActionsCount() {
        return 1;
    }

    @Override
    public WorksheetResultPanel getPanelAt(int n) {
        return null;
    }

    @Override
    public int getPanelCount() {
        return 1;
    }

    @Override
    public boolean checkActionEnabled(String string, WorksheetContext worksheetContext) {
        return worksheetContext.getConnectionName() != null;
    }
}

