/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterException;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.logging.IStatusMessageConsumer;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.ui.IImageRegistry;
import oracle.dbtools.raptor.controls.grid.RaptorGridPersistedSettings;
import oracle.dbtools.raptor.controls.grid.RaptorGridTable;
import oracle.dbtools.raptor.controls.grid.RaptorGridTaskWrapper;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.dbtools.raptor.dialogs.BindDialog;
import oracle.dbtools.raptor.dialogs.CreateDialogArb;
import oracle.dbtools.raptor.dialogs.SQLErrorDialog;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.Substitution;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.oerr.Oerr;
import oracle.dbtools.raptor.utils.oerr.OerrException;
import oracle.dbtools.util.Utility;
import oracle.dbtools.worksheet.AbstractWorksheetResultPanel;
import oracle.dbtools.worksheet.AbstractWorksheetTaskResultPanel;
import oracle.dbtools.worksheet.Messages;
import oracle.dbtools.worksheet.WorksheetContext;
import oracle.dbtools.worksheet.WorksheetState;
import oracle.dbtools.worksheet.WorksheetTaskUIListener;
import oracle.dbtools.worksheet.sqlhistory.SqlEditorHistory;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.db.util.IconWithSmallOverlay;
import oracle.javatools.clipboard.ClipboardStack;
import oracle.javatools.controls.HyperlinkButton;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ghost.GhostPalette;
import oracle.javatools.ui.ghost.UIConstants;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.LayerUI;
import org.jdesktop.jxlayer.plaf.ext.LockableUI;

public class StatementRunnerResultsPanel
extends AbstractWorksheetTaskResultPanel
implements IStatusMessageConsumer {
    private String m_id = null;
    protected int REFRESH_CMD_ID = 51;
    private IdeAction m_SQLAction = null;
    protected ToggleAction _refreshAction = null;
    protected IdeAction _deleteGridSettings = null;
    protected GhostPalette gp = null;
    private static final long serialVersionUID = 1L;
    private String m_tabName = Messages.getString("RunQueryPanel.0");
    private WorksheetState m_state = WorksheetState.CLOSED;
    private ISQLCommand m_command = null;
    private String _connName = null;
    private JScrollPane _scrollPane = null;
    final ResultSetTable _table = new ResultSetTable();
    JTextArea _errArea = new JTextArea();
    private Icon tabIcon = this.getWaitingIcon();
    private final Icon _runningIcon = new IconWithSmallOverlay(OracleIcons.getIcon((String)"throbber.gif"), OracleIcons.getIcon((String)"run.png"));
    private final Icon _waitingIcon = new IconWithSmallOverlay(OracleIcons.getIcon((String)"run.png"), IImageRegistry.LIGHT_YELLOW);
    private final Icon _ranOkIcon = OracleIcons.getIcon((String)"run.png");
    private final Icon _problemIcon = new IconWithSmallOverlay(OracleIcons.getIcon((String)"run.png"), OracleIcons.getIcon((String)"exception.png"));
    private static final String SQL = "SQL";

    @Override
    public Icon getTabIcon() {
        return this.tabIcon;
    }

    @Override
    public void setTabIcon(Icon icon) {
        this.tabIcon = icon;
    }

    @Override
    public Icon getRunningIcon() {
        return this._runningIcon;
    }

    @Override
    public Icon getWaitingIcon() {
        return this._waitingIcon;
    }

    @Override
    public Icon getRanOKIcon() {
        return this._ranOkIcon;
    }

    public Icon getRanOkIcon() {
        return this._ranOkIcon;
    }

    public Icon getProblemIcon() {
        return this._problemIcon;
    }

    public StatementRunnerResultsPanel(String string, WorksheetContext worksheetContext, ISQLCommand iSQLCommand) {
        this.setContext(worksheetContext);
        this.m_id = string;
        this._connName = worksheetContext.getConnectionName();
        this.m_command = iSQLCommand;
        this._refreshAction = new ToggleAction(CreateDialogArb.getString((String)"DATAED_REFRESH"), OracleIcons.getIcon((String)"refresh.png")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                StatementRunnerResultsPanel.this.refresh();
            }
        };
        this._refreshAction.setName(this._refreshAction.getValue("Name").toString());
        String string2 = null;
        if (this.REFRESH_CMD_ID != this.NULL_CMD_ID) {
            try {
                this.setupAcceleratorToolTip(this._refreshAction, this.REFRESH_CMD_ID);
                this._toolbar.add(this._refreshAction);
            }
            catch (Exception exception) {
                string2 = exception.getMessage();
            }
        }
        this._refreshAction.setEnabled(true);
        HyperlinkButton hyperlinkButton = new HyperlinkButton(SQL);
        this.m_SQLAction = IdeAction.getEnabled((int)SQL_ID, (String)SQL);
        hyperlinkButton.setAction((Action)this.m_SQLAction);
        this.setupAcceleratorToolTip((ToggleAction)this.m_SQLAction, -1);
        this.m_SQLAction.addController(new Controller(){

            public boolean handleEvent(IdeAction ideAction, Context context) {
                if (ideAction.getCommandId() == AbstractWorksheetResultPanel.SQL_ID) {
                    StatementRunnerResultsPanel.this.showSQLWindow();
                    return true;
                }
                return false;
            }

            public boolean update(IdeAction ideAction, Context context) {
                return true;
            }
        });
        this.m_SQLAction.setName(this.m_SQLAction.getValue("Name").toString());
        hyperlinkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StatementRunnerResultsPanel.this.showSQLWindow();
            }
        });
        hyperlinkButton.setToolTipText(SQL + this.buildToolTip(SQL_ID));
        this._toolbar.add((ToggleAction)this.getDeleteGridActions());
        this._toolbar.add((Component)hyperlinkButton);
        this._toolbar.addSeparator();
        this._toolbar.add(Box.createHorizontalStrut(5));
        this.getStatusPanel().setOpaque(false);
        this.getStatusLabel().setOpaque(false);
        this._toolbar.add((Component)this.getStatusPanel());
        this._errArea.setEditable(false);
        this._table.setColumnSelectorAvailable(true);
        Substitution substitution = new Substitution(worksheetContext.getScriptRunnerContext());
        try {
            substitution.replaceSubstitution(iSQLCommand);
        }
        catch (Substitution.SubstitutionException substitutionException) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, substitutionException.getStackTrace()[0].toString(), substitutionException);
            throw new CancellationException();
        }
        Map map = BindDialog.getBindValues((String)iSQLCommand.getSql());
        if (map == null) {
            throw new CancellationException();
        }
        this._table.setQuery(this._connName, this.m_command.getSql(), null, map);
        this._table.getGridModel().autoApplyPersistedSort(false);
        this._table.registerConsumer((IStatusMessageConsumer)this);
        this._scrollPane = new JScrollPane((Component)this._table, 22, 30);
        JViewport jViewport = new JViewport();
        JTable jTable = this._table.getRowHeader();
        jViewport.setView(jTable);
        jViewport.setPreferredSize(jTable.getMaximumSize());
        this._scrollPane.setRowHeader(jViewport);
        this._resultsPanel.add((Component)this._scrollPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setLockableUI(new LockableUI());
        JXLayer jXLayer = new JXLayer((Component)this._resultsPanel, (LayerUI)this.getLockableUI());
        this._mainPanel.add((Component)jXLayer, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void open() {
        try {
            ArrayList<AbstractWorksheetTaskResultPanel.ResultsPanelTaskListener> arrayList = new ArrayList<AbstractWorksheetTaskResultPanel.ResultsPanelTaskListener>();
            arrayList.add(this.getTaskListener());
            arrayList.add((AbstractWorksheetTaskResultPanel.ResultsPanelTaskListener)this.getHistoryListener(this.m_command.getSQLOrig() + this.m_command.getStatementTerminator(), this._connName));
            List<WorksheetTaskUIListener> list = Collections.singletonList(new WorksheetTaskUIListener(this.getContext(), this.m_command));
            this._table.open(new RaptorGridTaskWrapper(this.getTabLabel(), IRaptorTaskRunMode.TASKVIEWER, true, arrayList, list, Collections.singletonList(this.getTaskViewer())));
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    private IRaptorTaskListener getHistoryListener(final String string, final String string2) {
        return new RaptorTaskAdapter(){
            boolean m_firstRun = true;

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                if (this.m_firstRun && !raptorTaskEvent.getTaskDescriptor().isCancelled()) {
                    SqlEditorHistory.saveSql(string.trim(), Connections.getDisplayName((String)string2), SqlEditorHistory.TYPE_SQL_HISTORY, StatementRunnerResultsPanel.this.getFetchTime(raptorTaskEvent));
                    this.m_firstRun = false;
                }
            }
        };
    }

    private void showSQLWindow() {
        if (this._resultsPanel.isShowing()) {
            if (this.gp != null && this.gp.isShowing()) {
                this.gp.setVisible(false);
            }
            this.gp = new GhostPalette((JComponent)this._resultsPanel);
            this.gp.setHideOnLoseFocus(true);
            this.gp.fadeInOut(true);
            this.gp.setLook(UIConstants.Look.LIGHT);
            int n = this._resultsPanel.getLocation().x;
            int n2 = this._resultsPanel.getLocation().y;
            Point point = new Point(n, n2);
            point = SwingUtilities.convertPoint(this._resultsPanel, point, null);
            this.gp.setLocation(point);
            this.gp.setTitle(this.getTabLabel() + " SQL");
            MultiLineLabel multiLineLabel = new MultiLineLabel();
            multiLineLabel.setTextWrapper(WordWrapper.getTextWrapper());
            multiLineLabel.setText(Connections.getDisplayName((String)this.getConnectionName()) + " : " + this.m_command.getSql());
            JScrollPane jScrollPane = new JScrollPane((Component)multiLineLabel, 20, 30);
            jScrollPane.setPreferredSize(new Dimension(this._resultsPanel.getSize().width / 2, this._resultsPanel.getSize().height / 2));
            final HyperlinkButton hyperlinkButton = new HyperlinkButton(Messages.getString("StatementRunnerResultsPanel.2"));
            hyperlinkButton.setBorder(BorderFactory.createEmptyBorder());
            hyperlinkButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StringSelection stringSelection = new StringSelection(StatementRunnerResultsPanel.this.m_command.getSql());
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    ClipboardStack.pushCurrentClipboard();
                    clipboard.setContents(stringSelection, stringSelection);
                    hyperlinkButton.setSelected(false);
                }
            });
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)jScrollPane, "Center");
            jPanel.add((Component)hyperlinkButton, "South");
            this.gp.add((Component)jPanel);
            this.gp.setSize(jScrollPane.getPreferredSize());
            this.gp.show(Ide.getMainWindow().getLayeredPane(), false, false);
        }
    }

    private IdeAction getDeleteGridActions() {
        if (this._deleteGridSettings == null) {
            this._deleteGridSettings = IdeAction.get((int)DELETE_GRID_SETTINGS_ID, null, (String)Messages.getString("RunQueryPanel.11"), null, null, (Icon)OracleIcons.getIcon((String)"remove_file.png"), null, (boolean)true);
            this.setupAcceleratorToolTip((ToggleAction)this._deleteGridSettings, -1);
            this._deleteGridSettings.addController(new Controller(){

                public boolean handleEvent(IdeAction ideAction, Context context) {
                    if (ideAction.getCommandId() == AbstractWorksheetResultPanel.DELETE_GRID_SETTINGS_ID) {
                        String string = Messages.getString("StatementRunnerResultsPanel.DeleteSettings.Pass");
                        if (StatementRunnerResultsPanel.this._table != null) {
                            if (RaptorGridPersistedSettings.deletePersistentSettings((RaptorGridTable)StatementRunnerResultsPanel.this._table)) {
                                try {
                                    if (StatementRunnerResultsPanel.this._table.isVisible()) {
                                        StatementRunnerResultsPanel.this._table.refresh();
                                    }
                                }
                                catch (ExecutionException executionException) {
                                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, executionException.getStackTrace()[0].toString(), executionException);
                                }
                            } else {
                                string = Messages.getString("StatementRunnerResultsPanel.DeleteSettings.Fail");
                            }
                            MessageDialog.information((Component)StatementRunnerResultsPanel.this._table, (Object)string, (String)Messages.getString("StatementRunnerResultsPanel.DeleteSettings.Title"), null);
                            return true;
                        }
                    }
                    return false;
                }

                public boolean update(IdeAction ideAction, Context context) {
                    return true;
                }
            });
        }
        return this._deleteGridSettings;
    }

    @Override
    public void clear() {
    }

    @Override
    public String getConnectionName() {
        return this._connName;
    }

    @Override
    public String getOutputText() {
        return null;
    }

    @Override
    public String getSQL() {
        return this.m_command.getSql();
    }

    @Override
    protected void initCommands() {
        this.CLEAR_CMD_ID = this.NULL_CMD_ID;
        this.SAVE_CMD_ID = this.NULL_CMD_ID;
    }

    public void setStatusMessage(final String string, final Exception exception) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                String string2 = string;
                if (exception != null) {
                    if (exception.getCause() instanceof CancellationException) {
                        StatementRunnerResultsPanel.this.createErrorComp(exception.getCause());
                    } else {
                        StatementRunnerResultsPanel.this.createErrorComp(exception);
                    }
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    @Override
    public JComponent getGUI() {
        return this;
    }

    @Override
    public String getID() {
        return this.m_id;
    }

    @Override
    public WorksheetState getState() {
        return this.m_state;
    }

    @Override
    public String getTabLabel() {
        return this.m_tabName;
    }

    @Override
    public String getTabToolTip() {
        return "<html>" + Connections.getDisplayName((String)this.getConnectionName()) + " : " + this.m_command.getSQLOrig() + "</html>";
    }

    @Override
    public boolean isCloseable() {
        return true;
    }

    @Override
    public void setState(WorksheetState worksheetState) {
        this.m_state = worksheetState;
    }

    @Override
    public void setTabLabel(String string) {
        this.m_tabName = string;
    }

    public void tabClosed() {
        if (this._table != null) {
            this._table.closeModel();
            this._table.unRegisterConsumer((IStatusMessageConsumer)this);
        }
    }

    protected void refresh() {
        this.setTabIcon(this._runningIcon);
        this._resultsPanel.remove(this._errArea);
        this._resultsPanel.add((Component)this._scrollPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        try {
            this._table.refresh();
        }
        catch (ExecutionException executionException) {
            this.createErrorComp(executionException);
        }
    }

    public final boolean isNotPLSQL(String string) {
        boolean bl = string.equals(SQLCommand.StmtSubType.G_S_INSERT) || string.equals(SQLCommand.StmtSubType.G_S_UPDATE) || string.equals(SQLCommand.StmtSubType.G_S_DELETE) || string.equals(SQLCommand.StmtSubType.G_S_SELECT) || string.equals(SQLCommand.StmtSubType.G_S_MERGE) || string.equals(SQLCommand.StmtSubType.G_S_WITH);
        return bl;
    }

    @Override
    protected void createErrorComp(Throwable throwable) {
        this.setTabIcon(this._problemIcon);
        if (!(throwable instanceof CancellationException)) {
            this._errArea.setText("");
            String string = null;
            int n = -1;
            SQLException sQLException = null;
            if (throwable != null) {
                TaskException taskException;
                if (throwable instanceof SQLException) {
                    sQLException = (SQLException)throwable;
                } else if (throwable.getCause() instanceof SQLException) {
                    sQLException = (SQLException)throwable.getCause();
                } else if (throwable.getCause() instanceof TaskException && (taskException = (TaskException)throwable.getCause()).getCause() instanceof SQLException) {
                    sQLException = (SQLException)taskException.getCause();
                }
                if (sQLException != null && (string = sQLException.getLocalizedMessage()) != null && string.indexOf("ORA") > -1) {
                    taskException = new Oerr();
                    try {
                        string = string + taskException.oerr(string);
                        n = DBUtil.getInstance((String)this.getConnectionName()).getErrorOffset(this.m_command.getSql());
                    }
                    catch (OerrException oerrException) {
                        // empty catch block
                    }
                }
                if (string == null) {
                    string = throwable instanceof CancellationException || throwable.getCause() instanceof CancellationException ? Messages.getString("RunQueryPanel.10") : throwable.getLocalizedMessage();
                }
            }
            if (n < 1) {
                this._errArea.setText(string);
            } else {
                this._errArea.setText(string + "\n" + this.getCommandDetails(n));
            }
            this._resultsPanel.remove(this._scrollPane);
            this._resultsPanel.add((Component)this._errArea, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    private String getCommandDetails(int n) {
        Object[] objectArray = null;
        if (n != -1) {
            int n2 = this.m_command.getStartLine() + 1;
            objectArray = SQLErrorDialog.getLineAndColumn((String)this.m_command.getSql(), (int)n, (int)n2, (int)1);
        }
        return MessageFormat.format(oracle.dbtools.raptor.dialogs.Messages.getString((String)"SQLErrorDialog.10"), objectArray);
    }

    @Override
    public boolean printOutput() {
        try {
            if (this._scrollPane != null && this._scrollPane.isShowing()) {
                this._table.getGridModel().fetchAllRows(true);
                this._table.print();
                return true;
            }
            if (this._errArea != null && this._errArea.isShowing()) {
                return Utility.printText((String)this.getTabLabel(), (String)this._errArea.getText());
            }
        }
        catch (PrinterException printerException) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, printerException.getStackTrace()[0].toString(), printerException);
        }
        catch (ExecutionException executionException) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, executionException.getStackTrace()[0].toString(), executionException);
        }
        return false;
    }

    @Override
    float getFetchTime(RaptorTaskEvent raptorTaskEvent) {
        if (this._table != null && this._table.getGridModel() != null) {
            return this._table.getGridModel().getFetchTime();
        }
        return super.getFetchTime(raptorTaskEvent);
    }
}

